<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\UserRequest;


use App\Services\PlantService;
use App\Models\User;
use App\Models\Plant;
use Spatie\Permission\Models\Role;
use DB;
use Hash;
use Illuminate\Support\Arr;

class UserController extends Controller
{



 public function __construct(


    ) {
        $this->middleware('auth');
        $this->middleware('permission:show-users', ['only' => ['index']]);
        $this->middleware('permission:add-users', ['only' => ['create', 'store']]);
        $this->middleware('permission:edit-users', ['only' => ['edit', 'update']]);
        $this->middleware('permission:destroy-users', ['only' => ['destroy']]);

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $data = User::orderBy('id','DESC')->get();


        return view('admin.users.index',compact('data'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $roles = Role::pluck('name','name')->all();
        $plants=Plant::where('deleted_at',null)->pluck('name','name')->all();

        return view('admin.users.create',compact('roles','plants'));
    }

    /**
     * @param UserRequest $request
     * @return mixed
     */
    public function store(UserRequest $request)
    {
        // dd('hi');
        $input = $request->all();
        // dd($input);
         $input['roles']=$request['roles'][0];

        // dd( $input['roles']);
        $role = Role::whereName($input['roles'])->firstOrFail();
        $input['role']=$role->id;
        // dd('1');
        // dd( $input['roles']);

        $input['plants']=$request['plants'][0];
    //    dd( $input['plants']);
         $plant = Plant::whereName($input['plants'])->firstOrFail();
        $input['plant']=$plant->id;
        // dd( $input['plants']);
        // dd('1');
        $input['password'] = Hash::make($input['password']);
        $input['confirm-password'] = Hash::make($input['confirm-password']);

        // dd($input);

        $user = User::create($input);
        // dd($user);
        $user->assignRole($request->input('roles'));
       // dd('hi');

        return redirect()->route('users.index')
                        ->with('success','User created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $user = User::find($id);
        // dd($user);
        $roleId=$user->role;
        // dd($roleName);
        $roleName= Role::where('id',$roleId)->value('name');
        // dd($roleName);
        return view('admin.users.show',compact('user','roleName'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = User::find($id);
        $roles = Role::pluck('name','name')->all();
        $userRole = $user->roles->pluck('name','name')->all();

        $plants=Plant::where('deleted_at',null)->pluck('name','name')->all();

        $userPlant =Plant::where('id',$user->plant)->pluck('name','name')->all();
//dd($userPlant);
       //dd($user);
        return view('admin.users.edit',compact('user','roles','userRole','plants','userPlant'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //dd('hi');
       $rules = [
    'name' => 'required',
    'email' => 'required|email|unique:users,email,'.$id,
    'roles' => 'required',
];

if (!empty($request->input('confirm-password'))) {
    // If the password field is not empty, include validation for it
    $rules['password'] = 'same:confirm-password';
}
$this->validate($request, $rules);

        $input = $request->all();
          //dd($input);

        //dd($input);
        $input['roles']=$request['roles'][0];

        //dd( $input['roles']);
        $role = Role::whereName($input['roles'])->firstOrFail();
        $input['role']=$role->id;

         $input['plants']=$request['plants'][0];
         $plant = Plant::whereName($input['plants'])->firstOrFail();
        $input['plant']=$plant->id;
       // dd($input['role']);
        if(!empty($input['password'])){
            $input['password'] = Hash::make($input['password']);
        }else{
            $input = Arr::except($input,array('password'));
        }

        $user = User::find($id);
        $user->update($input);
        DB::table('model_has_roles')->where('model_id',$id)->delete();

        $user->assignRole($request->input('roles'));

        return redirect()->route('users.index')
                        ->with('success','User updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        User::find($id)->delete();
        return redirect()->route('users.index')
                        ->with('success','User deleted successfully');
    }
}
