@extends('layouts.structure')

@section('content')
<!-- Required meta tags -->
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<!-- CSRF Token -->
<meta name="csrf-token" content="{{ csrf_token() }}">
<!-- favicon -->
<link rel="icon" href="{{ asset('assets/images/logo-globe.png') }}" type="image/png" />
<!-- plugins -->
<link href="{{ asset('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet" />
<link href="{{ asset('assets/plugins/vectormap/jquery-jvectormap-2.0.2.css') }}" rel="stylesheet" />
<link href="{{ asset('assets/plugins/simplebar/css/simplebar.css') }}" rel="stylesheet" />
<link href="{{ asset('assets/plugins/perfect-scrollbar.css') }}" rel="stylesheet" />
<!-- loader -->
<link href="{{ asset('assets/css/pace.min.css') }}" rel="stylesheet" />
<script src="{{ asset('assets/js/pace.min.js') }}"></script>
<!-- Bootstrap CSS -->
<link href="{{ asset('assets/css/bootstrap.min.css') }}" rel="stylesheet">
<link href="{{ asset('assets/css/bootstrap-extended.css') }}" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
<link href="{{ asset('assets/css/app.css') }}" rel="stylesheet">
<link href="{{ asset('assets/css/icons.css') }}" rel="stylesheet">
<!-- Theme Style CSS -->
<link rel="stylesheet" href="{{ asset('assets/css/dark-theme.css') }}" />
<link rel="stylesheet" href="{{ asset('assets/css/semi-dark.css') }}" />
<link rel="stylesheet" href="{{ asset('assets/css/header-colors.css') }}" />

<!-- Inline CSS to fix extra margin after headers and form alignment -->
<style>
    .card-header {
        margin-bottom: 0 !important;
        padding-bottom: 0.5rem !important;
    }
    .page-content {
        padding-top: 0.5rem !important;
    }
    .card {
        margin-bottom: 1rem !important;
    }
    .date-range-form label {
        font-size: 0.85rem;
    }
    .date-range-form input, .date-range-form button {
        height: 30px;
        font-size: 0.85rem;
    }
    .chart-container-1 {
        width: 100% !important;
        height: 400px !important; /* Adjust height as needed */
    }
    #chart1 {
        width: 100% !important;
        height: 100% !important;
    }
</style>

<!--start page wrapper -->
<div class="page-wrapper mt-0">
    <div class="page-content">
        <!-- Date Range Form -->
        <div class="row mb-3">
            <div class="col-12 col-md-6 col-xl-4 offset-md-6 offset-xl-8">
                <form id="dateRangeForm" method="GET" action="{{ route('home') }}">
                    <div class="date-range-form d-flex align-items-end gap-2">
                        <div class="flex-grow-1">
                            <label for="start_date" class="form-label mb-0 text-secondary">Start Date:</label>
                            <input type="date" class="form-control form-control-sm" id="start_date" name="start_date"
                                   value="{{ $startDate->format('Y-m-d') }}" required>
                        </div>
                        <div class="flex-grow-1">
                            <label for="end_date" class="form-label mb-0 text-secondary">End Date:</label>
                            <input type="date" class="form-control form-control-sm" id="end_date" name="end_date"
                                   value="{{ $endDate->format('Y-m-d') }}" required>
                        </div>
                        <div>
                            <button type="submit" class="btn btn-primary btn-sm">Apply</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        @if (session('error'))
            <div class="alert alert-danger">{{ session('error') }}</div>
        @endif

        <div class="row row-cols-1 row-cols-md-2 row-cols-xl-4">
            <div class="col">
                <div class="card radius-10 border-start border-0 border-4 border-info">
                    <a href="{{ route('inward.index') }}">
                    <div class="card-body">
                                <div class="d-flex align-items-center">

                                    <div style="cursor: pointer;">
                                        <p class="mb-0 text-secondary">Total Coils</p>
                                        <h4 class="my-1 text-info">{{ $totalInwardsDisplay ?? '0 | 0 TON' }}</h4>
                                        <!-- <p class="mb-0 font-13">{{ $inwardsChange ?? 'No change' }}</p> -->
                                    </div>


                                    <div class="widgets-icons-2 rounded-circle bg-gradient-blues text-white ms-auto">
                                        <i class='bx bxs-cart'></i>
                                    </div>
                                </div>
                            
                        </div>
                        </a>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-4 border-danger">
                     <a href="{{ route('plans.indexStatus', 'Under Production') }}">
                    <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div>
                                        <p class="mb-0 text-secondary">Total Plans Under Production</p>
                                        <h4 class="my-1 text-danger">{{ $plansUnderProductionDisplay ?? '0 TON' }}</h4>
                                        <!--<p class="mb-0 font-13">{{ $plansChange ?? 'No change' }}</p>-->
                                    </div>
                                    <div class="widgets-icons-2 rounded-circle bg-gradient-burning text-white ms-auto">
                                        <i class='bx bxs-wallet'></i>
                                    </div>
                                </div>
                        </div>
                        </a>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-4 border-success">
                    <a href="{{ route('plans.indexStatus', 'Completed') }}">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div>
                                        <p class="mb-0 text-secondary">Finished Goods</p>
                                        <h4 class="my-1 text-success">{{ $finishedGoodsDisplay ?? '0 TON' }}</h4>
                                        <!--<p class="mb-0 font-13">{{ $finishedGoodsChange ?? 'No change' }}</p>-->
                                    </div>
                                    <div class="widgets-icons-2 rounded-circle bg-gradient-ohhappiness text-white ms-auto">
                                        <i class='bx bxs-bar-chart-alt-2'></i>
                                    </div>
                                </div>
                            </div>
                        </a>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-4 border-warning">
                    <a href="{{ route('dispatches.index') }}">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div>
                                        <p class="mb-0 text-secondary">Dispatched Goods</p>
                                        <h4 class="my-1 text-warning">{{ $dispatchedGoodsDisplay ?? '0 TON' }}</h4>
                                        <!--<p class="mb-0 font-13">{{ $dispatchedGoodsChange ?? 'No change' }}</p>-->
                                    </div>
                                    <div class="widgets-icons-2 rounded-circle bg-gradient-orange text-white ms-auto">
                                        <i class='bx bxs-group'></i>
                                    </div>
                                </div>
                            </div>
                        </a>
                </div>
            </div>
        </div>

        <!-- inward and dispatch bar graph -->
        <div class="row">
            <div class="col-12 col-lg-8 d-flex">
                <div class="card radius-10 w-100">
                    <div class="card-header">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0">Inward and Dispatch Overview</h6>
                            </div>
                            <div class="dropdown ms-auto">
                                <a class="dropdown-toggle dropdown-toggle-nocaret" href="#"
                                   data-bs-toggle="dropdown"><i class='bx bx-dots-horizontal-rounded font-22 text-option'></i></a>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="javascript:;">Action</a></li>
                                    <li><a class="dropdown-item" href="javascript:;">Another action</a></li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li><a class="dropdown-item" href="javascript:;">Something else here</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center ms-auto font-13 gap-2 mb-3">
                            <span class="border px-1 rounded cursor-pointer"><i class="bx bxs-circle me-1"
                                                                               style="color: #14abef"></i>Inwards</span>
                            <span class="border px-1 rounded cursor-pointer"><i class="bx bxs-circle me-1"
                                                                               style="color: #ffc107"></i>Dispatched</span>
                        </div>
                        <div class="chart-container-1">
                            <canvas id="chart1"></canvas>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-4 d-flex">
                <div class="card radius-10 w-100">
                    <div class="card-header">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0">Inward Dispatch Daily Ratio</h6>
                            </div>
                            <div class="dropdown ms-auto">
                                <a class="dropdown-toggle dropdown-toggle-nocaret" href="#"
                                   data-bs-toggle="dropdown"><i class='bx bx-dots-horizontal-rounded font-22 text-option'></i></a>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="javascript:;">Action</a></li>
                                    <li><a class="dropdown-item" href="javascript:;">Another action</a></li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li><a class="dropdown-item" href="javascript:;">Something else here</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="chart-container-2">
                            <canvas id="chart2"></canvas>
                        </div>
                    </div>
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex bg-transparent justify-content-between align-items-center">
                            Inward <span class="badge bg-primary rounded-pill">{{ $inwardRatio ?? '0' }}</span>
                        </li>
                        <li class="list-group-item d-flex bg-transparent justify-content-between align-items-center">
                            Dispatch <span class="badge bg-warning text-dark rounded-pill">{{ $dispatchRatio ?? '0' }}</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- 2nd row graphs -->
        <div class="row">
            <!-- scrap grid -->
            <div class="col-12 col-lg-5 col-xl-4 d-flex">
                <div class="card w-100 radius-10">
                    <div class="card-body">
                        <div class="card radius-10 border shadow-none">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div>
                                        <p class="mb-0 text-secondary">Total Scrap</p>
                                        <h4 class="my-1">{{ $totalScrapDisplay ?? '0 TON' }}</h4>
                                        <!--<p class="mb-0 font-13">{{ $scrapChange ?? 'No change' }}</p>-->
                                    </div>
                                    <div class="widgets-icons-2 bg-gradient-cosmic text-white ms-auto">
                                        <i class='bx bxs-trash'></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card radius-10 border shadow-none">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div>
                                        <p class="mb-0 text-secondary">Total Scrap Dispatched</p>
                                        <h4 class="my-1">{{ $scrapDispatchedDisplay ?? '0 TON' }}</h4>
                                        <!--<p class="mb-0 font-13">{{ $scrapDispatchedChange ?? 'No change' }}</p>-->
                                    </div>
                                    <div class="widgets-icons-2 bg-gradient-ibiza text-white ms-auto">
                                        <i class='bx bxs-truck'></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- scrap grid end -->

            <!-- Polar Chart for Inward, Under Production, Dispatched, Scrap -->
            <div class="col-12 col-lg-5 col-xl-4 d-flex">
                <div class="card radius-10 w-100">
                    <div class="card-header bg-transparent">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0">Coil Ratio</h6>
                            </div>
                            <div class="dropdown ms-auto">
                                <a class="dropdown-toggle dropdown-toggle-nocaret" href="#"
                                   data-bs-toggle="dropdown"><i class='bx bx-dots-horizontal-rounded font-22 text-option'></i></a>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="javascript:;">Action</a></li>
                                    <li><a class="dropdown-item" href="javascript:;">Another action</a></li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li><a class="dropdown-item" href="javascript:;">Something else here</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="chart-container-1">
                            <canvas id="chart17"></canvas>
                        </div>
                    </div>
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex bg-transparent justify-content-between align-items-center border-top">
                            Inward <span class="badge bg-gradient-deepblue rounded-pill">{{ $coilInward ?? '0' }}</span>
                        </li>
                        <li class="list-group-item d-flex bg-transparent justify-content-between align-items-center">
                            Under Production <span class="badge bg-gradient-orange rounded-pill">{{ $coilUnderProduction ?? '0' }}</span>
                        </li>
                        <li class="list-group-item d-flex bg-transparent justify-content-between align-items-center">
                            Dispatched <span class="badge bg-gradient-blooker rounded-pill">{{ $coilDispatch ?? '0' }}</span>
                        </li>
                        <li class="list-group-item d-flex bg-transparent justify-content-between align-items-center">
                            Scrap <span class="badge bg-gradient-quepal rounded-pill">{{ $coilScrap ?? '0' }}</span>
                        </li>
                    </ul>
                </div>
            </div>
            <!-- End Polar Chart -->

            <!-- top 5 clients -->
            <div class="col-12 col-lg-7 col-xl-4 d-flex">
                <div class="card radius-10 w-100">
                    <div class="card-header bg-transparent">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0">Top 5 Clients</h6>
                            </div>
                            <div class="dropdown ms-auto">
                                <a class="dropdown-toggle dropdown-toggle-nocaret" href="#"
                                   data-bs-toggle="dropdown"><i class='bx bx-dots-horizontal-rounded font-22 text-option'></i></a>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="javascript:;">Action</a></li>
                                    <li><a class="dropdown-item" href="javascript:;">Another action</a></li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li><a class="dropdown-item" href="javascript:;">Something else here</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-3 col-xl-12">
                                @if (!empty($topClients))
                                    @foreach($topClients as $client)
                                        <div class="mb-4">
                                            <p class="mb-2">
                                                <!--<i class="flag-icon flag-icon-{{ $client['flag'] ?? 'in' }} me-1"></i>-->
                                                {{ $client['name'] ?? 'Unknown Client' }} <span class="float-end">{{ $client['percentage'] ?? 0 }}%</span>
                                            </p>
                                            <div class="progress" style="height: 7px;">
                                                <div class="progress-bar bg-{{ $client['color'] ?? 'primary' }} progress-bar-striped"
                                                     role="progressbar" style="width: {{ $client['percentage'] ?? 0 }}%"></div>
                                            </div>
                                        </div>
                                    @endforeach
                                @else
                                    <p class="mb-0 text-secondary">No clients found for the selected period.</p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- top 5 clients end -->
        </div>
        <!--end row-->
    </div>
</div>
<!--end page wrapper -->

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Bootstrap JS -->
<script src="{{ asset('assets/js/bootstrap.bundle.min.js') }}"></script>
<!-- Other Plugins -->
<script src="{{ asset('assets/plugins/simplebar/js/simplebar.min.js') }}"></script>
<script src="{{ asset('assets/plugins/metismenu/js/metisMenu.min.js') }}"></script>
<script src="{{ asset('assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script>
<script src="{{ asset('assets/plugins/vectormap/jquery-jvectormap-2.0.2.min.js') }}"></script>
<script src="{{ asset('assets/plugins/vectormap/jquery-jvectormap-world-mill-en.js') }}"></script>
<script src="{{ asset('assets/plugins/chartjs/js/chart.js') }}"></script>
<script src="{{ asset('assets/plugins/sparkline-charts/jquery.sparkline.min.js') }}"></script>
<script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js') }}"></script>
<script src="{{ asset('assets/plugins/notifications/js/notifications.min.js') }}"></script>
<script src="{{ asset('assets/js/index3.js') }}"></script>
<script src="{{ asset('assets/js/app.js') }}"></script>

<!-- Chart Initialization -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Set up AJAX with CSRF token
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // Chart 1: Bar
        const ctx1 = document.getElementById('chart1').getContext('2d');
        const chart1 = new Chart(ctx1, {
            type: 'bar',
            data: {
                labels: [],
                datasets: [
                    {
                        label: 'Inwards',
                        data: [],
                        backgroundColor: '#14abef',
                        borderColor: '#14abef',
                        borderWidth: 1
                    },
                    {
                        label: 'Dispatched',
                        data: [],
                        backgroundColor: '#ffc107',
                        borderColor: '#ffc107',
                        borderWidth: 1
                    }
                ]
            },
            options: {
                responsive: true,
                scales: {
                    y: { beginAtZero: true }
                }
            }
        });

        // Chart 2: Doughnut
        const ctx2 = document.getElementById('chart2').getContext('2d');
        const chart2 = new Chart(ctx2, {
            type: 'doughnut',
            data: {
                labels: ['Inward', 'Dispatch'],
                datasets: [{
                    data: [{{ $inwardRatio ?? 0 }}, {{ $dispatchRatio ?? 0 }}],
                    backgroundColor: ['#14abef', '#ffc107'],
                    borderColor: ['#14abef', '#ffc107'],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: { position: 'top' }
                }
            }
        });

        // Chart 3: Polar Area
        const ctx17 = document.getElementById('chart17').getContext('2d');
        const chart17 = new Chart(ctx17, {
            type: 'polarArea',
            data: {
                labels: ['Inward', 'Under Production', 'Dispatch', 'Scrap'],
                datasets: [{
                    data: [{{ $coilInward ?? 0 }}, {{ $coilUnderProduction ?? 0 }}, {{ $coilDispatch ?? 0 }}, {{ $coilScrap ?? 0 }}],
                    backgroundColor: ['#14abef', '#ff9800', '#00bcd4', '#4caf50'],
                    borderColor: ['#14abef', '#ff9800', '#00bcd4', '#4caf50'],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: { position: 'top' }
                }
            }
        });

        // Function to update charts
        function updateChartData(startDate, endDate) {
            $.ajax({
                url: '{{ route("dashboard.data") }}',
                method: 'GET',
                data: {
                    start_date: startDate,
                    end_date: endDate
                },
                success: function(data) {
                    chart1.data.labels = data.labels;
                    chart1.data.datasets[0].data = data.inwards;
                    chart1.data.datasets[1].data = data.dispatched;
                    chart1.update();

                    chart2.data.datasets[0].data = [data.inwardRatio, data.dispatchRatio];
                    chart2.update();

                    chart17.data.datasets[0].data = [data.coilInward, data.coilUnderProduction, data.coilDispatch, data.coilScrap];
                    chart17.update();
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching chart data:', error);
                }
            });
        }

        // Initial chart data load
        updateChartData('{{ $startDate->format('Y-m-d') }}', '{{ $endDate->format('Y-m-d') }}');

        // Form submission handler
        $('#dateRangeForm').on('submit', function(e) {
            const startDate = $('#start_date').val();
            const endDate = $('#end_date').val();
            if (startDate && endDate) {
                updateChartData(startDate, endDate);
            }
        });
    });
</script>
@endsection