@extends('layouts.structure')


@section('content')
    <div class="container">


        <div class="card">
                <div class="card-header">
                    <h4 class="mt-4"> Create User</h4>
                </div>
            <div class="card-body p-4">

                <form action="{{ route('users.store') }}" method="POST" class="row g-3">
                    @csrf

                    <div class="col-md-7">
                        <div class="form-group">
                            <strong>Name:</strong>
                            <input type="text" name="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name')}}">
                            @include('admin.partials.form-errors', array('field' => 'name'))
                        </div>
                    </div>
                    <div class="col-md-7">
                        <div class="form-group">
                            <strong>Email:</strong>
                            <input type="text" name="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email')}}">
                            @include('admin.partials.form-errors', array('field' => 'email'))
                        </div>
                    </div>
                    <div class="col-md-7">
                        <div class="form-group">
                            <strong>Password:</strong>
                            <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" value="{{ old ('password')}}">
                            @include('admin.partials.form-errors', array('field' => 'password'))
                        </div>
                    </div>
                    <div class="col-md-7">
                        <div class="form-group">
                            <strong>Confirm Password:</strong>
                            <input type="password" name="confirm-password" class="form-control @error('confirm-password') is-invalid @enderror"  value="{{old('confirm-password')}}">
                            @include('admin.partials.form-errors', array('field' => 'confirm-password'))
                        </div>
                    </div>
                    <div class="col-md-7">
                        <div class="form-group">
                            <strong>Role:</strong>
                            {!! Form::select('roles[]', $roles,[], array('class' => 'form-control','multiple')) !!}
                        </div>
                    </div>
                    <div class="col-md-7">
                        <div class="form-group">
                            <strong>Plant:</strong>
                            {!! Form::select('plants[]', $plants,[], array('class' => 'form-control')) !!}
                        </div>
                    </div>
                    <div class="col-md-7">
                        <div class="form-group">
                            <strong>Mobile:</strong>
                            <input type="text" name="mobile" class="form-control @error('mobile') is-invalid @enderror" value="{{ old('mobile')}}">
                            @include('admin.partials.form-errors', array('field' => 'mobile'))
                        </div>
                    </div>
                    <div class="col-md-7">
                        <div class="form-group">
                            <strong>Address:</strong>
                            <input type="text" name="Address" class="form-control @error('Address') is-invalid @enderror" value="{{ old('address')}}">
                            @include('admin.partials.form-errors', array('field' => 'Address'))
                        </div>
                    </div>
                    {{-- Submit Button--}}
                    <div class="col-md-12">
                        <div class="d-md-flex d-grid align-items-center gap-3">
                            <button type="submit" class="btn btn-success btn-sm px-4">Create</button>
                            <a href="{{ route('users.index') }}" class="btn btn-danger btn-sm px-4">Cancel</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
