@extends('layouts.structure')


@section('content')
    <div class="container">


        <div class="card">
                <div class="card-header">
                    <h4 class="mt-4"> Edit User</h4>
                </div>
            <div class="card-body p-4">

    {!! Form::model($user, ['method' => 'PATCH','route' => ['users.update', $user->id]]) !!}

                    <div class="col-md-7">
                        <div class="form-group">
                            <strong>Name:</strong>
                            {!! Form::text('name', null, array('placeholder' => 'Name','class' => 'form-control')) !!}
                        </div>      
                    </div>
                    <div class="col-md-7">
                    <div class="form-group">
                                <strong>Email:</strong>
                                {!! Form::text('email', null, array('placeholder' => 'Email','class' => 'form-control')) !!}
                    </div>     
                   </div>
                    <div class="col-md-7">
                    <div class="form-group">
                        <strong>Password:</strong>
                        {!! Form::password('password', array('placeholder' => 'Password','class' => 'form-control')) !!}
                    </div>    
                    </div>
                    <div class="col-md-7">
                        <div class="form-group">
                            <strong>Confirm Password:</strong>
                            {!! Form::password('confirm-password', array('placeholder' => 'Confirm Password','class' => 'form-control',
                            'value' => $user->password)) !!}
                        </div>
                    </div>
                    <div class="col-md-7">
                        <div class="form-group">
                            <strong>Role:</strong>
                            {!! Form::select('roles[]', $roles,$userRole, array('class' => 'form-control')) !!}
                        </div>           
                    </div>
                    <div class="col-md-7">
                            <div class="form-group">
                                <strong>Plant:</strong>
                                {!! Form::select('plants[]', $plants,$userPlant, array('class' => 'form-control')) !!}
                            </div>      
                    </div>
                    <div class="col-md-7">
                        <div class="form-group">
                            <strong>Mobile:</strong>
                            {!! Form::text('mobile', null, array('placeholder' => 'Mobile','class' => 'form-control')) !!}
                        </div>          
                    </div>
                    <div class="col-md-7">
                        <div class="form-group">
                            <strong>Address:</strong>
                            {!! Form::textarea('address', null, array('placeholder' => 'Address','class' => 'form-control')) !!}
                        </div>      
                    </div>
                    {{-- Submit Button--}}
                    <div class="col-md-12 mt-2">
                        <div class="d-md-flex d-grid align-items-center gap-3">
                            <button type="submit" class="btn btn-success btn-sm px-4">Create</button>
                            <a href="{{ route('users.index') }}" class="btn btn-danger btn-sm px-4">Cancel</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
