@extends('layouts.structure')

@section('content')
<div class="container my-5">
    <div class="card shadow">
        <div class="card-body">
            <h3>Roles <a href="{{ route('roles.create') }}" class="btn btn-sm btn-primary float-end">Add Role</a></h3>
            <table class="table table-bordered mt-3">
                <thead>
                    <tr>
                        <th>#</th><th>Name</th><th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($roles as $index => $role)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $role->name }}</td>
                        <td>
                            <a href="{{ route('roles.edit', $role->id) }}" class="btn btn-sm btn-warning">Edit</a>
                            <form action="{{ route('roles.destroy', $role->id) }}" method="POST" style="display:inline-block">
                                @csrf @method('DELETE')
                                <button class="btn btn-sm btn-danger" onclick="return confirm('Delete?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
