<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\LineController;
use App\Http\Controllers\ManufacturerTypeController;
use App\Http\Controllers\PlantController;
use App\Http\Controllers\RowController;
use App\Http\Controllers\InwardController;
use App\Http\Controllers\PlanController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('layouts.app');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');


//login
Route::middleware('guest')->group(function () {
    Route::view('/login', 'auth.login')->name('login'); //view login page
    Route::post('/login', [AuthController::class, 'login'])->name('login.post');
});

//logout
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');



Route::group(['middleware' => ['auth']], function () {

//Plant
Route::get('/add-plant',[PlantController::class,'create'])->name('plant.create');
Route::post('/add-plant', [PlantController::class, 'store'])->name('plant.store');
Route::get('/show-plant',[PlantController::class,'index'])->name('plant.index');
Route::get('/edit-plant/{id}', [plantController::class, 'edit'])->name('plant.edit');
Route::put('/plant/{id}', [plantController::class, 'update'])->name('plant.update');
Route::delete('/delete-plant/{id}', [plantController::class,'destroy'])->name('plant.destroy');




//Line
Route::get('/add-line',[LineController::class,'create'])->name('line.create');
Route::post('/add-line', [LineController::class, 'store'])->name('line.store');
Route::get('/show-line',[LineController::class,'index'])->name('line.index');
Route::get('/edit-line/{id}', [lineController::class, 'edit'])->name('line.edit');
Route::put('/line/{id}', [lineController::class, 'update'])->name('line.update');
Route::delete('/delete-line/{id}', [lineController::class,'destroy'])->name('line.destroy');


//Row
Route::get('/add-row',[RowController::class,'create'])->name('row.create');
Route::post('/add-row', [RowController::class, 'store'])->name('row.store');
Route::get('/show-row',[RowController::class,'index'])->name('row.index');
Route::get('/edit-row/{id}', [rowController::class, 'edit'])->name('row.edit');
Route::put('/row/{id}', [rowController::class, 'update'])->name('row.update');
Route::delete('/delete-row/{id}', [rowController::class,'destroy'])->name('row.destroy');


//ManufacturerType
Route::get('/add-manufacturer-type',[ManufacturerTypeController::class,'create'])->name('manufacturer-type.create');
Route::post('/add-manufacturer-type', [ManufacturerTypeController::class, 'store'])->name('manufacturer-type.store');
Route::get('/show-manufacturer-type',[ManufacturerTypeController::class,'index'])->name('manufacturer-type.show');
Route::get('/edit-manufacturer-type/{id}', [ManufacturerTypeController::class, 'edit'])->name('manufacturer-type.edit');
Route::put('/manufacturer-type',[ManufacturerTypeController::class,'index'])->name('manufacturer-type.update');
Route::delete('/delete-manufacturer-type',[ManufacturerTypeController::class,'index'])->name('manufacturer-type.destory');


//Inward
Route::resource('inward', 'App\Http\Controllers\Admin\InwardController');
Route::get('/inward/{id}/{inward_id}/destroyCoilDetails', 'App\Http\Controllers\Admin\InwardController@destroyCoilDetails')->name('inward.destroyCoilDetails');

// Route::get('/inward',[InwardController::class,'create'])->name('inward.create');
// Route::post('/add-inward', [InwardController::class, 'store'])->name('inward.store');
// Route::get('/show-inward',[InwardController::class,'index'])->name('inward.index');
// Route::get('/edit-inward/{id}', [InwardController::class, 'edit'])->name('inward.edit');
// Route::put('/inward/{id}', [InwardController::class, 'update'])->name('inward.update');
// Route::delete('/delete-inward/{id}', [InwardController::class,'destroy'])->name('inward.destroy');
//search Grade
Route::get('getgradessearch', 'App\Http\Controllers\Admin\InwardController@getGradesSearch')->name('getgradessearch');

//plan
Route::get('plan',[PlanController::class,'create'])->name('plan.create');
Route::post('add-plan',[PlanController::class,'store'])->name('plan.store');
Route::get('getCrrinfoInward/{crr_no}',[PlanController::class,'getCrrinfoInward'])->name('getCrrinfoInward');


});
