<?php

namespace Faker\Provider\uk_UA;

class Text extends \Faker\Provider\Text
{
    /**
     * From uk.wikisource.org
     *
     * Текст доступний на умовах ліцензії Creative Commons Attribution/Share-Alike,
     * також можуть діяти додаткові умови. Детальніше див. Умови використання.
     *
     *
     * Title: Захар Беркут
     *
     * Author: Іван Франко
     *
     * Posting Date: July 19, 2007
     * Release Date: 1882
     * [Last updated: November 14, 2012]
     *
     * Language: Ukrainian
     *
     * @see     https://wikimediafoundation.org/wiki/Terms_of_Use/
     * @see    http://uk.wikisource.org/wiki/%D0%97%D0%B0%D1%85%D0%B0%D1%80_%D0%91%D0%B5%D1%80%D0%BA%D1%83%D1%82
     *
     * @var string
     */
    protected static $baseText = <<<'EOT'

I

Cумно і непривітно тепер в нашій Тухольщині! Правда, і Стрий, і Опір
однаково миють її рінисті зелені узбережжя, луги її однаково
покриваються весною травами та цвітами, і в її лазуровім, чистім
повітрі однаково плавле та колесує орел беркут, як і перед давніми
віками. Але все інше як же змінилося!

І ліси, і села, і люди! Що давно ліси густі, непрохідні закривали
майже весь її простір, окрім високих полонин, сходили в долину аж над
самі ріки,- тепер вони, мов сніг на сонці, стопилися, зрідли, змаліли,
декуди пощезали, лишаючи по собі лисі облази; інде знов із них
остоялися лише пообсмалювані пеньки, а з-між них де-де несміло
виростає нужденна смеречина або ще нужденніший яловець. Що давно тихо
тут було, не чути ніякого голосу, крім вівчарської трембіти десь на
далекій полонині або рику дикого тура чи оленя в гущавинах,- тепер на
полонині гейкають воларі, а в ярах і дебрях галюкають рубачі, трачі й
ґонтарі, ненастанно, мов невмирущий черв, підгризаючи та підтинаючи
красу тухольських гір - столітні ялиці та смереки, і або спускаючи

їх, потятих на великі ботюки, долі потоками до нових парових тартаків,
або таки на місці ріжучи на дошки та на ґонти.

Але найбільше змінилися люди. Зверха глянувши, то немовби змоглася між
ними «культура», але на ділі виходить, що змоглося тільки їх число.
Сіл і присілків більше, хат по селах більше, але зате по хатах
убожество більше і нужда більша. Народ нужденний, прибитий, понурий,
супроти чужих несмілий

і недотепний. Кождий дбає тільки про себе, не розуміючи того, що таким
робом роздроблюються їх сили, ослаблюється громада. Не так тут колись
було! Хоч менше народу, та зате що за народ! Що за життя кипіло в тих
горах, серед тих непрохідних борів у стіп могутнього Зелеменя! Лиха
доля довгі віки знущалася над тим народом. Тяжкі удари підкопали його
добробут, нужда зломила його свобідну, здорову вдачу, і нині тільки
неясні, давні спомини нагадують правнукам щасливіше життя предків. І
коли часом стара бабуся, сидячи в запічку та прядучи грубу вовну,
почне розповідати дрібним унукам про давню давнину, про напади
монголів-песиголовців і про тухольського ватажка Беркута,- діти
слухають тривожно, в їх сивих оченятах блискотять сльози. А коли
скінчиться дивовижна повість, то малі й старі, зітхаючи, шепчуть: «Ах,
яка ж то красна байка!»

- Так, так,говорить бабуся, похитуючи головою,так, так, дітоньки! Для
- нас то байка, а колись то правда була!

- А не знати, чи вернуться ще коли такі часи,закидає дехто старший.

- Говорять старі люди, що ще колись вернуться, але, мабуть, аж перед
- кінцем світу.

Сумно і непривітно тепер в вашій Тухольщині! Казкою видається повість
про давні часи і давніх людей. Вірити не хотяіь нинішні люди, що
виросли в нужді й притиску, в тисячолітніх путах і залежностях. Але
нехай собі! Думка поета летить у ті давні часи, оживляє давніх людей,
а в кого серце чисте і щиро- людське чуття, той і в них побачить своїх
братів, живих людей, а в життю їх, хоч і як неподібнім до нашого,
догляне не одно таке, що може бути пожадане і для наших «культурних»
часів.

Було се 1241 року. Весна стояла в тухольських горах.

Одної прегарної днини лунали лісисті пригірки Зеле-меня голосами
стрілецьких рогів і криками численних стрільців.

Се новий тухольський боярин, Тугар Вовк, справляв великі лови на грубу
звірину. Він святкував почин свого нового життя,- бо недавно князь
Данило дарував йому в Тухольщині величезні полонини і ціле одно
пригір'я Зе-леменя; недавно він появився в тих горах і побудував собі
гарну хату, і оце першу учту справляє, знайомиться з довколичними
боярами. По учті рушили на лови в ту- хольські ліси.

Лови на грубого звіра - то не забавка, то боротьба тяжка, не раз
кровава, не раз на життя і смерть. Тури, медведі дики - се небезпечні
противники; стрілами з луків рідко кому удасться повалити такого
звіра; навіть рогатиною, яку кидалось на противника при відповіднім
приближенню, нелегко дати йому раду. Тож остатньою і рішучою зброєю
було важке копіє, яким треба було влу чити противника зблизька.
власноручно, з цілою силою, відразу. Схиблений удар - і життю борця
грозила велика небезпека, коли йому не вдалось в остатній хвилі
сховатись у безпечну криївку і добути меча або тяжкого топора для
своєї оборони.

Не диво, отже, що Тугар зі своїми гістьми вибирався на лови, мов на
війну, з запасом стріл і рогатин, зі слугами й запасами живності,
навіть з досвідним знахарем, що вмів замовляти рани. Не диво також, що
Тугар і його гості були в повній рицарській зброї, окрім панцирів, бо
ті спиняли би їх у ході по ломах та гущавинах. Те тільки диво, що й
Тугарова донька Мирослава, не поки-даючись батька, посміла також
вирушити разом з гістьми на лови. Тухольські громадяни, видячи її, як
їхала на лови посеред гостей, гордо, сміло, мов стрімка тополя серед
коренастих дубів, з уподобою поводили за нею очима, поговорюючи:

- От дівчина! Тій не жаль би бути мужем. І, певно, ліпший з неї би був
- муж, ніж її батько!

А се, певно, була немала похвала, бо Тугар Вовк був мужчина, як дуб.

Плечистий, підсадкуватий, з грубими обрисами лиця і грубим чорним
волоссям, він і сам по-добав на одного з тих злющих тухольських
медведів, яких їхав воювати. Але ж бо й донька його Мирослава була
дівчина, якої пошукати. Не кажемо вже про її уроду й красу, ані про її
добре серце - в тім згляді багато її ровесниць могло стати з нею
нарівні, хоч і небагато могло перевищити її. Але в чім не мала вона
пари між своїми ровесницями, так се в природній свободі свого
поводження, в незвичайній силі мускулів, у смілості й рішучості,
властивій тільки мужчинам, що виросли в ненастанній боротьбі з
супротивними обставинами. Зараз з першого разу видно було, що
Мирослава виросла на свободі, що виховання її було мужеське і що в тім
прегарно розвиненім дівочім тілі живе сильний, великими здібностями
обдарований дух. Вона була в батька одиначка, а до того, ще зараз при
народженню втратила матір. Нянька її, стара мужичка, відмалку
направляла її до всякої ручної роботи, а коли підросла, то батько, щоб
розважити свою самоту, брав її всюди з собою і, щоб задовольнити її
палку натуру, привчив її владати рицарського зброєю, зносити всякі
невигоди і сміло стояти в небезпеках. І чим більші трудності їй
прихопилось поборювати, тим охітніше бралась вона за діло, тим краще
проявлялася сила її тіла й її рішучого, прямого характеру. Але попри
все те Мирослава ніколи не переставала бути жен-щиною: ніжною, доброю,
з живим чуттям і скромним, стидливим лицем, а все те лучилось в ній у
таку дивну, чаруючу гармонію, що хто раз бачив її, чув її мову,- той
довіку не міг забути її лиця, її ходу, її голосу,- тому вони
пригадувалися живо і виразно в найкращих хвилях його життя, так, як
весна навіть старому старцеві пригадує його молоду любов.

Вже третій день тривали лови. Багато оленів-рогачів і чорногривих
турів лягло головами від стріл і ратищ боярських. Над шумним гірським
потоком, на зеленій поляні серед лісу стояли шатра ловців, курілися
раз у раз величезні огнища, де висіли на гаках кітли, оберталися
рожна, де варилось і пеклось м'ясиво вбитої дичини для гостей.
Нинішній, остатній, день ловів мав бути посвячений самому головному,
та заразом і найбільше небезпечному ділу - ловам на медведів.

На стрімкім пригірку, відділенім від інших страшними дебрями, порослім
густо величезними буками та смереками, покритім ломами й обвалищами
дерев, було віддавна головне леговище медведів. Тут, як твердив
тухольський провідник, молодий гірняк Максим Беркут, гніздилася
медведяча матка. Відси дикі звірі розносили пострах на цілу околицю і
на всі полонини. І хоч не раз удавалось смілим вівчарям забити одного
або другого стрілами та топорами або завабити під сліп, де йому ламала
крижі важка колода, спадаючи вниз,- то все-таки число їх було надто
велике, щоб із того була значна полегша для околиці. То й не дивно, що
коли новоприбулий боярин Тугар Вовк оповістив тухольцям, що хотів би
зробити великі лови на медведів і просить дати йому провідника, вони
не тільки дали йому на провідника першого удальця на всю

Тухольську верховину Максима Беркута, сина тухольського бесідника
Захара, але, крім того, вирядили з власної волі цілий відділ пасем-ців
з луками й ратищами для помочі зібраним боярам. Ціла та громада мала
обступити медведяче леговище і очистити його доразу від поганого
звіра.

Від самого досвіта в ловецькім таборі великий рух і тривожне
дожидання.

Боярські слуги від півночі звивалися, приготовляючи для гостей їду на
цілий день, наповнюючи шипучим медом і яблучником "подорожні баклаги.

Тухольські пасемці й собі готовились, острячи ножі та тесаки, обуваючи
міцні жуброві постоли і складаючи в невеличкі дорожні бесаги печене
м'ясо, паляниці, сир і все, що могло понадобитися в цілоденній трудній
переправі.

Максим Беркут, який аж нині, супроти найважнішого і найтяжчого діла,
почув себе вповні самим собою, вповні начальником сеї невеличкої
армії, зарядясував з правдиво начальницькою вважливістю й повагою все,
що належало до діла, нічого не забуваючи, ні з чим не кваплячись, але
й ні з чим не опізню-ючись. Все у нього виходило в свій час і на своїм
місці, без сумішки й сутолоки; всюди він був, де його потрібно, всюди
вмів зробити лад і порядок. Чи то між своїми товаришами-тухольцями, чи
між боярами, чи між слугами, Максим Беркут усюди був однаковий -
спокійний, свобідний в рухах

і словах, мов рівний серед рівних. Товариші поводились з ним так само,
як він з ними, сво-бідно, несилувано, сміялись і жартували з ним, а
проте виповнювали його розкази точно, швидко і так весело та радо,
немов і самі без розказу були би в тій хвилі зробили те саме. Боярська
служба, хоч далеко не такої рівної вдачі, далеко не так свобідна в
поводженню, далеко похіпніша з одних гордо висміватися, а перед
другими низенько хилитися, все ж таки поважала Максима Беркута за його
звичайність і розсудливість і, хоч не без до-тинків та жартів, таки
робила те, що він казав. А й самі бояри, по більшій часті люди горді,
воєнні, що нерадо бачили «смерда» в своїм товаристві, та й то ще
смерда, що вважав їх чимось немов собі рівним,- і вони тепер не
показували надто виразно своєї неохоти і виповнювали розпорядження
молодого провідника, маючи на кож-дім кроці нагоду переконатися, що ті
розпорядження були зовсім розумні, такі, як треба.

Ще сонечко не зараз мало сходити, а вже ловецьке товариство вирушило з
табору. Глибока тиша стояла над горами; нічні сумерки дрімали під
темно- зеленими коронами смерек; на густім, чепіргатім листю папороті
висіли краплі роси; повзучі зелені поясники вилися попід ноги,
плуталися поміж корінням величезних вивертів, спліталися в непрохідні
клебуки з корчами гнучкої, колючої ожини та з сплетами дикого пнучого
хмелю. З пропадистих, чорних, мов горла безодні, дебрів піднімалася
сивими туманами пара - знак, що на дні тих дебрів плили невеличкі
лісові потоки. Повітря в лісі напоєне було тою парою й запахом живиці;
воно захоплювало дух, немовбито ширших грудей треба було, щоб дихати
ним свобідно.

Мовчки пробиралася ловецька дружина непрохідними нетрями, дебрями й
ломами без стежки, без ніяких провідних знаків у тьмавій гущавині.
Попереду йшов Максим Беркут, а за ним Тугар Вовк і інші бояри. Обік
Ту-гара йшла його донька Мирослава. Позаду йшли тухоль-ські пасемці.
Всі йшли озираючись і надслухували пильно.

Ліс починав оживати денним життям. Пестропера сойка хрипіла в вершках
смерек, зелена жовна, причепив-шися до пня тут же над головами
прохожих, довбала своїм залізним дзьобом кору; в далеких зворах чути
було рик турів і виття вовків. Медведі в ту пору, наївши-ся, дрімали
під ломами на моховій постелі. Стадо диків рохкало десь у дебрі,
холодячися в студенім намулі.

Може, годину йшло товариство тою трудною, нетоптаною дорогою. Всі
дихали важко, ледве можучи наловити грудьми повітря, всі отирали
краплистий піт із лиць. Максим частенько озирався позад себе. Він
зразу противний був тому, щоб і женщина йшла разом з мужами в той
небезпечний похід, але Мирослава уперлася. Вона ж перший раз була на
таких великих ловах і мала би для бог зна яких трудностей занехати
найкращу їх частину!

Ніякі Максимові докази про трудності дороги, про небезпеки на
становищі, про силу й лютість звіра не могли переконати її. «Тим
ліпше! Тим ліпше!» - говорила вона з таким смілим поглядом, з таким
солодким усміхом, що

Максим, мов очарований, не міг нічого більше сказати. І батько, що
зразу також радив Мирославі лишитися в таборі, вкінці мусив уступити
її просьбам.

З подивом глядів тепер Максим, як ота незвичайна женщина поровень з
найсильнішими мужами поборювала всякі трудності утяжливої дороги, як
легко перескакувала гнилі ломи і величезні грами, яким певним кроком
ішла понад урвища, горі стрімкими дебрями, просковзу-вала поміж
виверти, і при тім так безпечно, так невтоми-мо, що Максимові
здавалося, що вона хіба на яких чудових крилах уноситься. Він глядів
на се й не міг нагля-дітися.

«Дивна дівчина! - думалось йому раз по разу.- Такої я ще й не видав
«ніколи!»

Ось уже прийшли на місце. Медведяче леговище - то був високий, тільки
від південного боку з трудом доступний горб, покритий грубезними
буками й смереками, завалений вивертами й ломами. Від півночі, заходу
і сходу вхід 1 вихід замикали високі скалисті стіни, немов величезною
сокирою вирубані з тіла велетня Зелеменя і відсунені від нього на
кільканадцять сажнів; сподом попід ті стіни вузькою щілиною шумів і
пінився студе-ний гірський потік.

Таке положення улегшувало нашим ловцям роботу; вони потребували тільки
обсадити не надто широкий плай від південного боку і тим плаєм
доступати чимраз далі догори, а звір, не маючи іншого виходу, мусив
конечно попастися в їх руки і на їх ратища.

Опинившися на тім важнім, хоч дуже небезпечнім плаю, Максим Беркут
велів товариству на хвилю розло-житися і спочити, аби набрати сил до
трудного діла. Сонце сходило, але гілля смерек і сусідні горби
заслоню-вали його вид.

По короткім віддиху Максим почав розставляти ловців у два ряди так,
аби вповні обсадити плай. Доки плай ще вузький, кождому ловцеві
прийдеться стояти о п'ять кроків від другого; але дальше вгорі, де
плай розширяється в цілу споховасту площину, там прийдеться ловцям
ширше розступитися. Одно тільки клопотало його: що зробити з
Мирославом, яка конче хотіла й собі стояти на окремім становищі, а не
при боці свого батька.

- А що ж то я гірша отсих твоїх пасемців? говорила вона, рум'яніючись,
- мов рожа, до Максима.їх ти ставиш на становищі, а мене не хочеш… Ні,
- сього не буде! І для мого батька се був би стид, коли б нас двоз
- стояло на однім становищі! Правда, батеньку?

Тугар Вовк не міг їй супротивитися. Максим почав говорити їй про
небезпеку, про силу й лютість розжертого звіра, але вона зацитькала
його:

- А що ж то в мене нема сили? А що ж то я не владаю луком, ратищем і
- топором? Ану, нехай котрий-будь із твоїх ласемців спробує зо мною
- порівнятися,побачимо, хто дужчий!

Максим вкінці замовк і мусив учинити її волю. Та й чи міг спротивитися
тій дивній, чарівній дівчині? Він хотів хоч становище визначити їй
найменше небезпечне, але, на лихо, сього не можна було зробити, бо тут
усі становища були однаково небезпечні. Розстановивши ціле товариство,
Максим дав ось який розпорядок:

- Тепер помолімся, кому хто знає, а потім разом заграймо в роги. Се
- буде перший знак і сполошить звіра. Потім підемо горі плаєм і
- станемо аж там, де він розширюється. Там мої товариші лишаться
- пильнувати виходу, щоб ані один звір не уйшов, а ви, бояри, підете
- дальше, до самого матчиного леговища!

В добру хвилю по тім залунали ліси й полонини хрипливим ревом жубрових
рогів. Немов величезна хвиля, покотився голос по лісах і зворах,
розбиваючися, глухнучи, то знов подвоюючись. Пробуркалися ліси.

Заскиглила каня над верховіттям смереки; зляканий беркут, широко
розмахуючи крилами, піднявся на воздухи; захрустів звір поміж ломами,
шукаючи безпечної криївки. Нараз рик рогів утих і ловці пустилися в
дорогу горі плаєм. Усіх серця билися живіше ожиданням незвісних
небезпек, бою і побіди. Обережно пробирались вони рядами; передом ряд
боярський, за ним парубоцький ряд;

Максим ішов попереду, пильно надслухаючи та слідячи звірину. Цар
ломів, медвідь, ще не показувався.

Дійшли вже до самого найвужчого гирла, поза яким плай розширювався в
велику споховасту площину. Ловці знов тут зупинилися на розказ
Максима, і знов загриміли ще з більшою силою жуброві роги, розносячи
тривогу в сумрачні медведячі гаври. Раптом затріщав лім недалеко, за
величезною купою грубих перегнилих вивертів.

- Бачність! скрикнув Максим.Звір наближається!

Ледве сказав ті слова, коли втім крізь велику щілину між двома
переверненими пнями просунулася пелехата, величезна голова, і двоє
сірих очей напівпікаво, напів-тривожно вдивлялися в Тугара Вовка, що
стояв на своїм становищі, якраз о яких десять кроків перед щілиною.
Тугар був старий вояк і старий ловець,- він не знав, що то тривога.
Тож, не говорячи ані слова, не відзиваючись ні до ксго, він вихопив
важку залізну стрілу з сагайдака, положив на лук і намірявся до звіра.

- Міряй в око, боярине! шепнув з-позаду Максим. Хвилька тривожної
- мовчанки свиснула стріла і заревів звір мов скажений, кинувши собою
- взад.

І хоть через те щез він ловцям з очей, скрившися за купою вивертів, то
ревіт його не втихав і не втихало скажене ше-метання.

- Далі за ним! крикнув Тугар Вовк і кинувся до щілини, кудою щез
- медвідь.

Рівночасно два бояри вже видряпалися були на верх виверту, вже
попіднімали свої ратища і старались дати їм відповідний розмах, аби
доконати звіра. Тугар

Вовк, стоячи в щілині, пустив у нього другою стрілою. Звір заревів ще
дужче і кинувся втікати, але очі його заплили кров'ю, він не міг
знайти виходу і розщибав собою о дерева. Ратище одного боярина впилось
йому між ребра, але не завдало смертельної рани. Дикий рик раненого
медведя розлягався чимраз дужче. В розпуці він підводився на задні
лапи, обтирав собі кров з очей, рвав і кидав галуззям наперед себе,
але дарма; одно його око прошиблене було стрілою, а друге раз у раз
запливало кров'ю наново.

Шемечучись наосліп довкола, звір наблизився знов до Гугара Вовка. Той
відкинув лук і, причаївшися за виваленим коренем, ухопив обіруч свій
важкий топір і, коли медвідь, мацаючи, добирався до знайомої собі
щілини, він з усього розмаху цюкнув його згори в голову, аж череп
розколовся надвоє, мов розбита тиква. Бризнув кровавий мозок на
боярина, тихо, без рику повалився звір додолу. Радісно заревли труби
бояр на знак першої побіди.

Звіра витягнено з-поміж вивертів і обдерто зі шкури. Тоді бояри рушили
дальше, в гущавину. Сонце вже піднялось на небі і меркотіло крізь
гілляки, мов скісні золоті нитки та пасма. Ловці йшли тепер геть-геть
веселіше, перехвалюючися своєю відвагою й силою.

- Хоч я лише вовк, дрібна звірюка, то все ще дам раду тухольському
- медведеві! говорив Тугар Вовк, радіючи.

Максим Беркут слухав тих перехвалок і сам не знав, чому йому жаль
зробилося тухольського медведя.

- Що ж,сказав він,дурна звірюка той медвідь, самотою держиться. Якби
- вони зібралися докупи, то хто знає, чи й стадо вовків дало би їм
- раду.

Тугар позирнув на нього гнівно, але не сказав нічого. Ловці обережно
поступали дальше, дряпаючись по вивертах, перескакуючи з пня на пень,
западаючи не раз по пояс у порохно та ломи.

Посеред тих звалищ величної природи виднілися подекуди медведячі
стежки, протоптані від давніх-давен, вузькі, але добре втоптані, густо
засіяні вибіленими кістками баранів, оленів та всякої іншої звірини.
Максим держався тепер позаду бояр; він раз за разом обходив усі
становища, осмотрював сліди, щоб догадатися, чи вони свіжі, чи ні,
підпомагав, заохочував утомлених,- і тільки на нім однім не знати було
ніякої втоми. З подивом позирала на нього

Мирослава, коли він переходив коло неї, і хоч багато досі видала вона
молодців і сильних, і смілих, але такого, як Максим, що сполучав би в
собі всі прикмети сильного робітника, рицаря і начальника,- такого їй
досі не траплялося бачити.

Нараз захрустів лім і грізно-люто випав на ловців величезний медвідь.
Він біг зразу на чотирьох лапах, але, побачивши перед собою ворогів,
звівся на задні лапи, а в передні вхопив бурею відламаний буковий
конар, викручуючи ним довкола себе і видаючи час від часу з горла
уриваний, немов визиваючий рик.

На становищі супроти звіра були два підгірські бояри, з тих, що
найголосніше перехвалювалися і хотіли перед усіми показатися
мисливцями. Побачивши страшного ворога тут же перед собою, вони
зблідли й затремтіли. Але скритися, тікати не уходило,- треба було
ставити чоло, будь-що-будь. Дві стріли вилетіли рівночасно з двох
луків, але одна хибила, свиснувши медведеві понад вуха, а друга
влучила звіра в бік, не зранивши значно, а тільки роздразнивши
безмірно. Величезним скоком підплигнув медвідь і шпурнув на одного
ловця свою зброю - буковий копар, який зі страшною силою гепнувся о
дерево. Тоді, не зупиняючись ані на хвильку і не даючи ворогам часу до
намислу, медвідь кинувся на одного з них, що саме стояв па його
протоптаній стежці. Ратище блисло в тремтячій руці боярина,- він хотів
кинути ним на звіра.

- Не кидай! крикнув тривожно Максим, надбігаючи і ведучи з собою поміч
- загроженим боярам Тугара Вовка і ще одного боярина.Не кидай ратище,
- але настав поприбіч і боронися!

Але боярин не слухав і кинув ратище на звіра. Розмах був невеликий,
рука боярина тремтіла, медвідь був уже на яких п'ять кроків,- от і не
диво, що ратище слабо зранило звіра в передню лопатку. Вхопив медвідь
дрючину, розломив її і зі страшним риком кинувся на свого ворога. Той
держав уже в руках простого, на оба боки острого меча, що його називав
медвідником, і готовився віпхнути його вістря в груди звірові. Але
вістря поховз-лося по кості

і застряло в лопатці, і звір ухопив боярина в свої страшні, залізні
обійми.

Страшенно скрикнула нещаслива жертва; захрустіли кості під медведячими
губами. Ціла та страшна і дрожжю проймаюча подія скоїлася так раптово,
так несподівано, що, заким Максим міг надбігти з підмогою, вже боярин,
хриплячи в передсмертних судорогах, лежав на землі, а над ним стояв
кровавий медвідь, вискаливши свої страшенні зуби і ревучи на весь ліс
з болю від одержаних ран.

Дрож пройшла у всіх по тілі на той вид; бояри стали мов укопані.
Тільки

Максим спокійно наложив стрілу на свій роговий лук, підійшов два кроки
ближче до мед-ведя і, прицілившися одну хвилину, пустив йому стрілу
просто в серце. Мов ножем перетятий, урвався рик звіра, і він
повалився трупом на землю.

Не ревіли роги, не лунали веселі оклики по тій новій побіді. Бояри,
покинувши свої становища, збіглися на місце нещастя. Хоч і як вони
були загартовані в війнах, привикли бачити смерть біля себе, але вид
кровавого, потрощеного та пошарпаного трупа витиснув із усіх грудей
важкий зойк.

Мирослава вхопилась за груди і відвернула очі. Тухольські пасемці на
сплетені з галуззя мари положили трупа, а за ним потягли і медведя.
Понура мовчанка залягла над товариством. Велика калюжа крові
блискотіла до сонця і нагадувала всім, що тут іще перед хвилею стояв
живий чоловік, батько дітям, веселий, охочий і повний надії, а тепер з
нього лишилася лише безформна купа кровавого м'яса. У великої часті
бояр відійшла охота до ловів.

- Цур їм, тим проклятим медведям! говорили деякі.Нехай тут хоч жиють,
- хоч гинуть собі, чи ж нам для них наражувати своє життя?

Але Тугар Вовк, а особливо Мирослава й Максим, налягали конче, аби
кінчити розпочате діло. Бояри вкінці пристали, але якось дуже не раді
були вертати на свої становища.

- Позвольте мені, бояри, слово сказати,заговорив до них Максим.Мої
- товариші-тухольці замкнули вихід і не пустять ані одного звіра
- відси. Тим-то нам не потрібно розходитися віддалік одним від одних.
- Найліпше буде, думаю, розділитися нам на дві ровти і йти понад самі
- краї пропасті по обох боках. Так ми зможемо найліпше зігнати все до
- середини, а там разом з тухольськи-ми пасемцями обступимо густою
- лавою і вистріляємо до одного.

- Авжеж, авжеж, що так ліпшеї крикнули деякі бояри, не бачачи
- насмішливого усміху, що перелетів по устах Максима.

Тоді товариство розділилося. Одну ровту провадив Тугар Вовк, а другу

Максим. Мирослава з власної охоти прилучилася до другої ровти, хоч і
сама не могла собі вияснити, для чого. Мабуть, шукала небезпеки, бо
Максим виразно казав, що дорога другої ровти небезпечніша.

Знов заграли роги, і обі ровти розійшлися. Ловці йшли де парами, де
одинцем, то сходячись, то розходячись, щоб вишукувати дорогу. Купами
йти було зовсім неможливо. Зближались уже до самого верха; верх сам
був голий, але понижче був цілий вал каміння, звалищ і вивертів. Туди
пройти було найтрудніше і найнебезпечніше.

В однім місці стирчала купа звалищ, мов висока башта. Ломаччя, каміння
і навіяне від давніх-давен листя загороджувало, бачилось, усякий
приступ до природної твердині. Максим поповз понад самим краєм
глибочезної пропасті, чіпляючись де-де моху та скальних обривів, щоб
туди винайти прохід. Бояри ж, не навиклі до таких неприступних і
карколомних доріг, пішли здовж валу, надіючись найти далі перерву і
обійти його.

Мирослава зупинилася, немов щось держало її близ Максима; Гі бистрі
очі вдавлювалися пильно в настобур-чену перед нею стіну лому, шукаючи
хоч би й як трудного проходу. Недовго так і вдивлялася, але сміло
почала вдиратися на великі кам'яні брили та виверти, що завалювали
прохід. Стала на версі і гордо озирнулася довкола. Бояри відійшли вже
були досить далеко, Максима не видно, а перед нею безладна сутолока
скал та ломів, через яку, бачилось, прохід був неможливий. Але ні! Он
там, трохи віддалік, лежить величезна смерека кладкою понад те пекло,-
туди безпечно можна перейти до вершка!

Недовго думаючи, Мирослава пустилася на ту кладку. А вступаючи на неї,
ще раз озирнулася і, горда зі свого відкриття, приложила гарно точений
ріг до своїх коралових уст і затрубила на весь ліс. Луна покотилася
полонинами, розбиваючись у дебрях та зворах чимраз на більше часток,
аж поки не сконала десь у далеких, недоступних гущавинах. На голос
Мирославиного рога відізвався здалека ріг її батька, а там і роги
інших бояр. Ще хвильку завагувалася Мирослава, стоячи високо на
виверті. Смерека була дуже стара і наскрізь порохнява, а всподу, в
непроглядній гущавині ломів, здавалось їй, що чує легкий хрускіт і
муркотання. Прислухалася ліпше - не чути нічого. Тоді вона сміло
ступила на свою кладку. Але ледве уйшла з п'ять кроків, коли разом
затріщала перетрупішіла смерека, зламалася під ногами Мирослави, і
сміла дівчина враз із перегнилим грамом упала додолу, в ломи та
звалища.

Впала на ноги, не попускаючись своєї зброї. В руках стискала сильно
сріблом оковане ратище; через плечі у неї висіли міцний лук і сагайдак
зі стрілами, а за гарним шкіряним поясом, що мов вилитий обхапував її
стрункий дівочий стан, застромлений був топір і широкий мисливський
ніж з кістяними черенцями.

Звалившись несподівано в тьмаву пропасть, вона, проте, не почула ані
на хвилю страху, а тільки почала озиратися довкола, щоб догледіти який
вихід.

Зразу не могла нічого виразно добачити, але швидко її очі привикли до
півсумерку, і тоді побачила такий вид, котрий і найсмілішого міг
перейняти смертельною тривогою. Не далі як на п'ять кроків перед нею
лежала величезна медведиця в гнізді коло своїх молодих і гнівними,
зеленкуватими очима гляділа на несподіваного гостя. Мирослава
затремтіла. Чи вдаватися в боротьбу зі страшним звіром, чи шукати
виходу і спровадити поміч? Але нелегко було знайти вихід: довкола
їжилися ломи й обриви скал, і хоч перелізти через них з тяжким трудом
було би можна, то на очах дикого звіра була така робота крайнє
небезпечна. Недовго надумуючись, рішилася

Мирослава не зачіпати звіра, лиш боронитися в разі нападу, а тим часом
дати трубою тривожний знак і закликати поміч. Але скоро тільки вона
затрубила, медведиця схопилася з леговища і, виючи, кинулась до неї.
Не час було

Мирославі братися до лука,- звір був надто близько. Вона вхопила обома
руками ратище і, опершись плечима о кам'яний облаз, наставила його
насупротив медведиці. Звір, побачивши блискуче залізне вістря,
зупинився.

Обі неприятельки стояли так довгу хвилю, не зводячи ока одна з одної,
не схибляючи ані одним рухом зі свого становища. Мирослава не сміла
перша нападати на медведицю; медведиця знов шукала очима, куди би
напасти на ворога. Раптом медведиця вхопила в передні лапи великий
камінь і, зводячись на задні ноги, хотіла шпурнути ним на Мирославу.
Але в тій самій хвилі, коли зводилася на задні ноги, Мирослава одним
могучим рухом пхнула їй ратище між передні лопатки. Рикнула страшенно
медведиця і перевернулась горілиць, обіллявшися кров'ю. Але рана не
була смертельна, і медведиця швидко зірвалася на ноги. Кров текла з
неї, та, незважаючи на біль, вона знов кинулася на Мирославу.
Небезпека була страшна. Розжертий звір садив просто, грозячи вже тепер
своїми страшними зубами. Один рятунок для Мирослави був - видряпатися
на облаз, о котрий була оперта плечима. Хвилька, один рух - і вона
стояла на облазі. На серці в неї полегшало,- тепер її положення не
було таке небезпечне, бо в разі нападу могла вдарити звіра згори. Та
ледве

Мирослава могла дослідити, що робить медведиця, а вже звірюка стояла
близько неї на камені, ревучи грізно і рознявши закровавлену пащеку.
Зимний піт виступив на чолі Мирослави; вона бачила, що тепер настала
рішуча хвиля, що на тій вузькій кам'яній плиті мусить розігратися
боротьба на життя і смерть

і що того буде побіда, хто зможе вдержатися на іім становищі й
зіпхнути з нього противника. Медведиця була вже близько; Мирослава
пробувала заставитися від неї ратищем, але медведиця вхопила дрючину
зубами і шарпнула її так сильно, що мало не зіпхнула Мирославу з
каменя; ратище виховзлось їй із рук, і звір кинув ним геть у ломи.

«Тепер прийдеться загибати?» - блиснуло в думці в Мирослави, але
«відвага не покинула її. Вона вхопила обома руками топір і стала міцно
«до остатньої оборони. Звір сунув чимраз ближче: гарячий його віддих
«чула вже Мирослава на своїм лиці; мохната лапа, насторожена острими
«кігтями, грозила її груді; ще хвиля - і їй довелось би, пошарпаній,
«кровавій, упасти з каменя, бо топорище було закоротке супроти лап
«величезного звіра.

- Рятунку! скрикнула у смертельній тривозі Мирослава, і в тій хвилі
- понад її головою блиснуло ратище і пхнута в горло медведиця, мов
- колода, впала з каменя. В щілині кам'яних звалищ понад головою
- Мирослави показалось радісне» живим огнем палаюче лице Максима
- Беркута. Один вдячний погляд урятованої дівчини пройняв Максима
- наскрізь. Але слова не було між ним ані одного. На те не було часу.
- Медведиця ще жила і, ревучи, зірвалася з місця.

Одним скоком була вона коло своїх молодих, що, не розуміючи цілої тої
боротьби, бавилися і переверталися в гнізді. Обнюхавши їх, медведиця
кинулася знов до Мирослави. На се Мирослава була приготована і,
піднявши обіруч топір, одним замахом розрубала ним голову медведиці.
Впала опосочена звірюка і, метнувши собою кілька разів у боки,
сконала.

Тим часом і Максим, продертися крізь навалені ломи, станув обік
Мирослави.

В очах дівчини заблисли дві перлові сльози, і, не кажучи ані слова,
вона гаряче стиснула руку свого порятівника. Максим чогось немов
змішався, почервонів, спустив очі і, зупиняючись, проговорив:

- Я чув твій тривожний знак… але не знав, де ти… Богу дякувати, що й
- так додряпався!

Мирослава все ще стояла на місці, держачи руку гарного парубка в своїй
руці і дивлячись у його хороше, сонцем опалене і здоровим рум'янцем
осяяне, одверте, щире лице. В тій хвилі вона не почувала нічого, крім
вдячності за рятунок від нехибної смерті. Але коли Максим, трохи
осмілившись, стиснув її ніжну, а так сильну руку, тоді Мирослава
почула, як щось солодко защеміло їй коло серця, як лице її загорілось
стидливим рум'янцем,- і вона спустила очі, а слово подяки, котре
готове було вилетіти з її уст, так і завмерло на губах і розіллялось
по лиці дивним чаром розгоряючого сердечного чуття.

Максим перший отямився. В його серці, смілім і чистім, як щире золото,
відразу блиснула щаслива думка, котра тут же перемінилася в незломне
рішення. Се вернуло йому всю смілість і певність поступування.
Приложивши ріг до уст, він затрубив радісно на знак побіди. Тут же, за
стіною вивертів, обізвалися роги Тугара й інших бояр. Звинна, як
вивірка, Мирослава швидко видряпалась назад на той вал, з якого була
впала, і відтам оголосила цілому стрілецькому товариству свою пригоду
і поміч, якої дізнала від Максима. З трудом видряпався сюди Тугар
Вовк, а за ним і інші бояри; Тугар довго держав доньку в обіймах, а
побачивши кров на її одежі, аж затремтів.

- І ти, ти, моя доню, була в такій небезпеці! І він раз по разу
- обнімав доньку, немов боячись утратити її.

Потім він зліз униз до Максима, що порався коло мед-ведиці і коло
молодих медведят. Молоді, що не знали ще свого ворога в чоловіці,
муркотіли любенько в гнізді і бавились собі, мов малі песики; вони
давали себе гладити руками і зовсім не боялися людей. Максим узяв їх
на руки і положив перед

Мирославою й Тугаром.

- Отеє ваша здобич! сказав він.Ви чей же радо приймете в своїм домі
- таких гостей.

Згромаджені бояри гляділи то радісно на малі медве-дята, то зо страхом
на вбиту медведицю, обзирали рану і подивляли силу й смілість
Мирослави, що могла вдатися в боротьбу з такою страшною звірюкою.

- О ні,сказала, сміючись, Мирослава,без помочі отсього чесного молодця
- була б я тепер лежала там, як сеся звірюка, пошарпана й
- закровавлена! Йому від мене належиться велика подяка.

Тугар Вовк якось немов нерадо слухав тої бесіди своєї доньки. Хоч і як
він любив її, хоч і як радувався її вибавленням із великої небезпеки,
але все-таки він волів би був, якби вибавив його доньку боярський син,
а не сей простий тухольський мужик, не сей «смерд», хоч і як, зрештою,
той смерд умів подобатися Тугарові. Та всетаки йому, гордому
бояринові, що виріс і великої честі дослужився при князівськім дворі,
важко було прилюдно віддавати подяку за вирятування доньки - мужикові.
Але ніщо було діяти… Обов'язок вдячності так був глибоко вкорінений у
наших рицарських предків, що й Ту- гар Вовк не міг від нього
виламатися. Він узяв Максима за руку і випровадив його наперед.

- Молодче,сказав він,донька моя, єдина моя дитина, говорить, що ти
- вирятував її життя з великої небезпеки. Я не маю причини не вірити
- її слову.

Прийми ж за своє чесне діло подяку вітця, котрого вся любов і вся
надія в тій одній дитині. Я не знаю, чим тобі можемо відплатити за се
діло, але будь певний, що скоро се коли-будь буде в моїй силі, то
боярин Тугар Вовк не забуде того, що тобі завдячує.

Максим стояв при тих словах, мов на грані. Він не привик до таких
прилюдних похвал і зовсім не надіявся, ані не бажав нічого подібного.
Він змішався при боярських похвалах і не знав, чи відповідати що-
небудь, чи ні, а вкінці сказав коротко:

- Нема за що дякувати, боярине! Я зробив те, що кождий на моїм місці
- зробив би,за що ж тут дякувати? Нехай донька твоя буде здорова, але
- на вдячність ніяку я не заслужив.

Сказавши се, він пішов, аби закликати своїх тухоль-ських товаришів.
При їх помочі медведицю швидко обдерто зі шкури, а малі медведята
перенесено на збірне місце, відки ціле товариство по скінченню ловів
мало удатися назад до табору.

Сонце доходило вже полудня і сипало гаряче золотисте проміння на
тухольські гори; розігріта живиця сильніше запахла в лісах; гордо і
тільки десь-колись помахуючи розпластаними крилами, плавав яструб
високо понад полонинами в лазуровім океані. Тиша стояла в природі.
Тільки з одного пригірка Зелеменя лунали голоси ловецьких труб і крики
ловецького товариства. Лови скінчилися, хоч і не зовсім щасливо. На
дрючках несли тухольські парубки поперед ловцями три медведячі шкури і
в мішку двоє медведят, а на ношах із галуззя несли боярські слуги
позаду товариства окровавленого, задубілого вже трупа нещасливого
боярина, що погиб від медве-дячих лап.

Швидко під проводом Максима дійшло товариство до мисливського табору.

Лови були скінчені. Сьогодні ще хотіло ціле товариство вертати домів,
зараз, скоро лише по обіді. Дорога була вправді не близька, але Максим
обіцяв випровадити товариство простішою лісовою стежкою до Тухлі, а
відтам до двора Тугара Вовка. Тухоль-ські пасемці, скоро тільки
пообідали, зараз пішли наперед до домів; Максим лишився з боярами,
поки слуги здійняли табір і попрятали всі кухонні та ловецькі
знаряддя; тоді й боярське товариство вирушило в дорогу з поворотом
додому.




ІI


Стародавнє село Тухля - се була велика гірська оселя з двома чи трьома
чималими присілками, всього коло півтори тисячі душ. Село й присілки
лежали не там, де лежить теперішня Тухля, але геть вище серед гір у
просторій подовжній долині, що тепер поросла лісом і зоветься Запалою
долиною. В ті давні часи, коли йде наше оповідання. Запала долина не
була поросла лісом, але, навпаки, була управлена і годувала своїх
жильців достатнім хлібом.

Простягаючись звиш півмилі вдовж, а мало що не чверть милі в ширину,
рівна й намулиста, обведена з усіх боків стрімкими скалистими стінами,
високими декуди на іри або й чотири сажні, долина тота була немов
величезним кітлом, із якого вилито воду. І певно, що воно й не інакше
було. Чималий гірський потік впадав від сходу до тої долини високим на
півтора сажня во-допадом, прориваючи собі дорогу поміж тісні, тверді
скали і обкрутившися вужакою по долині, випливав на захід у таку ж
саму тісну браму, розбиваючись поміж гладкі кам'яні стіни і гуркотячи
ще кількома водопада-ми, поки чверть милі понижче не впав до Опору.
Високі, стрімкі береги тухольської кітловини покриті були темним
смерековим лісом, що надавав самій долині позір ще більшого
заглиблення і якоїсь пустинної тиші та відрубності від усього світу.
Так, справді, се була величезна гірська криївка, з усіх боків тільки з
великим трудом доступна,- але такі були в тих часах ненастанних війн,
усобиць і нападів майже всі гірські села, і тільки дякуючи тій своїй
неприступності, вони змогли довше, ніж подільські села, охоронити своє
свобідке староруське громадське життя, яке деінде силувалися чимраз
більше підірвати горді, війнами збагачені бояри.

Тухольський народ жив головно скотарством. Тільки та долина, де лежало
село, а також кілька поменших порічин, не покритих лісом, надавалися
до хліборобства і видавали щороку багаті збори вівса, ячменю і проса.
Зате в полонинах, що були, так само, як і всі доокружні ліси,
власністю тухольської громади, паслися великі отари овець, у котрих
спочивав головний скарб тухольців: з них вони добували собі одежу й
страву, омасту й м'ясо.

В лісах довкола села паслися корови й воли; але сама місцевість,
гориста, скалиста й неприступна, забороняла держати багато тяжкої
рогатої худоби.

Другим головним джерелом достатку тухольців були ліси. Не говорячи вже
про дрова, котрих мали безплатно і на топливо, і на всякі будинки,
ліси достачали тухольцям звірини, лісових овочів і меду. Правда, життя
серед лісів і недоступних диких гір було тяжке, було ненастанною
війною з природою: з водами, снігами, диким звіром і дикою,
недоступною околицею,- але тота боротьба вироблювала силу, смілість і
промисловість народу, була підставою й пружиною його сильного,
свобідного громадського ладу.

Сонце вже геть схилилося з полудня, коли з високого верха в тухольську
долину спускалося знайоме нам ловецьке товариство під проводом Максима
Беркута.

Передом ішов Тугар Вовк з донькою і з Максимом; решта товариства
ступала за ними невеличкими купками, гуторя-чи про перебуті лови та
ловецькі пригоди.

Перед очима товариства розкрилася тухольська долина, облита гарячим
сонячним промінням, мов велике зелене озеро з невеличкими чорними
острівцями. Круг неї, мов височезний паркан, бовваніли кам'яні стіни,
по яких п'ялися де-де пачоси зеленої ожини та корчі ліщини. При вході
в долину ревів водопад, розбиваючись о каміння сріблястою піною; поуз
водопаду викутий був у скалі вузький вивіз, яким ішлося вгору і далі
понад берегом потока через верхи і полонини аж до угорської країни; се
був звісний тодішнім гірнякам

«тухольський прохід», найвигідніший і найбезпечніший після
«дуклянського: десять дооколичних громад, з галицького і з угорського
«боку, працювали майже два роки над виготовленням сього проходу.
«Тухольці вложиди найбільше праці в те діло, тож гордилися ним, як
«своїм.

- Гляди, боярине,сказав Максим, зупиняючись над водопадом при вході в
- крутий, у камені кований вивіз,гляди, боярине, се діло тухольської
- громади!

Геть ось туди, через Бескиди, тягнеться сеся дорога, перша така дорога
в верховині. Мій батько сам витичував її на протязі п'ятьох миль;
кождий місток, кожда закрутина, кож-дий вивіз на тім протязі зроблений
за його показом.

Боярин неохітно якось поглянув горами, куди на далекий протяг понад
потоком вилася між скалами протерта гірська дорога. Потім глянув долі
вивозом і похитав головою.

- Твій батько має велику вдасть над громадою? спитав він.

- Власть, боярине? відказав здивований Максим.Ні, власті у нас над
- громадою не має ніхто: громада має власть сама, а більше ніхто,
- боярине. Але мій батько досвідний чоловік і радо служить громаді. Як
- він говорить на раді громадській, так не зуміє ніхто в цілій
- верховині. Громада слухає батькової ради,але власті батько мій не
- має ніякої і не жадає її.

Очі Максима блищали огнями гордості й подиву, коли говорив про свого
батька.

Тугар Вовк при його словах у задумі похилив голову; зате Мирослава
гляділа на

Максима, не зводячи з нього очей. Слухаючи Максимових слів, вона чула,
що його батько стається для неї таким близьким, таким мов рідним
чоловіком, немов вона вік жила під його батьківською опікою.

Але Тугар Вовк ставав чимраз більше понурий, чоло його морщилося, і
очі з виразом давно здержуваного гніву звернулися на Максима.

- То се твій батько бунтує тухольців против мене і против князя?
- спитав він нараз терпким, різким тоном. Немов болющий дотик, вразили
- ті слова

Мирославу; вона зблідла і позирала то на батька, то на Максима. Але
Максим цілком не змішався від тих слів, а відповів спокійно:

- Бунтує громаду, боярине? Ні, се тобі неправду сказано. Вся громада
- гнівна на тебе за те, що ти присвоюєш собі громадський ліс і
- полонину, не спитавши навіть громади, чи схоче вона на те пристати,
- чи ні.

- А так, ще питатися вашої громади! Мені князь дарував той ліс і тоту
- полонину,

і мені ні в кого більше дозволятися.

- Те самісіньке й говорить громаді мій батько, боярине. Мій батько
- уцитькує громаду і радить підождати аж до громадського суду, на
- котрім те діло розбереться.

- Громадського суду! скрикнув Тугар Вовк.То й я мав би ставати перед
- тим судом?

- Думаю, що й тобі самому се буде пожадане. Ти будеш міг усім доказати
- своє право, вспокоїти громаду.

Тугар Вовк відвернувся. Вони йшли далі вивозом, який закручувався
насередині, щоб зробити дорогу не так похилою і не так небезпечною.
Максим,

ідучи позаду, не зводив очей із Мирослави. Але його лице не ясніло вже
таким чистим щастям, як недовго перед тим. Чим чорніша хмара гніву й
невдоволення залягала на чолі її батька, тим виразніше почув Максим,
що між ним і

Мирославою розвертається глибока пропасть. При тім він, дитя гір, не
знаючи великого світу і високих боярських замислів, і не догадувався,
яка широка і глибока була та пропасть на самім ділі.

Зійшли вже на долину. Під водопадом творив потік просторий, спокійний
і чистий, мов сльоза, ставок. При його берегах стояли великі шапки
перлової шипучої піни: дно наїжене було великими й малими обломами
скал; прудкі, мов стріла, пструги блискали поміж камінням своїми
перлово-жовтими, червоно цяткованими боками; в глибині затоки долі
кам'яною стіною ревів водо-пад, мов живий срібний стовп, граючи до
сонця всіми барвами веселки.

- Що за пречудове місце! аж скрикнула Мирослава, вдивляючися в водопад
- і навалені в глибині дико пошарпані скали, обведені згори темно-
- зеленою габою смерекового лісу.

- Це наша Тухольщина, наш рай! сказав Максим, обкидаючи оком долину, і
- гори, і водопад з такими гордощами, з якими мало котрий цар обзирає
- своє царство.

- Тільки мені ви затроюєте життя в тім раю,сказав гнівно Тугар Вовк.

Ніхто не відзивався на ті слова; всі троє йшли мовчки дальше. Ось уже
доходили до села, що розкинулося густими купами порядних, драницями
критих хат, густо обсаджене рябиною, вербами та розлогими грушами.
Народ робив у полю; тільки старі діди, поважні, сивобороді, походжали
коло хат, то дещо тешучи, то плетучи сіті на звіра та на рибу, то
розмовляючи про громадські діла. Максим кланявся їм і вітав їх
голосно, приязно; далі й Мирослава почала вітати старих тухольців, що
стояли на дорозі; тільки Тугар Вовк ішов понурий та німий, навіть
поглянути не хотів на тих смердів, що сміли супротивлятися волі його
князя.

Аж ось насеред села з ними пострічалася дивна компанія. Три старці,
убрані по- празничному, несли дорогою на високій, гарно точеній і
оздібно сріблом окованій дрючині великий, також сріблом окований
ланцюг, вироблений суцільно з одної штуки дерева в виді перстеня,
нерозривного і замкнутого в собі.

Понад тим ланцюгом повівала червона, кармазинова, сріблом вишивана
хоругов. Три старці йшли повільно. Перед кождим дворищем вони
зупинялися і викликали голосно хазяїв по ім'ю, а коли той або хто-будь
із жильців дворища явився, вони говорили:

- Завтра на копу! і йшли дальше.

- Се що за дивоглядія? спитав Тугар Вовк, коли старці почали
- наближатися до них.

- Хіба ж ти не видав ще такого? спитав його здивований Максим.

- Не видав. У нас коло Галича нема такого звичаю.

- На копу скликають, на раду громадську,сказав Максим.

- Я гадав, що попи з корогвою,почав насміхатися Тугар.У нас коли
- скликають на копу, то скликають потиху, передаючи з хати до хати
- копне знамено.

- У нас копне знамено обноситься по селу отсими закличниками; вони
- повинні кождого громадянина по ім'ю закликати на копу. І тебе
- закличуть, боярине.

- Нехай собі кличуть, я не прийду! Нічого мене не обходить ваша копа.
- Я тут із княжої волі і можу сам збирати копу, коли буду вважати се
- потрібним.

- Ти сам… збирати копу? спитав зачудований Максим.Без наших
- закличників?

Без нашого знамена?

- У мене свої закличники і своє знамено.

- Але ж на твою копу ніхто з наших громадян не піде. А наша копа як
- осудить, так у нашій громаді й буде.

- Побачимо! сказав гнівно й уперто Тугар Вов-я. В ту саму пору
- наблизилися наші пішоходи до закличників. Побачивши боярина,
- закличники поставили знамено, а один із них відізвався:

- Боярине Тугаре Вовче!

- Ось я,відповів боярин понуро.

- Завтра на копу!

- Чого?

Але закличники на се не відповіли нічого і пішли дальше.

- Не їх діло, боярине, говорити чого,пояснив Максим, стараючись
- якомога втихомирити нехіть боярина до тухольської громадської ради.
- По довшій мовчанці, під час котрої вони все йшли селом, Максим знов
- зачав говорити:

- Боярине, позволь мені, недосвідному, молодому, сказати тобі слово.

- Говори! сказав боярин.

- Прийди завтра на копу!

- І піддатися вашому холопському судові?

- Що ж, боярине, тухольська громада судить по справедливості, а
- справедливому судові хіба стид піддатися?

- Таточку! вмішалася й Мирослава до тої розмови.Зроби так, як каже
- Максим.

Він добре каже! Він урятував моє життя,- він же ж не хотів би тобі зле
радити; він знає добре тутешні звичаї.

Тугар Вовк знехотя всміхнувся на ту правдиво жіночу логіку, але чоло
його швидко знов наморщилося.

- І вже ти протуркала мені упгі тим Максимом! сказав він.Ну, урятував
- тобі життя, я і вдячний йому за те, і, коли хочеш, дам йому пару
- волів. А тут знов о

інші річі йде, до яких не слід мішатися ні тобі, ні Максимові.

- Ні, боярине,відмовив на се Максим,ти чей не схочеш унизити мене
- відплатою за моє незначне діло. Ані я, ані мій батько не приймемо
- ніякої відплати. А то, що я тебе прошу прийти завтра на копу, я
- роблю тільки з щирої прихильності. Я рад би, боярине, щоб між ту-
- хольською громадою і тобою була згода.

- Ну, нехай і так,сказав вкінці Тугар Вовк,прийду завтра на тоту вашу
- раду, але не на те, щоб Їй піддатися, а лиш на те, щоб побачити, що
- се за рада буде.

- Прийди, боярине, прийди! скрикнув радісно Максим.Побачиш сам, що
- тухольська громада вміє бути справедливою.

Приречення Тугара Вовка облегшило серце Максимові. Він став веселий,
говіркий, показував Мирославі направо і наліво, що було гарного й
цікавого довкола, а гарного й цікавого було багато. Наші пішоходи були
саме серед села і на середині тухольської долини. Стрімкі ска-листі
береги кітловини світилися по обох боках далеко, мов рівні, високі
мармурові мури. Потік плив посеред села, тут же біля дороги, шумів і
пінився, розбиваючись по каменях, котрими усіяне було його дно, і
навіваючи свіжий холод на всю долину. По обох боках потока, якого
береги були досить високі, прорізані в намулі давнього озера,
побудовані були кашиці (загати) з річного каміння і грубих смерекових
палів та колод, щоб охоронити село від виливу. Всюди через потік
пороблені були вигідні з поруччями кладки, а зараз поза кашицями йшли
скопані грядки з фасолею й горохом, що вилися вгору по тичинню, з
буряками й капустою, а також загони пшениці, що чистими ясно-зеленими
пасмугами простягалися далеко поза хати. Хати були порядно обгороджені
і харно удержувані; стіни з гладкого дилиння, не обмазаного глиною,
але кілька разів до року митого і скобленого річними черепницями;
тільки там, де одна ди-лина сходилася з другою, в вузьких пасмугах
стіни були поліплені глиною і побілені паленим вапном, і виглядали
дуже гарно серед зелених верб і груш. При вході до кождого дворища
стояли дві липи, між якими прив'язані були гарно плетені в усякі узори
ворота. Майже над кождими воротами на жердці висіла прибита якась хижа
птиця: то сова, то сорока, то ворона, то яструб, то орел, з широко
розпростертими крилами і звислою додолу головою; се були знаки духів -
опікунів дому. За хатами стояли стайні та інші господарські будинки,
всі під драницями і з грубезних тесаних брусів збудовані; тільки
нечисленні обороги були з соломи і насторошували де-де свої золото-
жовті остро-круглі чуби догори помія» чотирма високими оборожинами.

- Ось мого батька двір,сказав Максим, показуючи на один двір, нічим не
- відмінний від інших. Перед домом не було нікого, але двері від сіней
- були відчинені, а в стіні до полудня прорубані були два невеличкі
- квадратові отвори, які вліті оставались або зовсім створені, або
- закладались тонкими і напівпрозірчастими гіпсовими плитками і на
- зиму, крім того, забивались дощаними віконницями. Се були тодішні
- вікна.

Мирослава цікаво позирнула на те гніздо Беркутів, над котрого ворітьми
справді висів недавно вбитий величезний беркут, ще й по смерті немов
грозячи своїми могутніми залізними пазурами і своїм чорним, у каблук
закривленим дзюбом.

Затишно, супокійне і ясно було па тім обійстю; потік відділював його
від гостинця, пе-рекинений широкою кладкою, і журчав стиха та плескав
кришталевою хвилею о кам'яну загату. І Тугар Вовк позирнув туди.

- Ага, то тут сидить той тухольський владика. Ну, рад я пізнати його.
- Побачимо, що се за птиця!

Максим хотів попрощати боярина й його доньку і звернути додому, але
щось немов тягло його йти з ними дальше. Мирослава немов порозуміла
се.

- Чи вже вертаєш додому? спитала вона, відвертаючись, щоб укрити своє
- помішання.

- Хотів було вертати, але нехай і так проведу вас іще через тіснину до
- вашого двора.

Мирослава втішилася, сама не знаючи чого. І знов пішли вони вниз
селом, гуторячи, озираючись на всі боки, любуючись одне одним,
голосом, присутністю, одне для другого забуваючи все довкола, батька,
громаду. І хоча в цілій розмові ані одним словом не згадували про
себе, про свої чуття й надії, але й крізь найбай-дужнішу їх бесіду
тремтіло тепло молодих, першою любов'ю огрітих сердець, проявлялася
таємнича сила, що притягала до себе ті дві молоді, здорові й гарні
істоти, чисті та незопсовані, що в своїй невинності навіть не думали
про перепони, які мусила стрінути їх молода любов.

І Тугар Вовк, що йшов передом у важкій, понурій задумі та міркував над
тим, як би то завтра стати гідно і в цілім блиску перед тими смердами
та показати їм свою повагу та вищість,- і Тугар Вовк не завважав
нічого між молодими людьми; одно тільки гнівало його, що той молодий
парубок такий смілий і так поводиться з ним і з його донькою, мов з
рівними собі. Але до пори, до часу він здержував свій гнів.

Минули вже село і зближалися до того місця, де ту-хольська кітловина
замикалася, пропускаючи тільки вузькою скалистою брамою потік у
долину.

Сонце вже похилилося геть із полудня і стояло над вершиною лісу,
купаючи своє скісне проміння в спінених хвилях потоку. Від скал, що
затіснювали виплив потоку з тухоль-ської долини, лежали вже довгі
тіні; в самій тіснині було сумрачно, холодно і слизько. Внизу
розбивалася вода потоку о величезне, купами тут навалене каміння, а
вгорі високо шуміли величезні смереки і буки.

Понад самим потоком з обох боків вели проковані в скалах вигідні
стежки - також діло тухольців. Якась дрож пройняла Мирославу, коли
входила в оту дивовижну «кам'яну браму»: чи то від пануючого тут
холоду, чи від вогкості, чи бог знає від чого,- вона взяла батька за
руку і притиснулася до нього.

- Яке страшне місце! сказала вона, зупиняючись у самій тіснині і
- озираючись кругом та догори. І справді, місце було незвичайне, дике.
- Потік був вузький, може, на три сажні, не більше, завширшки, і так
- гладко прорізаний рвучою гірською водою в лупаковій скалі, що
- незнающий був би міг присягнути, що се людських рук робота. А перед
- самим проходом стояв насторч величезний кам'яний стовп, усподу геть
- підмитий водою і для того тонший, а вгорі немов головатий, оброслий
- папороттю та карлуватими берізками. Се був широко звісний Сторож,
- котрий, бачилось, пильнував входу в тухольську долину і готов був
- упасти на кождого, хто в ворожій цілі вдирався б до сього тихого,
- щасливого закутка. Сам Тугар Вовк почув якийсь холод за плечима,
- зирнувши на того страшного Сторожа.

- Тьфу, яка небезпечна каменюка! сказав він.Так нависла над самим
- проходом, що, бачиться, ось-ось упаде!

- Се святий камінь, боярине,сказав поважно Максим,йому щовесни
- складають вінки з червоного огнику се наш тухольський Сторож.

- Ех, все у вас ваше, все у вас святе, все у вас ту-хольське,аж
- слухати обридло!

- скрикнув Тугар Вовк.Немовто поза вашою Тухольщиною вже й світу нема!

- Для нас і справді нема світу,відмовив Максим.Ми над усе любимо свій
- кутик,коли б так кождий інший любив свій кутик, то, певно, всі люди
- жили б на світі спокійно й щасливо.

Максим у своїй невинній щирості й не розумів, як чутко вколов він у
серце боярина тими словами. Він не завважав також, якими злобними
очима позирнув на нього Тугар Вовк. Звертаючися до Мирослави, Максим
мовив далі спокійним, теплим голосом:

- А про той камінь, про нашого Сторожа, я вам оповім, що чув від
- батька. Давно то, дуже давно діялось, ще коли велетні жили в наших
- горах. То тут, де тепер наша Тухля, стояло велике озеро; сеся
- кітловина була ще зовсім замкнена, і тільки через верх текла вода.
- Озеро се було закляте: в нім не було нічого живого

- ні рибки, ні хробачка; а котра звірина напилася з нього, мусила
- згинути; а пташина, що хотіла перелетіти понад нього, мусила впасти
- в воду і втопитися.

Озеро було під опікою Морани, богині смерті. Але раз сталося, що цар
велетнів посварився з Мораною, і, щоб зробити їй наперекір, ударив
своїм чародійським молотом о скалу, і розвалив стіну, так що вся вода
з заклятого озера виплила і стратила свою дивну силу. Ціла околиця
раптом ожила; дно озера зробилося плодючою долиною і зазеленілося
буйними травами та цвітами; в потоці завелися риби, поміж камінням
усяка гадь, у лісах звірина, в повітрі птиця. За те розлютилася
Морана, бо вона не любить нічого живого, і закляла царя велетнів у
отсей камінь. Але долині самій не могла нічого зробити, бо не могла
назад вернути мертвящої води, що виплила з озера; якби була вернула
назад усю воду до краплини і заткала отсей у скалі вибитий прохід, то
була би знов царицею наших гір. А так, то хоч цар велетнів і не жив,
та проте й Морана не має вже тут власті. Але цар не зовсім погиб. Він
триває в тім камені і пильнує сеї долини.

Кажуть, що колись Морана ще раз ізбере свою силу, щоб нею завоювати
нашу

Тухольщину, але отсей заклятий Сторож упаде тоді на силу Морани і
роздавить

її собою.

З дивним чуттям слухала Мирослава тої повісті: вона глибоко щеміла її
в серці,-

їй так бажалося стати під руксю того доброго і животворного царя
велетнів до бою з силою Морани; кров живіше заграла в її молодім
серці. Як сильно, як гаряче любила вона в тій хвилі Максима!

А Тугар Вовк хоч і слухав Максимової повісті, але, бачилось, не дуже
вірив їй, тільки ще раз обернувся, позирнув на кам'яного тухольського
Сторожа і з погордою всміхнувся, немов подумав собі: «От дурні смерди,
в якій дурниці покладають свою гордість і свою надію!»

Вже наші пішоходи минули вузький протік тухольського потоку і вийшли
на ясний світ. Перед їх очима раптом розкинулася довга, крутими горами
обмежена долина Опору, котра ген-ген сходилася з долиною Стрию. Сонце
вже клонилося на захід і гарячим пурпуром мерко-•гіло в широких хвилях
Опору. Тухольський потік скаженими скоками і з лютим шумом гуркотів
додолу, щоб скупатися в

Опорі. Його вода, різко відбиваючи в собі заходову червоність,
виглядала неначе кров, що бурхає з величезної рани. Довкола шуміли
темні вже ліси.

Хвилю стояли наші пішоходи, напуваючись тою безсмертною і живущою
красою природи. Максим немов вагувався на якійсь думці, що так і
засіла в його голові і силоміць просилася на волю. Далі він зібрався з
відвагою і приблизився до Тугара Вовка, тремтячи й черво-ніючись.

- Боярине-батьку,сказав він незвичайно м'яким і несміливим голосом.

- Чого тобі треба?

- Позволь мені бути твоїм найщирішим слугою…

- Слугою? Що ж, се нетрудно,прийди з батьком і наймись, коли конче
- хочеш на службу.

- Ні, боярине, не так ти зрозумів мене… Позволь мені бути твоїм сином!

- Сином? Але ж у тебе б свій батько, і, як чую, далеко ліпший,
- справедливіший і мудріший від мене, коли завтра буде судити мене!

Боярин гірко, їдовито всміхнувся.

- Я хотів сказати,поправився Максим,хотів сказати ще не так. Боярине,
- віддай за мене доньку свою, котру я люблю дужче свого життя, дужче
- душі своєї!

Грім з ясного неба не був би так перелякав Тугара Вовка, як ті гарячі,
а при тім прості слова молодого парубка. Він відступив два кроки назад
і прошибаючим, з гнівом і погордою змішаним поглядом мірив бідного
Максима від ніг до голови.

Лице його було недобре, аж синє, зуби йому заціпило, губи дрожали.

- Смерде! скрикнув він нараз, аж дооколичні гори залунали тим
- проклятим окликом.Що се за слова смієш говорити до мене? Повтори ще
- раз, бо се не може бути, щоб я справді чув те, що мені причулося.

Грізний крик боярина збудив і в Максима його звичайну смілість і
рішучість.

Він випростувався перед боярином, мов молодий, пишний дубчак, і сказав
лагідним, але певним голосом:

- Нічого злого я не сказав тобі, боярине,нічого такого, що би
- приносило нечесть тобі або твоїй доньці. Я просив у тебе руки твоєї
- доньки, котру я люблю, як її ніхто в світі не буде любити. Невже ж
- між твоїм боярським, а моїм мужицьким родом така велика пропасть,
- щоб її любов не могла перегатити? Та й чим же ж тя так дуже вищий
- від мене?

- Мовчи, смерде! перебив його лютим криком Тугар Вовк.Рука моя
- судорожне стискає рукоять меча, щоб заткати ним твою глупу гортанку.
- Одно тільки рятує тебе від моєї мести, а се те, що ти нині вирятував
- мою доньку з небезпеки. Інакше ляг би ти в тій хвилі трупом за такі
- слова. І ти, безумний, міг подумати, міг посміти підносити очі свої
- до неї, до моєї доньки?.. Се за те, що я й вона говоримо з тобою по-
- людськи, а не копаємо тебе, як собаку! І ти думав, що, рятуючи її
- від пазурів медведя, ти здобув її для себе, як бранку? О ні! Коли б
- мало на таке прийти, то воліла б вона згинути в кривавих обіймах
- дикого звіра, ніж мала би тобі дістатися!

- Ні, боярине, не так кажи! Волів би я згинути в лапах медведя, аніж
- мав би один

її волосок бути ушкоджений.

Мирослава відвернулася при тих словах, щоб скрити від батька і від
Максима довго здержувані сльози, що тепер бризнули з її очей. Але
Тугар Вовк не зважав на те і говорив дальше:

- І ти, підлий хамів роде, смієш рівняти себе зо мною? Зо мною, що вік
- звікував між князями, вдостоївся княжої похвали і надгороди за
- рицарські діла! Моя донька може вибирати собі жениха між найпершими
- і найславнішими молодцями в краю, а я мав би дати її тобі, смердові,
- до твого тухольського гнізда, де би вона зів'яла, зсохла і пропала в
- нужді? Ш, ні, йди геть, бідний хлопче, ти несповна розуму, ти сказав
- свої слова в нападі божевільства.

Максим бачив тепер, що його надії розбиті, що боярин надто високо
міряє, надто гордо глядить на нього. Хоч і як тяжко приходилось йому,
але ніщо було робити.

- Боярине, боярине,сказав він сумним, теплим голосом,занадто ти високо
- піднявся на крилах гордості,але уважай! Доля звичайно тих найвище
- підносить, кого думає найнижче зіпхнути. Не гордуй бідними, не
- гордуй низькими, не гордуй робучими, боярине, бо хто ще знає, до
- котрої хто криниці прийде воду пити!

- Ти ще смієш мені давати науки, гаде? скрикнув розлючений Тугар Вовк,
- і очі його заблищали безумним гнівом.Геть мені з очей, а то, богом
- кленусь, не буду ні на що зважав, а просаджу тебе отсим ножем, як
- просадив нині рано медведя.

- Не гнівайся, боярине, за слова дурного хлопця,відповів усе спокійний

Максим.- Прощай! Прощай і ти, моя зоре, що блиснула мені так чудово на
одну днину, а тепер мусиш навіки для мене померкнути! Прощай і будь
щаслива!

- Ні, годі мовчати,сказала нараз Мирослава, рішучо обертаючись,я не
- померкну для тебе, молодче, я буду твоя.

Тугар Вовк, мов остовпілий, глядів на свою доньку і вже аж тепер не
знав, що йому робити.

- Доню, а се що ти кажеш! скрикнув він.

- Те, що чуєш, таточку. Віддай мене за Максима! Я піду за нього.

- Дурна дівчино, се не може бути!

- Спробуй а побачиш, що може.

- Ти в гарячці говориш, доню,ти перелякалася дикого звіра, ти
- недужа!..

- Ні, таточку, я здорова і скажу тобі ще раз, і кле-нусь перед он тим
- ясним сонцем, що сей молодець мусить бути моїм! Сонце, будь свідком!

І вона взяла Максима за руку і гаряче прилипла устами до його уст.
Тугар Вовк не міг отямитися, не міг здобутися на один рух, на одно
слово.

- А тепер, молодче, йди домів і не лякайся нічого. Мирослава присягла,
- що буде твоєю, і Мирослава зуміє додержати присяги. А ми, таточку,
- спішімо додому!

Онде в долині наш двір, а ось і наші гості надходять.

І, сказавши се, дивна дівчина взяла безтямного з диву батька за руку і
пішла з ним долі горою. А Максим довго ще стояв на місці, очарований,
щасливий.

Вкінці прочунявся і, впавши лицем на землю, помолився захо-довому
сонцю так, як молилися його діди й прадіди, як молився тайком і його
батько. Потім устав і тихою ходою пішов додому.




ІIІ


За селом Тухлею, зараз же близ водопаду, стояла насеред поля величезна
липа.

Ніхто не затямив, коли її засаджено і коли вона розрослася така
здорова та конариста. Тухля була оселя не дуже давня, і деревина, що
росла на тухольській долині, була геть-геть молодша від тої липи; тим-
то й не диво, що тухольський народ уважав її найдавнішим свідком
давнини і окружав великою пошаною.

Тухольці вірили, що тота липа - дар їх споконвічного добродія, царя
велетнів, який засадив її власноручно на тухольській долині на знак
своєї побіди над

Мораною. З-під коріння липи било джерело погожої води і відтак, тихо
журчачи по дрібних камінцях, впливало до потоку. Се було місце копних
зборів тухольських, місце сільського віча, котре в старовину являло з
себе всю і одиноку вдасть у руських громадах.

Довкола липи був широкий, рівний майдан. Рядами стояли на нім до схід
сонця гладкі кам'яні брили, призначені на стільці, де сідали старці
громадські, батьки родин. Кілько було таких батьків, стілько й
кам'яних стільців. Поза ними було вільне місце. Під липою, над самим
джерелом, стояв чотиригранний камінь з проверченою всередині дорого;
тут на час ради виставлялося копне знамено. А обік зроблене було друге
підвищення - для бесідника, себто для того, хто в якій- небудь справі
говорив; він виступав із свого місця і входив на се підвищення, щоб
увесь народ міг чути його.

На другий день після боярських ловів густо тухоль-ського народу
роїлося по копнім майдані. Гамір ішов по долині. Старці громадські
йшли повагом із села один за одним і засідали на своїх місцях. Шумно
збиралася мо-лодіж і ставала поза ними широким півколесом. І жінки
сходилися, хоч не так численно: від громадської ради жаден дорослий
громадянин, чи муж, чи жінка, не був виключений. І хоч рішаючий голос
мали тільки старці-батьки, але при нараді вільно було й молодежі, й
жіноцтву подавати свій голос під розвагу старцям.

Сонце піднялось уже високо на небі, коли з села, остатні за всіма,
надійшли закличники, несучи перед собою тухольське копне знамено.
Поява їх викликала загальний шепіт між громадою, а коли вони
наблизилися, все втихло.

Закличникн, тричі поклонившися громаді, вийшли під липу і познімали
шапки з голів. Уся громада зробила те саме.

- Чесна громадо,відізвалися закличники,чи воля ваша нині раду держати?

- Так, так! загула громада.

- То нехай же бог помагає! сказали вони і, піднявши високо вгору копне
- знамено, встромили його в дірку, продовбану в камені. Се був знак,
- що рада зачата.

Потім устав зі свого місця найстарший у зборі, Захар Беркут, і
повільним, але твердим кроком виступив під липу, і, доторкнувшися її
рукою, наблизився до пливучої з її коріння нори, і, припавши на
коліна, помазав собі нею очі й уста.

Се була звичайна стародавня церемонія, що знаменувала очищення уст і
прояснення ока, потрібне при такім важнім ділі, як народна рада. По
тім він сів на підвищенім місці, звернений лицем до народу, тобто до
східної сторони неба.

Захар Беркут - се був сивий, як голуб, звиш 90-літній старець,
найстарший віком у цілій тухольській громаді. Батько вісьмох синів, із
яких три сиділи вже разом

із ним між старцями, а наймолодший, Максим, мов здоровий дубчак між
явориною, визначався між усім тухоль-ськкм парубоцтвом. Високий
ростом, поважний поставою, строгий лицем, багатий досвідом життя й
знанням людей та обставин, Захар Беркут був правдивим образом тих
давніх патріархів, батьків

і провідників цілого народу, про яких говорять нам тисячолітні пісні
та перекази. Незважаючи на глибоку старість, Захар Беркут був іще
сильний і кремезний. Правда, він не робив уже коло поля, не гонив
овець у полонину, ані не ловив звіра в лісових нетрях,- та, проте,
працювати він не переставав. Сад, пасіка й ліки - се була його робота.
Скоро лишень весна завітає в тухольські гори, Захар Беркут уже в своїм
саду, копле, чистить, підрізує, щепить і пересаджує. Дивувалися
громадяни його знанню в садівництві, тим більше дивувалися, що він не
крився з тим знанням, але радо навчав кождого, показував

і заохочував. Пасіка його була в лісі, і кождеї погідної днини Захар
Беркут ходив у свою пасіку, хоч дорога була утяжлива і досить далека.
А вже найбільшим добродієм уважали тухольці Захара Беркута за його
ліки. Коли було настане час між зеленими святами а святом Купайла,
Захар Беркут з своїм наймолодшим сипом Максимом іде на кілька неділь у
гори за зіллям і ліками. Правда, чисті та прості звичаї тодішнього
народу, свіже тухольське повітря, просторі та здорові хати і
ненастанна та зовсім не надсильна праця - все те вкупі хоронило людей
від частих і заразливих хвороб. Зате частіше лучалися каліцтва, рани,
на які, певно, ніякий знахар не вмів так скоро і так гарно зарадити,
як Захар Беркут.

Але не в тім усім покладав Захар Беркут головну вагу свого старечого
життя.

«Життя лиш доти має вартість,- говорив він частенько,- доки чоловік
«може помагати іншим. Коли він стає для інших тягарем, а хісна не
«приносить їм ніякого, тоді він уже не чоловік, а завада, тоді він уже
«й жити не варт. Хорони мене боже, щоб я коли-будь мав статися тягарем
«для інших і їсти ласкавий, хоч і як заслужений хліб!» Ті слова - то
«була провідна, золота нитка в життю Захара

Беркута. Все, що він робив, що говорив, що думав, те робив, говорив і
думав з поглядом на добро і хосен інших, а поперед усього - громади.
Громада - то був його світ, то була ціль його життя. Ви-дячи, що
медведі та дики часто калічать худобу й людей у горах, він, ще бувши
молодим парубком, задумав навчитися лічити рани і, покинувши
батьківський дім, вибрався в далеку, незнайому дорогу до одного
славного ворожбита, який, чутка була, вмів замовляти стріли й кров.
Але примова того лікаря показалася пустою. Захар Беркут, прийшовши до
нього, обіцяв йому десять ку-шіць плати, щоб навчив його своєї
примови.

Ворожбит пристав, але Захарові не досить було навчитися насліпо, він
хотів попереду переконатися, чи лік ворожбитів добрий. Він вийняв свій
ніж і задав собі ним глибоку рану в стегно.

- На, заков,сказав він до зачудованого лікаря. Примова не вдалася.

- Е,сказав лікар,це для того не вдається, що ти самовільно завдав собі
- рану.

Такої рани замовити не можна.

- Ну, то видно, що кепська твоя примова, і мені Гі не потрібно. Я
- потребую такої примови, котра не питала би, чи рана самовільна, чи
- ні, а загоїла б усяку.

І, як стій, Захар Беркут покинув ворожбита і пішов дальше -
розпитувати ліпших лікарів. Довго блукав він по горах і долах, аж поки
по році блукання не зайшов до скитських монахів. Між ними був один
столітній старець, що довгі часи пробував на Афонській горі у греків і
читав там багато старих грецьких книг.

Той монах умів чудово лічити рани і брався навчити своєї штуки
кождого, хто проживе з ним рік у добрій злагоді і покажеться йому
чоловіком щирого серця й чистої душі. Багато вже учеників приходило до
старого, вічно задуманого і вічно сумовитого монаха, але ні одного він
не вподобав, ні один не прожив з ним умовленого року і не виніс його
тайників лікарських. Про цього-то лікаря прочув Захар Беркут і
наважився відбути його пробу. Прийшовши до скитського монастиря,
просив, щоб заведено його до старця Акинтія, і одверто розповів йому
про ціль свого приходу. Сивобородий, понурий дід Акинтій прийняв його
без суперечки - і Захар вибув не рік, а цілі три роки. Він вернувся зо
скита новим чоловіком; його любов до громади стала ще гарячішою і
сильнішою, його слова плили кришталевою, чистою хвилею, були спокійні,
розумні і тверді, як сталь, а проти усякої неправди гострі, як бритва.
В своїй чотирилітній мандрівці Захар

Беркут пізнав світ, був і в Галичі, і в Києві, бачив князів і їх діла,
пізнав вояків і купців, а його простий, ясний розум складав усе бачене
й чуте, зерно до зерна, в скарбницю пам'яті як матеріали для думки.
Він вернувся з мандрівки не тільки лікарем, але й громадянином. Бачачи
по долах, як князі та їх бояри силуються ослабити і розірвати
громадські вільні порядки по селах, щоб опісля роз'єднаних

і розрізнених людей тим легше повернути в невольників і слуг, Захар
Беркут переконався, що для його братів-селян нема іншого рятунку й
іншої надії, як тільки добре уладження й розумне ведення та розвивання
громадських порядків, громадської спільності та дружності. А з другого
боку, від Акинтія і від інших бувалих людей він чимало наслухався про
громадські порядки в північній Русі, в

Новгороді, Пскові, про добробут і розцвіт тамошніх людей, і все те
запалювало його гарячу душу до бажання - віддати ціле своє життя на
поправу й скріплення добрих громадських порядків у своїй рідній
Тухольщині.

Сімдесят літ минуло від того часу. Мов стародавній дуб-велетень, стояв
Захар

Беркут серед молодого покоління і міг тепер бачити плоди своєї
довголітньої діяльності. І, певно, не без радості міг він глядіти на
них. Мов одна душа, стояла тухольська громада дружно в праці і
вживанню, в радощах і в горю. Громада була для себе і суддею, і
впорядчиком у всьому. Громадське поле, громадські ліси не потребували
сторожа - громада сама, вся і завсіди, бачно берегла своє добро.
Бідних не було в громаді; земля достачала пожитку для всіх, а
громадські шпихліри та стодоли стояли завсіди отвором для потребуючих.
Князі і їх бояри зависливим оком гляділи на те життя, в якім для них
не було місця, в якім їх не потребували. Раз у рік з'їздив у
Тухольщину князівський збірщик податків, і громада старалась
якнайборше позбутися немилого урядового гостя: через день або два він
виїздив, обвантажений усяким добром - бо податки в великій мірі
платили тухольці натурою. Але в Тухольщині збірщик князівських
податків не був таким самовладним паном, як по інших селах. Тухольці
добре уважали, що належиться збірщикові, а що князеві, і не попускали
йому зробити над ними ніякого надужиття.

Але не тільки в самій Тухольщині видний і спасенний був вплив Захара
Беркута; його знали люди на кільканадцять миль довкола, по руськім і
угорськім боці. Та й то знали його не лиш як чудовного лікаря, що
лічить рани і всякі болісті, але й не менше як чудовного бесідника та
порадника, котрий «як заговорить, то немов бог тобі в серце вступає»,
а як порадить чи то одному чоловікові, чи й цілій громаді, то хоч
цілий майдан старців набери, то й ті вкупі, певно, ліпшої ради не
придумають. Віддавна Захар Беркут прийшов був до того твердого
переконання, що як чоловік сам-один серед громади слабий і безрадний,
так і одна громада слаба, і що тільки спільне порозуміння і спільне
ділання многих сусідніх громад може надати їм силу і може в кождій
громаді поокремо зміцнити свобідні порядки громадські. Тож ніколи,
працюючи всілякими способами для своєї

Тухоль-щини, Захар не забував і про сусідні громади. Він за молодших
часів часто ходив по громадах, бував на їх копних зборах, старався
пізнати добре їх потреби й людей, і всюди ради та намови його змагали
до одного: до скріплення дружніх, товариських і братерських зв'язків
між людьми в громадах і між громадами в сусідстві. А зв'язки ті були
тоді ще досить живі й сильні; ще роз'їд- лива князівщина та боярщина
не здужала була порозривати їх до решти,- тому й не диво, що під
проводом так усіма любленого, так досвідного і громадському ділу
відданого чоловіка, як Захар Беркут, ті зв'язки живо відновилися і
зміцніли.

Особливо зв'язок з руськими громадами по угорськім боці був дуже
важним ділом для Тухоль-щини, ба й для цілої Стрийської верховини,
багатої вовною та кожухами, та зате досить убогої на хліб, якого мали
недостатком загірні люди.

Отже ж то одним із головних старань Захара було - провести зі своєї
Тухоль- щини просту і безпечну дорогу на угорський бік. Довгі літа він
носився а тою гадкою, переходив здовж і вшир тухольські полонини,
розмірковуючи, куди би найліпше, найбезпечніше і а найменшим коштом
можна провести дорогу, а заразом старався звільна й ненастанно накло-
нювати верховинські громади по однім і другім боці Бес-кида до того
діла. При кождій нагоді, на кождій громадській раді він не залишав
доказувати користь і потребу такої дороги, поки вкінці не добився
сього. Більше як десять громад з ближчої й дальшої околиці прислали до
Тухлі своїх виборних на громадську раду, на якій мало обговорюватись
побудовання нової дороги. Се був радісний день для Захара.

Він не тільки прийнявся радо сам повитичувати, куди має йти дорога,
але також через весь час, поки вона мала будуватися, взявся надзирати
за роботою, а окрім того, виправив чотирьох своїх синів до роботи, а
п'ятий його син, коваль, мав із своєю перевізною кузнею все бути на
місці роботи для направи потрібних знаряддів. Кожда громада висилала
по кільканадцять робітників, із запасом свого хліба й своєї страви,- і
під проводом невтомного Захара дорога була збудована в однім році.
Користі її відразу для всіх стали очевидні. Зв'язок з багатими ще тоді
угро-руськими громадами оживив усю верховину; почалася жива і
обопільна хосен - на обміна здобутків праці: туди йшли кожухи, сир
овечий та й цілі отари на заріз, а відтам пшениця, жито та полотна.
Але не тільки для такого обмінного торгу була вигідна тухольська
дорога; вона була також проводом для всіляких вістей про життя громад
по однім і по другім боці

Бескида, була живою ниткою, що в'язала докупи дітей одного народу,
розбитих між двома державами.

Правда, тухольська дорога була не перша така нитка. Давнішня і колись
далеко славніша була дуклянська дорога. Але галицько-руським князям
вона з многих причин не злюбилася, менше, може, для того, що
піддержувала живий зв'язок між громадами по сім і по тім боці Бескида
та через те скріплювала в одних і в других вольні громадські порядки,
як радше для того, що туди частенько мадьярські королі й дуки впадали
з військами до Червоної Русі. От тому-то галицькі та перемиські князі
старались коли не зовсім замкнути, то бодай укріпити ту входову браму
в свої границі, а звісно, що таке «укріплення», зроблене по-державному
і для державних цілей, мусило вийти на шкоду громад

і громадської самоуправи. Князі понасаджували здовж дуклянської дороги
своїх бояр, понадаровували їм із громадських земель просторі грунти й
посідища і вложили на них обов'язок - пильнувати Дуклянської брами, в
разі воєнного нападу спиняти неприятеля воєнними дружинами, набраними
з околичних громад, а також засіками, себто дерев'яними та кам'яними
запорами, що ними в тісних місцях завалювано дорогу, чинячи її при
якій-такій обороні зовсім непрохідною для ворожих вояків. Розуміється,
що ті обов'язки цілим своїм тягарем спадали на селян, на громади. Вони
не тільки тратили часть своїх споконвічних земель, на яких розсідалися
бояри, але мусили, крім того, ставити варти, давати дружинників та
слуг бобрам, робити засіки, ба, в разі воєнного часу, піддані були
зовсім боярським розказам і боярському судові. Очевидна річ, боярин,
обдарований такими широкими правами, стався силою в селі і, зовсім
природно, дбав про побільшення й укріплення своєї сили. Щоб
забагатіти, бояри закладали на шляху свої власні засіки-рогачки і
побирали з них і в спокійних часах оплату від усякого проїжджого, а се
мусило спинити живий рух по дуклянській дорозі, ослабити живі зв'язки
між громадами. А рівночасно з ослабленням тих зв'язків мусив іти й
упадок вічних, вільних порядків у самих громадах. Вдасть боярська не
могла й не хотіла обік себе терпіти другої, громадської власті; між
боярами а громадами мусило прийти до довгої й тяжкої боротьби, яка
вкінці випала на некористь громад. Правда, в тім часі, коли йде наше
оповідання, боротьба тота ще далеко не була скінчена, а декуди, в
відлюдних гірських селах, ще й зовсім не почалася,- і се були, можна
сказати напевно, найщасливіпгі закутки тодішньої Русі. До таких
щасливих закутків належала й Тухольщина, а дорога, проведена через
Бескид на Угри, на довгі часи забезпечила й' добробуток. Тухольська
дорога не була ще в руках боярських, була вільна для кождого, хоч
громадяни суміжних з нею селищ, як червоноруського, так і угорського
боку, пильно стерегли її від усякого ворожого нападу і давали собі
взаїмно знати про всяку грозячу небезпеку, яку таким способом
відбивано завчасу і тихо сполученими силами всіх заінтересованих тим
ділом громад. Не диво, проте, що, лежачи при тій дорозі, на середині
між

Угорщиною і Підгір'ям, Тухольщина раз у раз підносилася не лише добрим
побутом, але й свобідним громадським ладом. Своїм приміром вона
освіжувала і піддержувала всю дооколичну верховину, а особливо ті
села, в яких уже були княжі бояри і в яких почалась уже руйнуюча
боротьба між давнім громадством а новим панством. Гаряче слово і
велика повага Захара Беркута при-чинювалися немало до того, що, поки
більша часть громад держалася добре в тій боротьбі, бояри не могли так
швидко розширювати своєї власті, як їм сього бажалося, і мусили жити в
добрій злагоді з громадами, підлягаючи в часах супокою їх копним судам
і засідаючи в них поруч з іншими старцями як рівні з рівними.

Але такий стан був боярам дуже немилий; вони ждали воєнного часу, як
не знати якого празника, бо тоді всміхалась їм надія - відразу
захопити всю власть у свої руки, а при тій нагоді розбити до крихти
ненависні громадські порядки, так, аби раз захоплена власть уже не
потребувала виходити з їх рук. Але часу воєнного не було. Володар
Червоної Русі, князь Данило Романович, хоч і який був ласкавий для
бояр - не то що його батько,- але допомогти Їм багато не міг, зайнятий
то стараннями про королівську корону, то спорами князів, що дерлись за
великокняжий київський престол, а найменше забезпечуванням свого краю
против нового, досі не чуваного ворога - монголів, що перед десятьма
роками, мов страшна громова хмара, появилися були на східних границях
Русі, в наддонських степах, і побили зібраних руських князів у
страшній і дуже кровавій битві над рікою Калкою. Але з-над Калки
нагло, немов наполошені хоробрістю русичів, вони вернули назад, і ось
уже десятий рік минав, а про них не було нічого чути. Тільки глуха
тривога ходила по народі, мов гаряча вітрова хвиля ходить по
дозріваючім житі і ніхто не знав, чи хвиля уляжеться, чи, може, нажене
з собою грізну градову тучу. А найменше знали се й надіялись сього
князі та бояри. Вони спокійно по погромі над Калкою прийнялися за свою
давню роботу - спори за насліддя престолів і підкопування свобідних та
самоуправних громадських порядків. Нерозумні! Вони підривали дуба,
котрий годував їх своїми жолудьми! Коли б були свою вдасть і свою силу
повернули на скріплювання а не на підкопування тих порядків по
громадах і живих зв язків між громадами, то наша Русь, певно, не була
б упала під стрілами та топорами монголів, але була б остоялася проти
них, як глибоко вкорінений дуб-велетень остоюється проти осінньої
бурі!

Щаслива була Тухольщина, бо досі якось обминали її неситі очі князів і
бояр.

Чи то для того, що лежала так віддалік від світу, між горами та
скалами, чи, може, для того, що надто великого багатства в ній не
було. Досить того, що бояри якось не мали охоти затісуватися в той
закуток. Але і се щастя не було вічне. Нараз одної гарної днини заїхав
у тухольські гори боярин Тугар Вовк і, не кажучи нікому ані слова,
почав на горбі над Опором, віддалік від Тухлі, але на тухольськім
грунті, будувати собі дім. Тухольці з зачудування зразу мовчали не
спиняли нового гостя, далі почали допитуватися його, хто він, відки і
за чим приходить сюди?

- Я боярин князя Данила,гордо відповідав їм Тугар Вовк.За мої заслуги
- князь надгородив мене землями й лісами в Тухольщині.

- Але ж се землі й ліси громадські! відповідали йому тухольці.

- Се мене нічого не обходить,відказував боярин,ідіть і в князя
- допоминайтеся.

Я маю його грамоту - і більше нічого знати не хочу!

Тухольці кивали головами на такі боярські слова і не казали нічого. А
боярин тим часом починав собі все згорда все похвалявся княжою ласкою
та княжою волею, хоч зрештою, наразі й не стісняв ні в чім тухольців і
не мішався в їх громадські діла. Тухольці, а особливо молодші, зразу,
чи то з цікавості, чи з звичайної гостинності, частенько сходилися з
боярином і робили йому деякі прислуги,- аж нараз, мов сокирою втяв,
перестали ходити і, очевидно, зовсім уникали його. Се зразу здивувало,
а далі й розсердило боярина, і він почав тепер чинити тухольцям усякі
пакості. Дім його стояв якраз над тухольською дорогою,

і він, ідучи за приміром інших бояр, поставив на дорозі величезну
рогачку і ждав від проїжджих для себе мита. Та тухольці були тугий
народ. Вони почули відразу, що тут починається рішуча боротьба, і
постановили за радою Захара

Беркута стояти твердо і невідступне при своїх правах до крайньої
крайності.

Зараз тиждень по виставленню рогачки вислала тухоль-ська рада
громадська своїх відпоручників до Тугара Вовка. Відпоручники завдали
йому коротке і рішуче питання:

- Що робиш, боярине? За що спираєш дорогу?

- Так мені хочеться! відповів гордо боярин.Коли вам кривда, то йдіть
- жалуйтесь на мене до князя.

- Але ж се дорога не княжа, а громадська.

- Се мене нічого не обходить!

З тим відпоручники й віддалилися, але зараз по їх відході прийшла з
Тухлі ціла ватага сільської молодежі з сокирами і тихесенько порубала
рогачку на дрібні кусні, наклала з неї огонь і спалила її недалеко від
боярського двора. Боярин лютився на своїм дворі, кляв поганих смердів,
але супротивлятися їм не мав смілості і наразі не робив уже другої
рогачки. Перший напад на громадські права був відбитий, але тухольці
не радувалися завчасно,- вони добре знали, що се тільки перший напад і
що за ним треба надіятись інших. І справді, так воно сталося. Одного
дня прибігли до Тухлі вівчарі, голосячи сумну вість, що боярські слуги
зганяють їх із найкращої громадської полоняни. Не вспіли вівчарі до
ладу розказати свого, коли втім прибігли громадські лісничі, кажучи,
що боярин відмірює і запальковує для себе величезний кусень найкращого
громадського лісу. Знов громадська рада вислала відпоручників до
Тугара

Вовка.

- За що, боярине, кривдиш громаду?

- Я беру тільки те, що мені мій князь дарував.

- Але ж се не княжі, а громадські землі! Князь не міг дарувати того,
- що до нього не належить.

- Ну, то йдіть на князя жалуйтеся! відказав їм боярин і відвернувся
- від них.

Від тої пори почалася правдива війна між боярином і тухольцями. То раз
тухольці зженуть боярські стада зі своїх полонин, то боярські слуги
зженуть тухольські отари. Лісу, загарбаного боярином, стерегли і
громадські, і боярські лісничі, між котрими не раз приходило до сварки
і бійки. Се лютило боярина чимраз дужче, і він вкінці казав убивати
тухольську худобу, придибану на загарбаних полонинах, а одного
громадського лісничого, придибаного в заграбленім лісі, велів
прив'язати до дереза і сікти терновими різками мало що не на смерть.
Сьо-'-о було вже замного тухольській громаді. Многі голоси обізвалися
за тим, аби по давньому звичаю до боярина при-ложити закон про
непокірного і шкідного громадянина, розбійника та злодія і вигнати
його з обсягу громадських земель, а дім його зруйнувати дотла. Велика
часть громадян пристала на се, і певно, що круто прийшлось би було
тоді бояринові, коли б

Захар Беркут не був висловив тої думки, що не належиться засуджувати
нікого, не вислухавши вперед його оправдання, і що справедливість
домагається закликати боярина поперед усього на громадський копний
суд, дати йому можність витолкуватися і аж потім поступати з ним так,
як осудить громада при повнім спокою й розвазі. Тої розумної ради
послухала тухольська громада.

Певно, ніхто в нинішнім зборі не розумів так добре важності сеї хвилі,
як Захар

Беркут. Він бачив, що тут ціле діло його життя важиться на вістрю
громадського засуду. Та й коби-то в тім засуді ходило лиш о просту
справедливість, то Захар був би спокійний і покладався б уповні на
громадський розум. Але тут приходилося розважати - перший раз на
тухольськім копнім суді - також інші, посторонні, а безмірно важні
обставини, що запутували справу майже до безвихідності. Захар розу^
мів добре, що засуд, чи прихильний, чи неприхильний для боярина,
грозить громаді великою небезпекою. Прихильний засуд значить признання
не так права, як сили по стороні боярина, раз назавсіди упокорить
перед ним громаду, віддасть йому в руки на тільки загарбані ліси й
полонини, але й цілу громаду, буде першим і найтяжчим виломом у
вільнім громадськім устрою, над якого відновленням і скріпленням він
ненастанно трудився протягом сімдесятьох літ. А неприхильний засуд, що
вирече прогнання боярина з громади, грозить також немалою небезпекою.
Ану ж боярин зуміє підмовити князя, розбудити його гнів, переконати
його, що тухольці - бунтівники? Се може стягнути велику бурю або й
цілковиту руїну на

Гухольщину, як подібні засуди кілька разів уже стягали руїну на інші
громади, що їх князі узнавали за бунтівничі і віддавали боярам та їх
дружинам на розграблення та на знищення. Оба ті важкі виходи нинішньої
ради наповняли серце старого Захара великим сумом, і він щиро молився
духом перед почином ради до великого Дажбога-Сонця, щоб той просвітив
розум його і його громади

і дав їм знайти праву стежку серед усіх тих трудностей.

- Чесна громадо! так зачав він свою бесіду.Не буду від вас скривати,
- та й, впрочім, ви й самі то добре знаєте, які важкі й великі діла
- чекають сьогодні нашого громадського розсуду. Коли поглядаю на те,
- що довкола нас робиться і що нам грозить, то так і здається мені, що
- наше дотеперішнє спокійне громадське життя пропало безповоротно, що
- тепер наступає для нас усіх пора показати на ділі, в боротьбі, чи
- наші громадські порядки справді міцні й добрі, чи можуть видержати
- надходячу важку бурю. Яка се буря надходить на нас, і то не з одного
- боку, се ви знаєте і почуєте ще ширше на нинішній раді, тож про се я
- тепер не потребую говорити. Я хотів би тільки показати вам і вбити
- незнищимо в вашу тямку те становище, на якім би нам, по моїй думці,
- треба стояти, твердо стояти до крайньої крайності. А втім, і тут ні
- я, ні ніхто інший не має власті над вами: схочете, то послухаєте, а
- не схочете воля ваша! Тільки ж кажу вам, що сьогодні ми стоїмо на
- розстайній дорозі, сьогодні нам прийдеться вибрати: сюди чи туди.
- Тож годиться нам, людям старим і досвідним, добре вияснити собі той
- вибір і ті дороги, на які він може повести нас, і те місце, на
- котрім ми стоїмо тепер!

- Погляньте, чесна громадо, на те наше копне знамено, котре від
- п'ятдесятьох літ чує наші слова і бачить наші діла. Чи знаєте ви, що
- виражають його знаки? Святі

і поважні старці, батьки наші, зробили його і передали мені його
значення.

«Захаре,- сказали вони,- колись, у хвилі найгрізнішої небезпеки, коли
«життя наверне супротивну хвилю на громаду і загрозить її порядок,-
«тоді ти відкриєш громаді, що значить се знамено, а заразом відкриєш,
«що на нім спочиває наше й нашого духа-опікуна благословенство, що
«відступлення від тої дороги, яку вказує те знамено, буде найбільшим
«нещастям для громади, буде початком її цілковитого упадку!»

Захар утих на хвилю. Його бесіда зробила велике враження на всіх
громадян.

Усіх очі звернені були на знамено, що на високій жердці, встромленій у
камінь, стояло перед громадою, блискотіло срібною оковою на своїх
кільцях і повівало кармазиновою хоруговкою, немов переливалось живою
кров'ю.

- Я досі не говорив вам про се нічого,говорив Захар дальше,бо часи
- були спокійні. Але сьогодні пора се зробити. Глядіть на нього, на се
- знамено наше! З одного здорового пня вироблений весь той суцільний
- ланцюг, сильний і немов замкнутий у собі, а прецінь свобідний в
- кождім поєдинчім колісці, готовий прийняти всякі зв'язки. Сей ланцюг
- то наш руський рід, такий, який вийшов з рук добрих, творчих духів.
- Кожде колісце в тім ланцюзі то одна громада, нерозривно, з самої
- природи зв'язана з усіма іншими, а, проте, свобідна сама в собі,
- немов замкнена сама в собі, живе своїм власним життям і вдоволяє
- свої потреби. Тільки така суцільність і свобода кождої поодинокої
- громади робить усю цілість суцільною й свобідною. Нехай тільки одно
- колісце трісне, розпадеться само в собі, то й цілий ланцюг
- розпадеться, одноцілий його зв'язок розірветься. От так і упадок
- вольних громадських порядків у одній громаді стає раною, котра
- приносить недугу, а то й заразу для цілого тіла нашої святої Русі.

Горе громаді, котра добровільно станеться тою раною, котра не ужиє
всіх сил і способів, щоб удержати себе прії здоров'ю! Ліпше би було
такій громаді щезнути з лиця землі, запастися в безодню!

Остатні слова Захара, сказані грізним, піднесеним голосом, приглушили
в ушах слухаючої громади шум водо-паду, що недалеко гримав собою о
камінь і, мов живий стовп кришталю, граючи проти сонця всіми барвами
веселки, видавався блискучою пасмугою понад головами громади. Захар
говорив дальше:

- Гляньте ще раз на те знамено! Кожде колісце його ланцюга сковане
- блискучими срібними оковами в гарні узори. Окови ті не обтяжають
- колісця, а додають йому оздоби й тривкості. Так само кожда громада
- має свої дорогоцінні установи і порядки, породжені потребами,
- упорядковані розумом мудрих батьків наших. Порядки ті святі, але не
- для того, що давні, що батьками нашими уладже-ні, тільки для того,
- що свобідні, що не в'яжуть нікого доброго в добрім діланню, а
- в'яжуть лиш злого, що хотів би шкодити громаді. Порядки ті не
- в'яжуть і громаду, а тільки додають їй сили і власті для охорони
- всього, що добре і хосенне, а для знищення всього, що зле і шкідне.
- Коли б не ті срібні окови, дерев'яні обручки легко могли би
- потріскати і вся одноцілість ланцюга пропала би. Так само, якби не
- наші святі громадські установи, то й уся громада пропала би.
- Уважайте ж, чесна громадо! Злодійські руки простягаються, щоб
- обдерти ті срібні окови з нашого колісця, щоб ослабити і ногами
- потоптати наш громадський лад, при якім нам так добре жилосяі

- Ні, ми не попустимо їм того! крикнула разом од-нодушно
- громада.Станемо в обороні своєї свободи, хоч би прийшлося нам і
- остатню краплю крові пролити!

- Добре, діти! сказав зворушений Захар Беркут.Так воно й треба! Вірте
- мені, се дух нашого великого Сторожа прорік із вас! Ви його силою
- вгадали значення тої хоругви, що повіває на нашім знамені. Чому вона
- червона? Бо значить кров!

До остатньої краплі крові повинна боронити громада своєї свободи,
свого святого ладу! І вірте мені, недалеко та хвиля, котра справді
запотребує від нас крові! Будьмо готові й її пролити в своїй обороні!

В тій хвилі очі всіх громадян, немов на даний знак, звернулися в
сторону села.

Там, на шляху, що вів від села попри водопад у гори, показалася
невеличка громада пишно построєних, оруж-них людей. Се йшов у всій
своїй пишноті на тухольську раду боярин Тугар Вовк зі своєю дружиною.
Незважаючи на гарячу весняну днину, боярин був у повній рицарській
зброї: в панцирі з залізної блискучої бляхи, в "аких же набедрениках і
наголінниках і в блискучім спижевім шоломі з розвіяною поверх нього
китото з когутячих косиць. При боці у нього теліпався в піхві тяжкий
бойовий меч, через плечі перевішений був лук і сагайдак зі стрілами, а
за поясом стримів топір, блискучий широким сталевим вістрям і бронзою
набиваним обухом. Поверх усеї тої страшної зброї, на знак супокійного
свого наміру, боярин накинув вовчу шкуру, з пащею, переробленою в
защіпку на груді, і з лабами, що гострими кігтями обхапували його
пояс.

Довкола боярина йшло десять вояків, лучників і топірників, повбираних
у такі ж вовчі шкури, але без панцирів. Мимоволі стрепенулася
тухольська громада, побачивши наближення тої вовчої дружини; всі
зрозуміли, що се, власне, й є той ворог, який напосівся на їх свободу
й незалежність. Але поки що вони ще не надійшли, а Захар кінчив свою
бесіду.

- Ось надходить боярин, котрий хвалиться, що з милості для нього князь
- подарував йому наші землі, нашу свободу, нас самих. Бачте, як гордо
- виступає він у тім почуттю княжої милості, в тім почуттю, що він
- княжий слуга, що він раб! Нам не потрібно милості від боярина і ні
- за що ставати нам рабами се причина, для чого він ненавидить нас і
- прозиває нас смердами. Але ми знаємо, що гордість ного пуста і що
- правдиво свобід-ному чоловікові личить не гордість, а супокійна
- повага та розум. Заховайте ж проти нього ту повагу і той розум, щоб
- не ми упокорили його, а сам він у глибині свого сумління почув себе
- упокореним! Я скінчив.

Тихий шепіт вдоволення і радісної рішучості пройшов по громаді. Захар
сів на своє місце. Хвилю стояла мовчанка на майдані, поки Тугар Вовк
не наблизився до ради.

- Здорові були, громадо! сказав він, дотикаючи рукою свого шолома, але
- не знімаючи його з голови.

- Здоров будь і ти, боярине! відповіла громада. Тугар Вовк гордим,
- безпечним поступом вийшов перед громаду і, ледве окинувши її оком,
- проговорив:

- Ви кликали мене перед себе і ось я. Чого хочете від мене?

Слова ті сказані були різким, гордим голосом, котрим боярин, очевидно,
хотів показати громаді свою вищість. При тім він не дивився на
громаду, але обертав у руках свій топір і немов любувався блиском його
вістря та обуха, показуючи явно, що глибоко погорджує цілою тою радою.

- Ми закликали тебе, боярине, перед суд громадський, щоб, заким
- осудимо твої поступки, вислухати твого слова. Яким правом і в якій
- цілі ти робиш кривду громаді?

- На суд громадський? повторив, немов зачудува-ний, Тугар Вовк,
- обертаючись лицем до Захара.Я княжий слуга і боярин. Ніхто не має
- права судити мене, окрім князя і рівних мені бояр.

- Про се, боярине, чий ти слуга, ми не будемо з тобою сперечатися,се
- нас нічого не обходить. А про твоє право поговоримо пізніше. Тепер
- тільки будь ласкав сказати нам: відкіля прийшов ти в наше село?

- Зі столичного княжого міста Галича.

- А хто велів тобі йти сюди?

- Мій і ваш пан князь Данило Романович.

- Говори про себе, а не про нас, боярине! Ми вольні люди і не знаємо
- ніякого пана. А чого ж велів тобі твій пан іти в наше село?

Лице боярина облилося червоною пасмугою злості при тих словах Захара.

Хвилю він вагувався, чи відповідати дальше на його допитування, далі
погамував свій невчасний порив.

- Він велів мені бути сторожем його земель і його підданих, воєводою і
- начальником Тухольщини і дав мені і моїм потемкам у вічне посідання
- тухольські землі в нагороду за мою вірну службу. Ось його грамота,
- його печать

і підпис!

При тих словах боярин гордим рухом руки вийняв із-за широкого
ремінного пояса княжу грамоту і підняв її вгору, показуючи громаді.

- Сховай свою грамоту, боярине,сказав спокійно Захар,ми не вміємо її
- читати, а печать того князя для нас не закон. Радше сам ти скажи
- нам, хто се такий той твій князь?

- Як то? крикнув здивований боярин,Ви не знаєте князя Данила?

- Ні, не знаємо ніякого князя.

- Володаря всіх земель, усіх осель і міст від Сану аж до Дніпра, від
- Карпат аж до устя Бугу?

- Ми не видали його ніколи, і у нас він не володар. Адже пастух,
- володар отари, стереже її від вовка, гонить її в спеку полудня до
- холодного потоку, а в холод ночі до теплої, безпечної кошари. А
- князь чи робить се зі своїми підвладними?

- Князь робить з ними ще більше,відповів боярин.Він дає їм мудрі права
- і мудрих суддів, посилає їм своїх вірних слуг, аби боронили їх від
- ворога.

- Не по правді сказав ти се, боярине,замітив строго Захар.Бач, сонце
- на небі закрило своє ясне лице, щоб не слухати твоїх кривих слів!
- Мудрі права наші походять не від твого князя, а від дідів і батьків
- наших. Мудрих суддів княжих ми не видали досі і жили тихо, в згоді й
- ладі, судячись самі громадським розумом. Батьки наші здавна вчили
- нас: один чоловік дурень, а громадський суд справедливий суд. Без
- княжих воєвод жили наші батьки, жили й ми досі, і, як бачиш, хати
- наші не попустошені, і діти наші не забрані до ворожої неволі.

- Так було досі, але відтепер не так буде.

- Як буде відтепер, сього ми не знаємо, і ти, боярине, не знаєш. Одно
- ще тільки скажи нам: твій князь чи справедливий чоловік?

- Весь світ знає і подивляє його справедливість.

- То він, певно, і тебе вислав, щоб ти в наших горах насаджував
- справедливість?

Боярин змішався сим простим питанням, але по хвилевім вагованню
сказав:

- Так.

- А як думаєш, боярине, чи справедливий може несправедливо кривдити
- своїх підвладних? Боярин мовчав.

- Чи може він несправедливими поступками насадити в їх серця
- справедливість

і, кривдячи їх, з'єднати для себе їх любов і повагу?

Боярин мовчав, граючись вістрям свойого топора.

- Гляди ж, боярине,закінчив Захар.Уста твої мовчать, але сумління твоє
- каже, що се не може бути. А прецінь же твій справедливий князь
- зробив се з нами, з нами, котрих він не бачив і не знає, котрих
- добром і щастям він не турбується, котрі йому не вчинили нічого
- злого, але, навпаки, щороку складають йому багату данину. Як він міг
- се зробити, боярине?

Тугар Вовк блиснув гнівно очима на Захара і сказав:

- Плетеш дурниці, старий. Князь нікого не може скривдити!

- А прецінь нас скривдив, отою самою грамотою, котрою ти так хвалишся!
- Бо зважай лишень: чи не скривдив би я тебе, якби без твоєї волі зняв
- із тебе отой блискучий панцир і дав його мойому синові? А таке саме
- діло зробив твій князь

із нами. Що для тебе панцир, то для нас земля й ліс. Від віків ми
вживали їх і берегли, як ока в голові,- а тут нараз приходиш ти в
імені свого князя і кажеш:

«Се моє! Мій князь дав мені се в надгороду за мої великі заслуги!» І
«проганяєш наших пастухів, убиваєш нашого лісничого на нашій власній
«землі! Скажи ж, чи можемо ми уважати твого князя справедливим
«чоловіком?

- Ти помилився, старче! сказав Тугар Вовк.Усі ми власність князя, зі
- всім, що маємо, з худобою й землею. Князь один вільний, а ми його
- невільники. Його ласка то наша воля. Він може зробити з нами, що
- хоче.

Мов удар обуха в тім'я, так оглушили ті слова Захара Беркута. Він
похилив свою сиву голову додолу і довгу хвилю мовчав, не знаючи, що й
казати. Мертвецьки понуро мовчала й уся громада. Вкінці Захар устав.
Лице його ясніло. Він підніс руку догори, до сонця.

- Сонце преясне! сказав він.Ти благотворне, вольне світило, не слухай
- тих огидних слів, які осмілився сей чоловік сказати перед твоїм
- лицем! Не слухай їх, забудь, що вони сказані були на нашій, досі й
- помислом таким не оскверненій землі! І не карай нас за них! Бо
- безкарно ти не пропустиш їх, то знаю. І коли там

- у тім Галичі, довкола князя наплодилось багато таких людей то ти
- зітри їх із лиця землі, але за кару не погуби разом із ними всього
- нашого народу!

І по сім Захар услокоївся, сів і знов звернувся до боярина.

- Ми чули, боярине, твоє переконання,сказав він,не повторяй його
- другий раз перед нами, нехай воно при тобі лишається. Послухай же
- тепер, яка наша думка про твого князя. Послухай і не прогнівайся!
- Сам иачиш і знаєш, що вітця й опікуна ми в нім бачити не можемо.
- Отець знає свою дитину, її потреби й бажання, а він не знає нас і не
- хоче знати. Опікун береже свого підручного від ворога і від усякої
- шкоди,князь не береже нас ні від сльоти, ні від тучі, ні від граду,
- ні від медведя,а се наші найгірші вороги. Він, щоправда, голосить,
- що береже нас від нападів угорських вояків. Але як береже нас?
- Насилаючи на нас

іще гірших ворогів, ніж угри,-своїх неситих бояр з їх дружинами. Угрії
нападуть, заберуть, що можна, і підуть; боярин як нападе, то вже й
осяде, і не вдоволиться ніякими добича-ми, а рад би нас усіх навіки
поробити рабами. Не віт-цем і опікуном ми вважаємо твого князя, але
карою божою, зісланою на нас за гріхи наші, від якої мусимо від-
купуватися щорічними данинами. Чим менше ми про нього знаємо, а він
про нас, тим ліпше для нас. І коби вся наша Русь могла позбутися
сьогодні його з усіма його ватагами, то, певно, була би ще щаслива і
велика!

З дивним чуттям у серці слухав Тугар Вовк тих гарячих слів старого
бесідника.

Хоч вихований при княжім дворі і зіпсований гниллю та підлотою, він
усе-таки був рицар, вояк, чоловік і мусив відчути серцем хоч крихту
того чуття, яке так сильно порушувало серце Захара Беркута. А при тім
же він далеко не по щирій совісті виповідав уперед свої слова про
необмежену власть князя; його душа й сама не раз бунтувалася проти тої
власті, а тут він тільки хотів заслонити показом на княжу власть свої
власні забаги такої ж власті. Не диво, що слова

Захара Беркута запали йому глибше в душу, ніж він сам того бажав. Він
перший раз зі щирим подивом глянув на нього, але заразом і жаль йому
зробилося того велетня, якого упадок, по його думці, був близький і
неминучий.

- Старче, старче,сказав він,жаль мені твого сивого волосся і твого
- молодечого серця. Довгий час прожив ти на світі, здається навіть, що
- занадто довгий!

Живучи серцем у давнині і в гарячих думах молодості, перестав ти
розуміти нові, теперішні часи, їх погляди та потреби. Те, що було
давно, не мусить бути й тепер, ані вічно. Все, що живе,-
переживається. Пережилися й твої?юлодечі думи про свободу. Важкі тепер
часи надходять, старче! Вони домагаються конечно одного сильного
володаря в нашім краю, котрий би в однім осередку згромадив і в свою
руку уняв усю силу цілого народу для оборони його перед ворогом, що
надтягає зі сходу сонця. Ти, старче, не знаєш усього того, і тобі
здається, що давні часи ще тривають.

- І тут ти помилився, боярине,сказав Захар Беркут.Не подоба старому
- вдаватися в молоді мрії, а на сучасність жмурити очі. Але ж тричі не
- подоба йому по-мітуватися добрим для того, що воно старе, а хапати
- за лихе для того, що воно нове. Се звичай молодиків, і то зле
- вихованих молодиків. Ти закидаєш мені, що я не знаю того, що діється
- довкола нас. А тим часом не знати ще, хто з нас двох більше й
- докладніше се знає. Ти натякнув мені на страшного ворога, що грозить
- нам зі сходу сонця, і висловив думку, що наближення того ворога
- вимагає згромадження всієї народної сили в одних руках. Тепер я
- скажу тобі, що я знаю про того ворога. Правда, боярине, до тебе
- вчора прибіг княжий післанець, який оповістив тебе про новий напад
- страшних монголів на нашу країну, про те, що вони по довгім опорі
- зайняли Київ, і зруйнували його дотла, і тепер величезною хмарою
- тягнуть на наші червоноруські землі. Ми, боярине, знали се ще перед
- тижнем і знали про княжого післанця, виправленого в отсі сторони, та
- про його вісті. Княжий післанець прибув пізненько наші піс-ланці
- далеко скоріше ходять. Монголи давно вже аапо-веннли нашу Червону
- Русь, понищили багато городів і сіл і розділилися на дві ріки. Одна
- пішла на захід, мабуть, під Судомир, у польську країну, а друга йде
- горі долиною Стрию в наші сторони. Правда, боярине, що ти ще не знав
- сього?

Тугар Вовк з подивом, майже зо страхом, глядів на старого Захара.

- А відки ти се анаєш, старче? запитав він.

- Я й се скажу тобі, щоб ти знав, яка сила в громадах і в їх вольнім
- союзі. Зі всімп підгірськими громадами ми стоїмо в зв'язку: вони
- обов'язані нам, а ми їм докосити якнайшвидше всякі вісті, важні для
- громадського життя. Підгірські ж громади стоять у зв'язках з
- дальшими, покутськими та подільськими, тож про все, сяк чи так важне
- для нас, що діється на нашій Червоній Русі, йде блискавкою вість від
- громади до громади.

- Що вам з вістей, коли помогти собі не можете! згірдно буркнув
- боярин.

- Правду сказав ти, боярине,сумно відповів Захар.Подільські та
- покутські громади не можуть допомогти собі, бо вони обдерті та
- обезсилені князями та боярами, які не позволяють їм мати своє
- оружжя, ані вправлятися в робленню ним. От і бачиш, боярине, що се
- значить: єдинитн силу народу в одних руках!

Щоби з'єдинити в одних руках силу народу, треба ослабити силу народу.
Щоб одному надати велику власть над народом, треба кождій громаді
відібрати її свободу, треба розбити громадські зв'язки, обезоружити
громадські руки. А тоді всяким монголам одверта дорога в нашу країну.
Бо поглянь тепер на кашу Русь!

Твій владник, твій могу-чий князь Данило пропав десь безвісти. Замість
обернутися до свого народу, віддати йому його свободу і зробити з
нього живу, непоборну запору проти монгольського наїзду, він, поки
монголи руйнують його край, побіг до угорського короля, у нього
благаючи помочі. Але угри не поквапні помагати нам, хоч і їм самим
грозить та сама навала. Тепер твій

Данило щез десь, і, хто знає, може, незадовго його побачите в таборі
монгольського хана яко його вірного підданця, щоб ціною неволі й
пониження перед сильнішим купити собі власть над слабшими.

Боярин слухав того оповідання, і вже голова його почала укладати
плани: що діяти? Як використати таку пору?

- Так, кажеш, монголи грозять нападом і отсим горам?

Захар якось значучо всміхнувся на те запитання:

- Грозять, боярине.

- І що ж ви думаєте робити? Піддаватися чи боронитися?

- Піддаватися їм не можна, бо всіх, хто їм піддається, женуть вони на
- службу, і то в перші ряди, в найтяжчі бої.

- Значить, ви хочете боронитись?

- Що сила наша, спробуємо зробити.

- Коли так, то прийміть мене за свого воєводу. Я вас поведу до бою
- проти монголів!

- Постій, боярине, ми ще не дійшли до вибору воєводи. Ти ще не
- витолкувався зі своїх поступків у нашій громаді. Твою щиру волю до
- служби громаді ми приймемо, але батьки наші казали нам, що до
- чистого діла треба й чистих рук. А чи будуть твої руки чисті до
- такого діла, боярине?

Тугар Вовк змішався трохи таким наглим зворотом, а далі сказав:

- Старче, громадо,покиньмо давні урази! Ворог зближається, з'єднаймо
- свої сили проти нього! Доправ-дуючись своєї урази, ви можете лише
- пошкодити ділу, а хісна ніякого собі не добудете.

- Ні, боярине, не говори сього! Не своєї урази ми до-правдуємось, але
- самої правди. Неправдою прийшов ти до нас, боярине, не по правді
- поступав з нами,і як же ми можемо повірити тобі начальство над собою
- в війні з монголами?

- Старче, ти, бачу, завзявся роздратувати мене?

- Боярине, уважай, що тут суд громадський, а не забава! Скажи мені:
- осідаючи на тухольській землі, чи хотів ти бути членом громади, чи
- ні?

- Я присланий сюди князем як воєвода.

- Ми сказали тобі, що не признаємо права тзого над нами, а особливо
- права на нашу землю. Не тикай, боярине, наших земель і наших людей,
- а тоді, може,;.іи приймемо тебе до своєї громади як рівного між
- рівних.

- От як! скрикнув гнівно Тугар Вовк.Отака ваша справедливість! То я
- мав би нехтувати княжу ласку, а допрошуватися ласки від смердів?

- Що ж, боярине, інакше ти не можеш бути нашим громадянином, а не
- належного до громади громада й терпіти у себе не схоче.

- Не схоче терпіти? насмішливо скрикнув Тугар Вовк.

- Батьки наші казали нам: шкідливого і непотрібного члена громади,
- розбійника, конокрада або посторон-нього, що без волі громади
- забирав би громадські землі, з родиною такого прогнати з границь
- громадських, а дім його розвалити і зрівняти з землею.

- Ха-ха-ха! зареготався силуваним сміхом боярин.То ви сміли б мене,
- княжого боярина, наділеного княжою ласкою за мої заслуги, рівняти з
- розбійниками і конокрадами?

- Що ж, боярине, а скажи сам по совісті, чи ліпше ти поступаєш з нами,
- як розбійник? Адже ж землю нашу забираєш наше найбільше і єдине
- добро.

Людей наших гониш і вбиваєш на смерть, худобу нашу стріляєш! Чи так
роблять чесні громадяни?

- Старче, покинь таку мову, я її не можу слухати, вона нарушає мою
- честь.

- ІІостій, боярине, я ще не скінчив,сказав спокійно Захар Беркут.Отеє
- ти згадав про свою честь і раз у раз говориш про свої великі
- заслуги. Будь ласкав, скажи нам, які се твої заслуги, щоб і ми могли
- вшанувати їх!

- У двадцятьох битвах я проливав свою кров!

- Кров свою проливати, боярине, се ще не заслуга. І розбійник не раз
- проливає свою кров, а його ж за те вішають. Скажи нам, проти кого і
- за ким ти воював?

- Проти князя київського, проти князів волинських, і польських, і
- мазовецьких…

- Досить, боярине! Ті війни се ганьба, не заслуга, і для тебе, і для
- князів. Се чисто розбійницькі війни.

- Я воював і проти монголів над Калкою.

- І як же ти воював протії них?

- Як то як? Так, як повинен був воювати, не вступаючись із місця,
- поки, ранений, не дістався до неволі.

- Отеє ти добре сказав,не знаємо тільки, чи се правда.

- Як не знаєте, то й не мішайтеся в те, чого не знаєте.

- Постій, боярине, не насміхайся над нашим незнанням. Постараємось
- переконатися.

І за тим словом Захар устав і, звертаючись до громади, сказав:

- Чесна громадо, ви чули признання боярина Тугара Вовка?

- Чули.

- Чи може хто свідчить за ним або против нього?

- Я можу! озвався голос із народу. Мов стрілою поражений, стрепенувся
- боярин на той голос і перший раз уважно, з якоюсь тривогою поглянув
- на громаду.

- Хто може свідчити, нехай вийде перед громаду і свідчить,сказав
- Захар.

Перед громаду вийшов не старий ще чоловік, каліка, без руки і ноги,
навхрест перекалічений. Лице його було порите глибокими шрамами. Се
був Митько

Вовк, як звала його громада. Перед кількома літами зайшов він до
громади на кулі, розповідаючи страшні вісті про монголів, про битву
над Калкою, про погром руських князів і про смерть тих, що дісталися
до неволі, а потім під час обіду монгольських полководців були удушені
під дошками, на яких монголи засіли до учти. Він, Митько, також був у
тій битві в дружиш одного боярина і разом з ним дістався до неволі, з
якої потім якимсь чудом уйшов. Довго блукав він по селах і містах
святої Русі, поки вкінці не зайшов і до Тухлі. Тут йому сподобалося
жити, а що своєю одною рукою вмів плестіг скусні коші і знав багато
пісень та оповідань про далекі краї, то громада прийняла його р свої
члени, живила його і зодягала за чергою, загально люблячи і поважаючи
його за рани, понесені в війні з наїзником, і за його чесний, веселий
характер. Отой-то

Митько тепер вийшов свідчити протії боярина.

- Скажи нам, Вояче Митьку,почав питати його Захар,ти знаєш сього
- боярина, проти котрого хочеш свідчити?

- Знаю,відповів твердим голосом Митько.В його дружині я служив і був у
- битві над Калкою.

- Яке ж свідоцтво хочеш ти зложити проти нього?

- Мовчи, підлий рабе! скрикнув, побліднівши, боярин.Мовчи, а то тут
- буде й конепь твоя amp;му нужденному життю!

- Боярине, я тепер не раб твій, але вільний громадянин, і тільки моя
- громада може веліти мені мовчати. Я досі мовчав, але тепер мені
- велять говорити. Чесна громадо! Свідоцтво моє проти боярина Тугара
- Вовка велике і страшне: він зра…

- Мовчав досі, то мовчи й далі! ревнув боярин, блиснув топір, і Митько
- Вояк з розлупаною головою, окровавлений упав додолу.

Охнула громада і зірвалася на ноги. Страшний крик залунав довкола:

- Смерть йому! Смерть! Він зганьбив святість суду! На раді забив мужа
- нашого!

- Смерди погані! скрикнув до них боярин.Не боюсь вас! От так буде
- кождому, хто поважиться торкнути мене чи рукою, чи словом. Гей, мої
- вірні слуги, сюди, до мене!

Лучники і топірники, хоч самі бліді й тремтючі, обступили боярина.
Грізний, червоний з лютості, стояв він посеред них з кровавим топором
у руці. На знак

Захара громада втихла.

- Боярине,сказав Захар,ти смертельно провинивсь проти бога і громади.
- Ти на суді забив свідка, нашого громадянина. Що він хотів проти тебе
- свідчити, ми не дізналися і не хочемо знати,нехай твоя совість
- судить тебе. Але своїм убійством ти признався до вини і поповнив
- нову вину. Громада не може тебе терпіти на своїй землі. Віддалися
- з-між нас! За три дні віднині прийдуть наші люди, щоб розвалити твій
- дім і загладити навіть слід твого буття у нас.

- Нехай приходять! крикнув люто боярин.Побачимо, хто чий слід
- загладить.

Я плюю на ваш суд! Рад побачити того, хто приступить до мого дому!
Ану, мої слуги, ходімо з сього поганого збору!

Боярин віддалився зі своїми слугами. Довгий час стояла мовчанка в
зборі.

Молодці винесли кроваве тіло Мить-ка Вояка.

- Чесна громадо,сказав Захар,чи воля ваша поступити з боярином Тугаром

Вовком так, як батьки наші веліли поступати з такими людьми?

- Так, так! загула громада.

- Кого ж вибираєте до сповнення громадської волі? Вибрано десять
- молодців, між ними й Максима Беркута. Важко було Максимові приймати
- сей вибір. Хоч і як ненависний був йому боярин, але все-таки він був
- віт-цем тої, котра мов чаром опанувала його серце і його мислі, за
- котру він віддав би був життя. А тепер, о горе, і вона була
- засуджена, безвинно, за батькову провину. Але проте

Максим не відпирався від вибору. Хоч і як тяжке для нього було
завдання сповнити громадський засуд, усе-таки він у глибині свого
серця радувався ним: адже ж при тій нагоді він побачить її! А може,
йому удасться як-небудь потішити її, злагодити хоть своєю щирістю
острий засуд громади!..

А тим часом рада громадська йшла далі своєю чергою. Прикликано
післанців від сторонських громад, щоб і з ними нарадитись над тим, як
боронитися проти нападу монголів.

- Зруйновані ми,говорив післанець підгірських громад.Села наші
- попалені, худоби зрабовані, молодіж ви-гибла. Широкою рікою
- розлилися пожежі і знищення по Підгір'ю. Князь не дав нам ніякої
- оборони, а бояри, що тисли нас в часи спокою, зрадили нас у потребі.

Післанці з Корчина й Тустаня говорили:

- Нам грозить залива. Понижче Синевідська на рівнині біліють вже шатра
- монголів. Іде їх сила незлічима, і ми й думати не можемо про
- боротьбу й опір, але забираємо все і втікаємо в ліси та в гори.
- Бояри наші зачали були робити засіки на шляху, але якось вагуються.
- Шепчуть люди, що хотять запродати шляхи наші монголам.

Післанці з інших верховинських громад говорили:

- У нас урожаї лихі, а тепер з долів набігло до нас багато народу.
- Передновинок тяжкий. Рятуйте нас і наших гостей, поможіть перебути
- чорну годину!

Післанці з угро-руських громад сказали:

- Чули ми, що монгольська залива йде в угорську країну. На бога і
- богів батьків наших взиваємо вас, сусіди і браття: спиніть тоту
- страшну хмару, не допустіть її звалитися в нашу країну! Ваші села
- твердині; кожда скала, кожда дебра ваша стане за тисячу вояків. А
- скоро раз вони переваляться через гори, то вже там ніяка сила не
- спинить їх, і всі ми погибнемо марно. Ми готові дати вам поміч, якої
- зажадаєте,і хлібом, і людьми, тільки не опускайте рук, не тратьте
- надії, ставайте до бою з поганим наїзником!

Тоді Захар Беркут сказав:

- Чесна громадо, і ви, чесні посли сусідські! Всі ми тут чули, яка
- страшна хмара йде на нашу країну. Воєнні сили виступали проти них і
- погибли. Сила їх велика, а нещасні порядки на наших долах дозволили
- їм зайти аж у серце нашого краю, перед поріг нашої хати. Князі й
- бояри потратили голови або зраджують край свій очевидячки. Що нам
- тут зробити? Як нам боронитися? Я думав би, що нам поза границі
- нашої Тухольщини удаватися не можна. Шлях наш при вашій помочі,
- чесні загірні громадяни, ми чень оборонимо. Але інших шляхів ми
- оборонити не можемо. Се буде ваше діло, чесні тустанські громадяни,
- а коли б нам удалося наше діло, то ми й вам радо підемо допомагати.

На те сказали тустанські післанці:

- Знаємо ми, батьку Захаре, що вам ніяк іти нас боронити і ще в тій
- тяжкій годині треба, щоб кождий поперед усього за себе стояв. Але
- зважте лише, що наші громади не такі щасливі, як ваша, що бояри
- забрали нас у руки і вони держать сторожу над засіками й проходами.
- А як вони схотять видати їх монголам, то що ж ми порадимо? Лиш
- одного ми надіємось, і се може ще спасти нас: що монголи не підуть
- на ваш шлях і що в такім разі ви, забезпечивши свій шлях вартою,
- будете могли рушити нам на поміч.

- Ей, громадяни, громадяни,сумовито, але і з докором сказав Захар,і
- сила, бачиться, у вас у руках, і розум у головах, як у мужів, а
- бесіда ваша дитиняча!

Покладаєте надію на «може» та на «хто знає». Адже ж, сього будьте
певні, що скоро нам не грозитиме небезпека, то ми всею громадою
прийдемо вам на поміч. Але поперед усього вам належалось би
забезпечити себе проти ваших власних ворогів - бояр. Доки в їх руках
засіки і проходи, доти ви й дихнути безпечно не можете. Кождої хвилі
сей прехитрий рід може продати вас. Пора вам не дрімати, але вдарити в
дзвони і громадами поскидати з себе ті пута, в які обпутала вас
боярська неситість і княжа сваволя. Поки сього не буде, поти й ми не
зможемо допомогти вам.

Сумно похилили голови тустанські післанці на ті Захарові слова.

- Ей, батьку Захаре,сказали вони,знаєш тп наших громадян, а говориш,
- немовби зовсім не знав їх. Зламана у них давня відвага, притоптана
- їх воля. За твою раду дякуємо тобі і передамо її нашим громадам, але
- чи підуть вони за нею?.. Ей, коби ти був між ними і ска-вав їм своє
- слово!

- Невже ж таки, чесні сусіди, моє слово у ваших громадян може мати
- більшу вагу, ніж їх власна потреба, ніж їх власний розум? Ні! Коли б
- так було, то нічого вже й моє слово вам не поможе, то вже пропали
- наші громади, пропала наша

Русь.

Сонце геть-геть уже схилилося з полудня, коли тухольська громада по
скінченій раді вертала до села. Без радісних співів і викриків, сумно,
повагом ішли старі й молоді, повні важких дум. Що то принесуть їм
будущі дні?

Післанці сторонських громад, піднесені на дусі й заохочені,
порозходилися.

Тільки копне знамено, знак сили і згоди громадської, повівало високо і
весело в повітрі, і весняне небо ясніло пречистим блакитом, немов не
бачачи земної журби та тривоги.




ІV


Широкою рікою плили по Русі пожежі, руїна та смерть. Страшенна
монгольська орда з далекої степової Азії налетіла на нашу країну, щоб
на довгі віки в самім корені підтятії її силу, розбити її народне
життя. Найперші міста -

Київ, Канів, Переяслав - упали і були зруйновані до основи; їх слідом
пішли тисячі сіл і менших городів. Страшний начальник монгольський
Бату-хан, прозваний Батиєм, ішов на чолі своєї стотисячної орди,
женучи перед собою вчетверо стільки всяких полоняників, що мусили
битися за нього в перших рядах,- ішов поздовж руської землі,
розпускаючи широко свої загони і бродячи по коліна в крові. Про який-
будь опір на рівнім полі ніщо було й думати, тим більше, що Русь була
роз'єднана і роздерта внутрішніми межиусобицями.

Декуди ставали опором міщани в своїх мурах, і непривичні до ведення
правильної облоги монголи мусили не раз тратити багато часу, добуваючи
брам

і мурів топорами. Але слабі твердині падали більше через зраду і
підкупство, ніж силою поборені. Ціль походу страшної орди були Угри,
багата країна, заселена племенем, спорідненим з монголами, від котрого
великий Чінгісхан монгольський домагався, щоб йому піддалося. Угри не
хотіли піддатися, і страшенний похід монгольської орди мав їм показати
месть великого Чін- гісхана. З трьох боків разом, після плану Батия,
мала впасти орда до Угорщини: зі сходу в землю Семигород-ську, з
заходу з землі Моравської і з півночі через

Карпати. В тій цілі орда поділилася на три часті: одна, під проводом
Кайдана, пішла бессарабськими степами в Волощину, друга, під проводом
Пети, відділилася від головної орди в землі Волинській і поперек
Червоної Русі, через

Пліснесько, змагала до верхів'я ріки Дністра, щоб перейти її вбрід, а
далі розлилася по Підгір'ю, шукаючи проходів через Карпати. Взяті до
неволі місцеві люди, а також деякі бояри-зрадники провадили монголів
горі рікою Стриєм на тухольський шлях, і вже, як говорили корчинські
післанці, їх шатра білілися на рівнині понижче Синевідська.

Вечоріло. Густі сумерки лягали на Підгір'я. Лісисті тухольські гори
задимилися, мов незлічимі вулкани, готовлячись вибухати. Стрий шумів
по кам'яних бродах і пінився по закрутинах. Небо покривалось зорями.
Але й на землі, на широкій надстрийськііі рівнині, почали
розблискуватись якісь світила, зразу де-де, рідко, мов не-сміло, далі
чимраз густіше, сильніше,- поки врешті ціла рівнина, як далеко око
засягне, не покрилася ними, не розжеврілася кровавим облиском.

Мов море, порушене легким вітром, так меркотів той облиск над долиною,
то живіше палахкотячи, то мов розпливаючись у темніючім просторі. Се
палали нічні огнища в таборі монголів.

Але ген-ген у віддалі, де кінчилось те меркотяче море, палали інші
світила, страшні, широкі, бухаючи огняною загравою: се горіли околичні
села і слободи, окружаючи широкою огненною пасмугою монгольський
табір. Там бушували загони монголів, рабуючи та мордуючи людей,
забираючи в неволю та нищачи до основи все, чого не можна було
забрати.

Смерком уже їхало вузьким плаєм поверх синевідських гір двоє люда на
невеличких, та крепких гірських кониках. Один із їздців, мужчина вже в
літах, був у рицарськім строю, у зброї, з мечем і топором, з шоломом
на голові і з списом, прип'ятим до кінського сідла. З-під шолома
спливало довге і густе, сивіюче вже волосся на його плечі. Навіть
густі сумороки, що хмарою лежали на горах і величезними клубами
котилися з ярів і дебрів чимраз вище на верхи, не могли на його лиці
закрити виразу глибокого невдоволення, гніву і якоїсь сліпої
завзятості, що щохвилі розливався по ньому то їдким, прикрим сміхом,
то понурою хмарою,- немов щось шарпало його сустави несподіваними
судорожними рухами і давалося взнаки його гарному коневі.

Другий їздець - то була молода, гарна дівчина, одіта в полотняну,
шовковими нитками перетикану одежу, з невеличким бобровим ковпаком на
голові, що не міг вмістити в собі її багатого, буйного золотисто-
жовтого волосся. Через плечі у неї перевішений був лук з турового рога
і сагайдак зо стрілами, її чорні палкі очі ластівками літали довкола,
любуючись рівними, хвилястими контурами верховини і темно-зеленими
ситими барвами лісів та полонин.

- Що за гарна країна, таточку! скрикнула вона дзвінким, срібним
- голосом, коли коні їх на хвильку зупинилися на крутім пригірку,
- через який вони з трудом пробиралися, щоб перед цілковитим смерком
- доїхати до цілі.Що за чудово гарна країна! повторила вона вже
- тихішим, ніжнішим голосом, озираючись позад себе і тонучи поглядом у
- незглибимо темних зворах.

- А що за поганий народ живе в тій країні! гнівно відрізав їздець.

- Ні, таточку, сього не кажи! сказала вона сміло, але зараз же якось
- змішалась і, значно понизивши голос, додала по хвилі: Я не знаю, але
- народ тутешній мені сподобався…

- О, я знаю, що він тобі сподобався! скрикнув з докором їздець.А
- радше, що сподобався тобі один із того народу той проклятий Беркут!
- О, я знаю, що ти готова батька свого покинути для нього, що ти
- перестала вже любити батька для нього! Та що діяти така вже дівоча
- вдача! А тільки я кажу тобі, дівчино: не вір тому поверховому
- блискові! Не вір гадюці, хоч кораловими барвами міниться!

- Але ж, таточку, що за думки шибають по твоїй голові! І якими
- прикрими словами ти докоряєш мені! Я призналася тобі, що люблю
- Максима, і присягала перед сонцем, що буду його. Але я ще не його, я
- ще твоя. А хоч і його буду, то не перестану любити тебе, таточку,
- ніколи, ніколи!

- Але ж, дурна дівчино, ти не будеш його про се ніщо й думати! Хіба ти
- забула, що ти боярська дочка, а він смерд, вівчар?…

- Ні, таточку, не говори сього! Він такий рицар, як і інші рицарі,ні,
- він ліпший, сміліший і чесніший від усіх тих боярчуків, яких я
- бачила досі. Впрочім, таточку, дарма вже відмовляти я присягла.

- Що значить присяга дурної, осліпленої дівчини?

- Ні, таточку, я не дурна і не осліплена! Не в пориві дикої
- пристрасті, не без ваговання й думання я зробила се. Навіть не без
- вищої волі, таточку!

Остатні слова сказала вона якимсь приглушеним, таємничим голосом.

Боярин цікаво обернувся до неї:

- Ну, а се що знов? Яка вища воля спонукала тебе до такого безумства?

- Слухай, таточку,говорила дівчина, обертаючись до нього та звільняючи
- в

їзді.- Вночі перед тим днем, коли ми мали рушати на медведів,
показалась мені в сні моя мати. Така була, якою ти описував мені її: в
білій одежі, з розпущеним волоссям, але з лицем рум'яним і ясним, мов
сонце, з радістю на устах і з усміхом та безмірною любов'ю в ясних
очах. Вона приступила до мене з розпростертими руками і обняла мене,
сильно притискаючи до грудей.

«Мамо!» - сказала я і більше не могла нічого сказати з радості та
«розкоші, що наповняла цілу мою істоту.

«Мирославе, дитя моє єдине,- говорила вона лагідним, м'яким голосом,
«що й досі тремтить мені в серці,- слухай, що я тобі скажу. Велика для
«тебе хвиля зближається, доню! Серце твоє пробудиться і заговорить.
«Слухай свого серця, доню, і йди за його голосом!»

«Так, мамо!» - сказала я, тремтячи з якоїсь несказанної радості.

«Благословлю ж твоє серце!» - І сказавши се, вона розвіялася запахущим
«леготом, а я прокинулась. І серце моє справді заговорило, таточку, і
«я пішла за його голосом. На мені благословенство мами!

- Але ж, дурна дівчино, се був сон! Про що ти вдень думала, те вночі й
- приснилось тобі! А втім,додав боярин по недовгій хвилі,а вті:,г, ти
- вже й не побачиш його ніколи!

- Не побачу? скрикнула живо Мирослава.Чому не побачу? Хіба він умер?

- Хоч би й сто літ жив, то таки не побачиш його, бо ми ми не вернемось
- уже більше в ті прокляті сторони.

- Не вернемось? А се для чого?

- Для того,сказав боярин з силуваним супокоєм,що ті твої добрі люди, а
- поперед усіх той старий чорт, батько твого укоханого Максима,
- ухвалили на своїй раді вигнати нас із свого села, розвалити наш дім
- і зрівняти його з землею!

Але постійте ви, хамове плем'я, пізнаєте ви, з ким маєте діло! Тугар
Вовк - се не тухольський вовк, він і тухольським медведям зуміє
показати зуби!

Болюче тьохнуло в серці Мирослави, коли почула ті слова.

- Вигнали нас, таточку? І за що ж нас вигнали? Певно, за того
- лісничого, що ти казав так немилосердно бити, хоч я з слізьми
- благала тебе пустити його на волю?

- Як ти все те тямиш! підхопив злісно Тугар, хоч у серці глибоко
- вкололо його те скарження з уст доньки.О, я знаю, що коли б ти була
- на тій раді, то й ти була б стала за ними прогив свого батька! Що ж
- діяти,батько старий, понурий, не вміє блискати очима, ані зітхати, а
- тобі хочеться не такого товариша! І що з того, що батько отеє перед
- часом посивів, стараючись забезпечити твою долю, а той новий,
- миліший, молодший товариш, може, десь тепер зі своїми тухольпями
- руйнує нашу хату, остатнє й одиноке наше пристановище на світі!

Мирослава не витерпіла тих їдких докорів,- гарячі сльози бризнули з її
очей.

- Ні, се ти, ти не любиш мене,сказала вона, зали-ваючися слізьми,і я
- не знаю, що відвернуло твоє серце від мене! Я ж не дала тобі ніякої
- причини! Сам ти вчив і наказував мені жити по правді і говорити
- правду! Невже ж тепер нараз правда так дуже опротивіла тобі?

Боярин мовчав, похиливши голову. Вони зближалися вже до верха гори і
їхали вузькою дорогою поміж високими буками, що зовсім заслонювали
перед ними небо. Коні, здані на власну волю, самі шукали собі стежки
серед сутінків і, зчаста форкаючи, тюпали звільна по похилій
каменистій дорозі під гору.

- Куди ж ми їдемо, коли нас вигнано з Тухольщи-ни? спитала нараз
- Мирослава, отираючи рукавом сльози і підводячи догори голову.

- В світ за очі,відказав батько.

- Ти ж казав, що їдемо до одного боярина в гостину.

- Правда опротивіла мені: я сказав неправду.

- То куди ж їдемо?

- Куди сама хочеш. Мені все одно. Може, їхати до Галича, до князя,
- котрому я наприкрився і котрий рад був мене позбутися? О, хитра се
- штука, той князь!

Використати силу чоловіка, виссати його, мов спілу вишню, а кістку
кинути геть

- на те він якраз. І який рад був він, коли я попросив у нього
- даровизни землі в

Ту-хольщині! «Іди,- сказав мені,- нехай лишень тут не бачу тебе! Йди і
угризайся з тими смердами за нуясдек-ну межу, лиш сюди не вертай!» Ну,
що, може, їхати най до нього жалуватися на тухольців, просити напроти
них княжої помочі?..

- Ні, таточку! говорила Мирослава.Кня»а поміч злого не направить, а
- тільки ще дужче погіршить.

- А видиш,сказав боярин, небагато зважаючи на остатні слова доньки.Ну,
- а може, вертати нам до Тухлі, до тих проклятих хлопів, до того чорта
- Беркута, і просити у них ласки, піддатися їх карі, зректися свого
- боярства і благати їх, щоб нас прийняли до своєї громади, як рівні
- рівних, і жити з ними так, як вони,з вівцями вкупі, між вівсом і
- гноєм?

Постава Мирослави незамітно, мимоволі простувалася, лице її
прояснювалось при тих словах.

- А як гадаєш, таточку, чи вони приймили б нас? спитала вона живо.

- Хто знає! сказав гризько боярин.Се ще якби ласкаві були їх хамські
- величества й їх надвеличество Захар Беркут!

- Таточку, а чому ж нам не спробувати сього? Ту-хольці не люблять
- неправди; вони хоч і засудили нас, то, може, по свойому праву. А
- може… може, й ти, таточку, дечим… своїм острим поступованням
- причинився до того? А коли б лагідно, по-людськи з ними…

- Ах, боже, се що таке? скрикнула нараз Мирослава, перериваючи свої
- попередні міркування. Вони станули саме на вершку гори, і перед
- ними, мов силою чарів, розкинулася широка стрийська долина, залита
- морем пожеж і огнищ. Небо жевріло крозавим відблиском. Немов з
- пекла, неслися з долини дивні голоси, іржання коней, брязкіт зброї,
- переклики вартових, гомін сидячих при огнищах чорних, косматих
- людей, а геть-геть далеко ряздираючі серце зойки мордованих старців,
- жінок і дітей, в'язаних і ведених у неволю мужчин, рик скотини і
- хрускіт будинків, що, перепалені, валилися додолу, а по тім
- величезні водопади іскор, мов рої золотистих комах, збивалися під
- небо. В кровавім розблиску огнів виднілися тут же, в долині над
- рікою, довгі, безконечно довгі ряди чотиригранних шатрів, переділені
- від себе широкими ві.аб-ступами. Люди, мов мурашки, снували поміж
- шатрами і громадилися коло огнищ. Мирослава стала на той вид мов
- остовпіла, не можучи відірвати від нього очей. Навіть старий,
- понурий боярин не міг рушитися з місця, потопаючи очима в тім лячнім
- кровавім морі, ловлячи носом запах гіркого диму і крові, вслухуючись
- у змішаний гамір, у зойки, стогнання та радісні окрики побіди.

Навіть коні під нашими їздцями почали тремтіти всім тілом, стригти
вухами і форкати ніздрями, немов лякалися йти дальше.

- Тату, про бога святого, се що таке? скрикнула Мирослава.

- Наші союзники,сказав понуро Тугар Вовк.

- Ах, се мусять бути монголи, про котрих прихід говорив народ з такою
- тривогою?

- Так, се вони!

- Нищителі руської землі!

- Наші союзники проти тих проклятих смердів і їх громадівства.

- Тату, се загибель наша! Як не стане хлопів, то хто буде кормити
- бояр?

- Не бійся, не вродилась іще та буря, що здужала б до кореня знищити
- те підле насіння!

- Але ж, таточку, монголи не щадять ні хати, ні двору, ні князівської
- палати!

Сам же ти не раз оповідав, як вони подушили князів під дошками.

- І се добре! Нехай їх душать, тих хитрих круків! Але боярина не
- задушили ніякого. Ще раз кажу тобі: се наші союзники!

- Але ж, таточку, ти хотів би входити в союз із тими дикунами,
- обагреними кров'ю нашого народу?

- Що мене се обходить, хто вони і які вони? Крім них, ми не маємо
- виходу. А нехай вони собі будуть і самі злі духи, щоб тільки помогли
- мені!

Мирослава, вся бліда, тривожними очима гляділа на свого батька.
Кровавий відблиск огнів, що освічував околицю, робив його лице
страшним і диким і меркотів на його шоломі, немов обвивав те лице
кровавим вінцем. Вони обоє позлізали з коней і, стоячи на гострім
гребені гори, гляділи одне на одного.

- Який ти страшний, таточку,прошепотіла Мирослава.Я не пізнаю тебе!

- Говори сміло, говори, донечко! сказав з якимсь диким насміхом
- батько.Я знаю, що ти хотіла сказати! Ти хотіла сказати: ‹'Я не можу
- дальше йти з тобою, я покину тебе, зрадника вітчизни, а вернуся до
- свого милого, до свого вірного

Беркута!» Скажи, скажи се одверто - і покинь мене. Я піду, куди веде
мене доля,

і буду до кінця життя свого дбати про твоє добро!

Їдовитий голос боярина стався при кінці якимсь м'яким, тремтячим,
зрушуючим, так що Мирослава вибух-ла голосним плачем і кинулась
батькові на шию, гірко ридаючи.

- Ох, таточку,хлипала вона,як ти рвеш моє серце! Чим я так тяжко
- провинилася перед тобою? Я ж знаю, що ти любиш мене! Я… я не покину
- тебе ніколи! Я буду твоєю служницею, твоєю невільницею до остатнього
- віддиху, лиш не йди туди, не подавай свого чесного ім'я на вічну
- ганьбу!

Ридаючи, вона впала батькові до ніг і обнімала руками його коліна,
обливала слізьми його руки. Не видержав Тугар Вовк, капнули сльози з
його старих очей.

Він підняв Мирославу і міцно притиснув її до грудей.

- Доню моя,сказав він лагідно,не жалуйся на мене! Горе наповнило
- гіркістю моє серце, гнівом налило мої думи. Але я знаю, що твоє
- серце щире золото, що ти не покинеш мене в днях тривоги й боротьби.
- Адже ж ми самі тепер на світі, ні до кого нам прихилитися, ні від
- кого ждати помочі, а тільки від себе самих.

Вибору не маємо. Берімо поміч, де її знайдемо!

- Таточку, таточку! говорила з слізьми Мирослава.Гнів проти тухольців
- засліпив тебе і пхає тебе до загибелі. Нехай і так, що ми
- нещасливі,а чи для того мусимо бути зрадниками свого краю? Ні, радше
- згинути нам із голоду під плотом!

- Молода ти ще доню, гаряча, палка, і не знаєш, як смакує голод, як
- смакує нужда. Я зазнав їх і хочу оберегти тебе від них. Не переч же
- мені! Ходи, їдьмо до цілі! Що буде, те буде, долі своєї не об'їдемо!

І він скочив на свого коня і шпигнув його острогами. Даремно Мирослава
хотіла спинити його - він погнав униз горою. Ридаючи, подалася за ним
і вона. В своїй непохитній дитячій вірі вона все ще думала, що зможе
охоронити батька від загибелі, від віковистої ганьби - від зради свого
краю. Вона, бідна, й не знала, як глибоко її батько був уже застряг у
тім огиднім багні, як безповоротно він уже впав у безодню, так, що для
нього справді не було іншого виходу, як падати глибше, аж до дна.

Чим дальше з'їздили в долину, тим густіше пітьма обкапувала їх, тим
менше могли що-небудь бачити, крім блимання огнищ і жевріння
віддалених пожеж.

Зате гомін і рик величезної юрби ставався чимраз голоснішим,
оглушаючим.

Дим виїдав їм очі, захапував віддих у грудях. Боярин простував до
першого огнища, що палало серед поля. Се була монгольська сторожа.
Наближаючись, вони бачили п'ять люда в кожухах, обернених волоссям
догори, в таких самих пелехатих острокінчастих ковпаках, з луками на
плечах і з топорами в руках.

Аж недалеко варти Мирослава дігнала батька й сіпнула його за рукав.

- Таточку, богом святим молю тебе, вертаймо відси.

- Куди?

- Ходімо до Тухлі!

- Ні, пропало вже! Підемо, але не з униженою просьбою. Підемо в гості
- і рад я побачити, чи твої Беркути посміють тепер виганяти нас!

В тій хвилі монголи почули прихід чужих людей і з диким криком
похапали за луки та окружили їх.

- Хто їде? закричали різними голосами, то по-нашому, то по-свому.

- Поклонник великого Чінгісхана! сказав по-мон-гольськи Тугар Вовк.

Монголи стали, витріщившії очі на нього.

- Ти відки, що за один, за чим приходиш? спитав один, очевидно,
- начальник сторожі.

- Не твоє діло,відповів остро на монгольській мові боярин.Хто веде
- вашу силу?

- Внуки великого Чінгісхана: Пета-бегадир і Бурун-да-бегадир.

- Іди ж і скажи їм, що «Калка-ріка по болоті тече і в Дон упадає». А
- ми на твій поворот пождемо коло огнища.

З рабським ушанованням розступилися монголи перед незнайомим
приїжджим, що говорив їх мовою та й ще таким певним тоном, до якого
вони привикли від своїх ханів та бегадирів. В одній хвилі начальник
варти здав своє місце на другого а сам, допавши коня, погнав до
табору, якої, може, чверть милі віддаленого від вартового вогнища.

Тугар Вовк і Мирослава позлазили з коней, яких дехто з вартових зараз
узяли, обчистили, напоїли й прип'яли на мужицькій, житом засіяній
ниві. Приїжджі гості приступили до огнища, гріючи над ним руки, в які
щипав їх весняний нічний холод. Мирослава тремтіла цілим тілом, мов у
лихорадці, вона була бліда

і не сміла піднести очей ка батька. Аж тепер, почувши з батькових уст
монгольську мову і побачивши, з якою пошаною монголи сповняли його
волю, вона догадалася, що батько її не віднині знається з тими
страшними нищителями рідної землі і що правдивою мусить бути та вість,
яка глухо шепталась при дворі князя Данила, немовто Тугар Вовк у битві
над Калкою зрадив Русь монголам, виявивши їм наперед цілий план битви,
уложений руськими князями. Правда,- говорили вісті,- доказу на те
певного нема, а то б бояринові прийшлось понести голову на колоду;
боярин стояв у битві в першім ряді і при першім замішанню взятий був
до неволі. Але дивним видавалось декому його швидке увільнення без
окупу, хоч боярин божився, що Монголії випустили його, шануючи ного
хоробрість. Діло було темне, а тільки те було певне, що при княжім
дворі всі почали якось сторонити від Тугара і сам князь не довіряв
йому так, як довіряв давніше. Боярин вкінці почув тоту зміну і
попросив у князя даровизни землі в Тухольщині. Не допитуючись, для
чого задумав боярин покидати Галич і для чого хоче закопатися в такій
лісистій пустині, та й ще з молодою дочкою, князь Данило дав йому
даровизну - очевидно, рад був його позбутися. І при від'їзді з Галича
якось холодно прощалися всі з боярином - довголітнім товаришем оружжя.
Все те згадала тепер в одній хвилі Мирослава, і все те, що тоді
дивувало й гнівало її, стало тепер ясне й зрозуміле перед її очима.
Так, значиться, вісті й шепти говорили правдуі Так, значиться, батько
її віддавна, від десятьох літ, був у порозумінню з монголами, був
зрадником! Мов придавлена, мов підкошена тою гадкою, похилила
Мирослава свою прегарну голову додолу. Серце її боліло дуже: вона
чула, як у ньому одна за другою рвалися найсильніші й найсвятіші нитки
- нитки дитячої любові й поважання.

Якою самітною, якою круглою сиротою чула себе вона тепер на світі, хоч
тут же коло неї сидів її батько! Якою нещасною чула вона себе тепер,
хоч батько недавно ще запевнював її, що все робить для її щастя!

Але й боярин сидів тепер якийсь невеселий: його рішуче серце тисли,
очевидно, якісь важкі думи. Не знати, про що думав він, але його очі
гляділи, не змигаючи, в полум'я огнища, слідили уважно за тим, як
догорали червоні, мов розжарене залізо, поліна, як тріскали в огні,
злизувані полум'ям. Чи се було спокійне думання чоловіка, що дійшов до
своєї мети, чи, може, яке тривожне прочуття будущини холодною рукою
вхопило його за серце і печать мовчання положило на його устах? Тільки
ж і він, старий розважний чоловік, уникав погляду

Мирослави, лише глядів і глядів у огнище на миготячі іскри та
попеліючі поліна.

- Доню! сказав він вкінці стиха, не підводячи на неї очей.

- Чому ти вчора не вбив мене, тату? прошептала Мирослава, насилу
- здержуючи сльози в очах. Голос її, хоч тихий, дунув на боярина
- ледовим холодом. Він не знайшов на те питання відповіді, і мовчав, і
- вдивлювався в огнище, поки не прибіг вартівник із табору.

- Внуки великого Чінгісхана шлють свій привіт новому другові і просять
- його до свого шатра на воєнну раду.

- Ходімо! сказав коротко боярин і піднявся з місця.

Мирослава встала також, але ноги її відмовляли послуху. Та не час було
тепер вертатися. В одній хвилі монголи привели їх коней, висадили
Мирославу і, окруживши їх обоє, повели до табору.

Монгольський табір був розложений у величезнім чотирикутнику і
обкопаний глибоким ровом. В кождім боці чотирикутника було по
дванадцять входів, окружених оружною вартою. Хоч неприятель ніякий не
грозив таборові, то все- таки його стережено чуйно - таке вже було
воєнне правило монголів, зовсім у суперечність із християнським
рицарством, яке не дорівнювало монголам ані в військовій карності, ані
в умілості тактики та кер-мовання великими масами.

Вартові при вході табору дикими голосами перекликалися з вартовими, що
вели боярина з донькою, а потім перейняли незвичайних гостей і повели
їх до шатра своїх начальників. Хоч і як придавлена була Мирослава
своїм болем і стидом, що випалював гарячі рум'янці на її дівочім лиці,
то все ж вона була надто смілої вдачі, надто свобідно і по-рицарськи
вихована, щоб не зацікавитися розкладом табора і всім новим та
невиданим окруясен-ням. Бистрим оком окинула вона пооводжаючих її
вартових. Низькі, підсадкуваті їх постави, повбирані в овечі кожухи,
через які перевішений був у кождого лук і сагайдак зі стрілами,
виглядали мов медведі або які інші дикі звірі. Лице без заросту, з
вистаючими вилицями і підочними кістьми, з маленькими і глибоко
впалими очи. ма, що ледве блищалися з вузьких, скісно прорізаних
повік, з невеликими приплесканими носами, виглядали якось гидко,
відразливе, а жовтава їх барва, що в відблиску огнищ переливалася в
якийсь зеленкуватий відтінок, робила їх

іще страшнішими та відразливішими. З похнюпленими додолу головами і з
горляною, співучою мовою, вони подобали на вовків, що шукають, кого б
пожерти. Шатра їх, як Мирослава зблизька приглянулася, зроблені були з
войлоку, розп'ятого на чотирьох жердках, зв'заних угорі докупи, і
накриті були вверху для забезпеки від дощу великими шапками з кінської
шкіри. Перед шатрами стояли на жердках понастромлювані людські голови,
кроваві, з застиглим виразом болю і розпуки на блідих, посинілих,
світлом огнищ дивовижно освічених лицях. Холодний піт виступив на чоло
Мирослави На сей вид; її, геройську, смілу дівчину, не мучила думка,
що швидко й її голова так само стримітиме де-будь перед шатром якого
монгольського бегадира. Та ні, вона воліла б тепер тліти в пожежі і
стриміти як кро-вавий трофей перед шатром побідителя, аніж своїми
живими очима оглядати ті трофеї, з яких кождий недавно ще був живим
чоловіком, думав, працював і любив,- аніж іти здовж оцього страшного
табору на безчесне, зрадницьке діло!

«Ні, ні,-думалось їй,-не буде того. Я не піду дальше! Я не стану
«зрадницею свого краю! Я покину батька, коли не зможу відвести його
«від його проклятого наміру».

Тим часом вони станули перед шатром начальника чети, любимця
Батиєвого.

Шатро не відзначувалося від інших шатрів зверха нічим, окрім прип'ятої
на його вершку жердки з трьома бунчуками; зате всередині було далеко
пишніше, по- азіатськи уладжене. Тільки ж ані боярин, ані Мирослава до
середини шатра не входили, бо начальників монгольських застали перед
шатром, коло огнища, на котрім невільники пекли двох баранів. Поба-
чивши гостей, начальники схопилися всі враз на рівпї ноги і похапали
до рук свою зброю, хоч, впрочім, не поступилися з місця, щоби стрічати
їх. Знаючи монгольський звичай, боярин кивнув доньці, щоб лишилась
позаду, а сам, знявши з голови шолом, а з плечей лук, приступив до них
з поклоном і став мовчки, з похиленими до землі очима, на три кроки
перед головним начальником Петою.

- Від якого царя приносиш нам вісти? спитав його Пета.

- Я не знаю ніякого царя, крім великого Чінгісхана, пана всього світу!
- сказав боярин. Се була звичайна формула піддання. Пета тоді поважно,
- але радо простяг бояринові руку.

- В пору приходиш,сказав Пета,ми дожидали свого союзника.

- Я знаю свій обов'язок,сказав Тугар Вовк.В однім лишень я переступив
- ваш звичай: я привів доньку свою до табору.

- Доньку? сказав зачудуваний Пета.Хіба ж ти не знаєш, що звичай наш
- забороняє женщинам вступати в збір вояків?

- Знаю. Але що ж я мав зробити з нею? У мене нема дому, ні родини, ні
- дружини! Крім мене і великого Чінгісхана, вона не має ніякої опіки!
- Мій князь рад був позбутися мене зі свого міста, а ті прокляті
- смерди, мої невольники, збунтувалися против мене.

- Але все ж таки тут вона не може лишитися.

- Я прошу внуків великого Чінгісхана позволити їй лишитися нинішню ніч
- і завтрашній день, поки не винайду для неї безпечного пристановища.

- Для другів наших ми гостинні,сказав Пета, і потім, обертаючись до

Мирослави, він сказав ламаною руською мовою:

- Зблизись, дивчина!

Мирослава аж затремтіла, почувши ті звернені до себе слова страшного
монгольського начальника. Повними ненависті й погорди очима гляділа
вона на того нищителя Русі, зовсім не слухаючи його слів.

- Зблизись, Мирославе! сказав її батько.Великий начальник
- монгольського війська ласкавий до нас.

- Не хочу його ласки! відказала Мирослава.

- Зблизись, розказую тобі! сказав грізно боярин. Мирослава неохітно
- зблизилася.

Пета своїми малими блискучими очима поглянув на неї.

- Гарни дивчина! Жаль, що не остатись. Гляди, дивчина, на свій тат.
- Будь вірна велики Чінгісхан. Велика лас ка буде! На тоюі, дівчина,
- отсе коко, з вашого князь Мстислав. Знак безпеки. Покажи монгольськи
- вояк усі пропустить, нічого злого не зробить. А тепер до шатра?

З тими словами Пета подав Мирославі зі свого пальця великий золотий
перстень, здобутий ним у битві над Кал-кою з князя Мстислава. На
перстені буз великий золотисто-зелений берил із вирізаними на нім
фігурами. Мирослава вагувалася, чи прийняти дар від ворога,- може,
навіть заплату за батькову зраду.

- Візьми, доню, сей знак від великого внука Чінгіс-хана,сказав
- боярин.Се знак його великої ласки для тебе, дає тобі безпечний
- прохід у монгольськім таборі.

Нам-бо прийдеться розстатися, доню. їх воєнний звичай забороняє
женщинам бути в таборі. Але з тим пер amp;тенем ти можеш безпечно
приходити і виходити, коли тобі запотребиться.

Мирослава ще вагувалась. Але, втім, нова якась дума шибнула їй у
голову - вона взяла перстень і, відвертаючись, уриваним голосом
сказала:

- Дякую!

Потім Пета велів відвести її до окремого шатра, котре наборзі
приготовано для її батька, а Тугар Вовк лишився сам з монгольськими
бегадирами, щоб радити воєнну раду.

Перший забрав голос Пета, головний начальник сього відділу, чоловічок
літ коло сорока, тип монгола: невеличкий, повертливий, з хитро
мигаючими малими, мов мишачими, очима.

- Сідай, гостю,сказав він до боярина.Коли скажем тобі, що ми дожидали
- тебе, то нехай се буде найвища похвала твоєї вірності для великого
- Чінгісхана. Але все-таки ти троха запізно прийшов. Військо наше жде
- вже третій день, а великий

Чінгісхан, виправляючи нас на захід, до краю рабів своїх Арпадів,
наказував нам довше трьох день без потреби ніде не задержуватись. Брат
наш, Кайдан-бегадир, що пішов через край волохів, буде перед нами в
домі Арпадів, здобуде їх столичне місто, а яку ж славу ми принесемо з
того походу?

На те сказав боярин:

- Я порозумів слова твої, великий бегадире, і ось що відповім на них.
- Вірний слуга великого Чінгісхана не міг швидше прибути до вашого
- табору, бо аж учора дізнався про ваш похід, а дізнавшися, прибув
- зараз. Про задержку не журися. Шляхи наші хоч неширокі, але
- безпечні. Брама в царство Арпадів стане вам отвором, лиш тільки
- застукайте.

- Які шляхи і в чиїх руках? спитав коротко Пета.

- Один шлях дуклянський, горі Саном-рікою, а потім через низький
- гірський провал. Шлях широкий і вигідний, топтаний уже не раз
- руськими й угорськими воєнними силами.

- Далеко відси?

- Відси до Перемишля два дні ходу, а з Перемишля до гір іще два дні.

- Хто стереже?

- Стережуть його нашого князя бояри, що на нім поробили засіки. Але
- бояри нерадо служать князеві Данилові Романовичу, нерадо стережуть
- засіків. Мала обіцянка склонить їх на сторону великого Чінгісхана.

- Але чому ж досі ми нікого з них не бачили в нашім таборі? спитав
- Пета.

- Годі їм, великий бегадире. Народ, серед якого вони живуть і який
- мусить поставляти оружних людей для оборони засіків, нерадо зносить
- їх вдасть над собою. Дух бунту і непокори живе в народі. Серце його
- тужить за давніми порядками, де не було ні князів, ні власті, де
- кожда громада жила для себе, а против спільного вороге всі дружилися
- по добрій волі і вибирали та скидали свою старшину. В отсих горах
- живе один дід, що його прозвали бесідником, і той роздуває полум'я
- непокори в ім'я тих старих порядків. Народ глядить на бояр, мов
- пастухи на вовка, і скоро би тільки побачив, що бояри тягнуть у
- сторону великого Чінгісхана одверто, то побив біі їх камінням. Коли
- ж за приближенням вашої сили бояри піддадуться вам і віддадуть вам
- засіки, народ пирсне, як полова від вітру.

Пета слухав уважно бесіди боярина. Насміх і погорда заблискотіли на
його тонких губах,

- Дивні ж у вас порядки! сказав він.Князь бунтує против своїх слуг,
- слуги проти князя, князь і слуги против народу, а народ против
- усякої власті! Дивні порядки! У нас коли дрібні ватажки хотіли
- бунтувати проти великого

Чінгісхана, то той згромадив їх до свого аулу і, окруживши аул своїми
вірними синами, велів настановити вісімдесят великих кітлів на грані і
налити їх водою, а коли вода закипіла, то, не розбираючи нічиєї вини,
велів у кождий котел вкинути по два бунтівники і варити їх так довго,
поки тіло зовсім не відкипіло від кості. Тоді велів повиймати голі
кістяки з котлів, посадити їх коней і повідводити до підвладних їм
племен, щоб ті на примірі своїх ватажків училися послкху і покори
великому Чінгісханові. От так би і вас її вчити. І ми навчимо вас її.
Дякуйте богам, що зіслали нас до сього краю, бо коли б не ми, то ви,
певно, мов ті голодні вовки, пожерли б одні других.

Кров постила бояринові в тілі при тім оповіданню монгола, але він ні
словечка не відказав на се.

- Ну. а який же ваш другий шлях? спитав дальше Пета.

- Другий шлях тухольський,відповів боярин,хоч вужчий і не такий
- рівний, але зате ближчий і рівно безпечний. На тім шляху засіків
- нема, ані княжих бояр нема. Самі хлопи пильнують його.

- Хлопів ваших ми не боїмося! сказав з погордою Пета.

- І ніщо їх боятися,підхопив боярин.Вони ж без оружжя і без умілості
- воєнної. Тим шляхом я сам можу вам бути провідником.

- Але, може, на арпадській стороні ті шляхи сильно замкнені?

- Тухольський не замкнений зовсім. Дуклянський замкнений, але не дуже
- сильно.

- А довга дорога тухольським шляхом до краю Ар-падів?

- Для оружних мужів до Тухлі день ходу. В Тухлі переночувати, а разом
- зо світом у дорогу, і на вечір будете вже на рівнині.

- А дуклянським?

- Вчисляючи, кілько часу треба на понищення засіків, три дні ходу.

- Ну, то веди нас тухольським! сказав Пета.

- Дозволь мені слово сказати, великий бегадире,сказав один із
- начальників монгольських, мужчина величезного росту й геркулесової
- будови тіла, а лицем темно-оливкової барви, одітий у шкуру степового
- тигра, що все разом аж надто свідчило про його походження з тур-
- команського племені. Се був страшний, безтямно смілий і кровожадлия
- воновник, Бурунда-бегадир, супірник у славі з

Кайданом. Монгольські загони, які він провадив, лишали по собі
найстрашнішу руїну, найбільше число трупів, найширшу ріку пожеж. Він
безмірно переви-щав

Пету своєю відвагою; перед його шатром кождого вечора було два рази
більше свіжих голів, ніж перед шатром усякого іншого вояка. Але Пета
не завидів йому тої смілості, чуючи надто добре свою перевагу над
Бурундото в штуці ведення великих мас і кермовання великими битвами та
походами. Він радо пускав

Бурунду на найнебез-печніші місця, держав його в запасі на найтяжчу,
рішучу хвилю, немов непоборний залізний таран,- а тоді пускав його з
відділом

«кровавих туркоманів» довершувати побіди.

- Говори, брате Бурундо! сказав Пета.

- Дозволь мені з десятитисячним відділом іти ту-хольським шляхом, а ти
- сам простуй на дуклянський. Перейшовши на арпадський бік, я вдарю
- зразу на тих, що стережуть дуклянського шляху, і прорівняю тобі
- дорогу.

Пета з подивом глянув на Бурунду, немов се перший раз вирвалось тому
рубаці з уст таке розумне слово. І справді, план Бурунди був хоч і
смілий, та зате дуже розумний, і Бурунда був єдиний смільчак до
виконання сього плану.

- Добре,сказав Пета,нехай буде по-твойому! Вибирай собі вояків і рушай
- з ними зараз завтра.

- Позвольте ще й мені слово сказати, великі бегади-ри,сказав Тугар
- Вовк.

- Говори! сказав Пета.

- Коли воля ваша слати часть своєї сили тухольським шляхом,а всеї
- задля тісноти шляху й я не радив би слати,то позвольте мені піти
- наперед, з невеличким відділом і зайняти вхід того шляху, заким іще
- тухоль-ські смерди дізнаються про ваш прихід і завалять його
- засіками.

- Добре, йди! сказав Пета.Коли хочеш вирушити?

- Зараз, щоб іще завтра на південь сповнити своє діло.

- Коли так, то нехай буде конець нашій раді і нехай боги щастять нашій
- зброї! сказав Пета, встаючи з місця. Встали й інші начальники. Тугар
- Вовк просив

Пету, щоб визначив для нього відділ смілих мужів, а сам пішов до шатра
покріпитися і попрощатися з донькою.

В темнім шатрі на ліжку, покритім м'якими зрабова-ннми перинами,
сиділа

Мирослава і гірко плакала. По всіх страшних і несподіваних вражіннях
сього вечора вона аж тепер мала час зібрати свої думки, розглянути
добре своє теперішнє положення, в яке втягнув її батько. Положення те
було справді страшне, бачилось навіть - безвихідне. Батько її -
зрадник, монгольський слуга; вона-в монгольськім таборі, напівгість,
напівбранка, а на всякий спосіб кругла сирота. Бо навіть остання її
підпора - непохитна віра в свій пророчий сон, в благословення матері і
в своє любовне щастя з Максимом, - і тота віра тепер, при холодній
розвазі, зачала похитуватись, кровавлячи їй серце. Бо яким лицем стане
вона тепер перед Максимом? Якими словами розповість йому про свій -
добровільний чи недобровільний? - побут у монгольському таборі? Мов
гадюки, вертіли її серце ті питання, і вона дала сльозам волю і
плакала мов з життям своїм прощалася.

Батько тихими, тривожними кроками приступив до неї, положив руку на її
плече,- вона не підводила голови, не рушалась, не переставала плакати.

- Доню Мирославе,сказав він,не плач! Дасть бог, усе ще добре буде!

Мирослава мов не чула нічого, сиділа недвижне, холодна, безучасна.

- Забудь того смерда! Гарна будучність чекає тебе, а він… Що він?
- Завтра в полуднє він упаде трупом від мойого меча.

- Хто? скрикнула Мирослава роздираючим серце голосом.

Боярин злякався того голосу і відступився від дочки, що зірвалась на
рівні ноги.

- Хто впаде трупом? повторила вона.Він, Максим? Ти ведеш напад на
- Тухлю?

- Та ні, ні! відпекувався боярин.Хто се сказав тобі?

- Сам ти сказав! наставала на нього Мирослава.Тату, скажи мені правду,
- що задумуєш? Не бійся за мене! Я тепер і сама вже добре бачу, що не
- можу бути

Максимова, через тебе не можу бути! О, ти розумний, ти хитрий! Ти
допровадив до свого! Не для того я не можу бути Максимова, що вища від
нього родом,- о ні! Я нижча від нього, я чую себе безмірно нижчою від
нього, бо він чиста, чесна душа, а я дочка зрадника, може, й сама
зрадниця? Так, тату! Ти дуже хитрий, такий хитрий, що аж себе самого
перехитрив! Ти кажеш, що мого щастя бажаєш, а ти вбив моє щастя. Але
нехай і так! Що з мене за хосен? Тільки скажи мені, що ти задумуєш
напротив нього?

- Але ж нічого, зовсім нічого! Він тепер, може, вже десь далеко в
- горах.

- Ні, ні, ні, не вірю тобі! Скажи мені, що ви урадили з монголами?

- Говорили про те, куди йти на Угри.

- І ти їм хочеш видати тухольський шлях, щоби по-мститися на
- тухольцях!

- Дурна дівчино, що мені мститися на них! Задрібні вони для моєї
- месті. Я хочу перепровадити монголів на Угри, бо чим скорше підуть
- із нашого краю, тим менше тут руїн нароблять.

- О, певно, певно! скрикнула Мирослава.Але з поворотом доруйнують, що
- тепер лишать ціле! І ти ведеш їх на Тухлю, тепер, зараз?

- Ні, не на Тухлю. Я веду тільки один малий відділ, щоб обсадити вхід
- до Тухлі.

- Хто має браму, той має й хату! Але розумію тепер! Ти ж сам сказав
- недавно он там, на горі, що завтра Максим має з тухольськими
- молодцями валити наш дім.

А ти хочеш з монголами напасти на нього, вбити його…

Боярин видивився на неї зачудуваними очима; він почав боятися, чи не
відьма вона, що так страшно бистро вгадувала, в чім діло.

- Доню, забудь за нього! сказав він.Яка доля йому судилася, така й
- буде.

- Ні, тату, тим ти не зведеш мене! Я їду, їду до Тухлі, я остережу
- його, спасу його від твоєї засідки! А коли в неї попадеться, то я
- стану обік нього і буду боронитися разом з ним, до остатнього скону,
- проти тебе, тату, і твоїх поганих союзників!

- Дівчино, ти божевільна! скрикнув боярин.Уважай, не доводи мене до
- гніву!

Се хвиля рішуча.

- Що мене обходить твій гнів! відказала холодно Мирослава.І що ти мені
- можеш іще більше злого зробити після того, що зробив досі? Коли
- уб'єш мене, то се буде тільки добродійство, бо й так мені не жити.
- Пусти мене!

- Ні, лишись тут, нерозумна!

- Так, лишись тут, поки ти спокійно не замордуєш того, хто дорожчий
- мені над життя моє! О ні, я не лишусь!

- Лишись! Богом клянусь тобі, що не підійму руки своєї на нього!

- О, знаю, знаю, що се значить! скрикнула Мирослава.-Ну, розуміється,
- ти боярин, де ж би ти піднімав руку на смерда. Але своїм диким
- товаришам велиш усі затроєні стріли націлити на його груди!

- Ні! Коли вже таке твоє над ним милосердя, то ще раз клянусь тобі, що
- ані я, ані ніхто з моєї дружини не ткне його, хоч би він не знати як
- нападав на нас! Досить тобі сього?

Мирослава стояла, шарпана страшною сердечною тривогою, і не могла
нічого більше сказати. Хіба ж вона знала, чи досить сього, чи ні? О,
як радо була б вона пташкою злетіла до нього, щирим щебетанням
перестерегла його! Але годі було.

Батько її взяв свою зброю і, виходячи з шатра, сказав:

- Доню, ще раз кажу тобі і заклинаю тебе: лишись у таборі, поки я не
- вернусь, а тоді роби собі, що твоя воля буде. А тепер прощай.

Він вийшов, і заслона з войлока, що служила замість дверей, неспокійно
захиталася за ним. З заломаними руками, образ найтяжчого горя і
найстрашнішої тривоги, стояла Мирослава насеред шатра німа, перехилена
наперед, з створеними устами, ухом ловлячи остатній стук кінських
копит, що глухли й німіли по мірі того, як віддалявся на полуднє
відділ монголів, ведений батьком на загибель Тухольщини.




V


З важким серцем ішов Максим Беркут посеред невеличкої ватаги
тухольських молодців на сповнення громадської волі. Відмалку виріс він
у глибокім почуванню своєї єдності з громадою і святості громадської
волі, тож і тепер, коли зовсім не впору для його серця на нього впав
почесний вибір громади - прогнати з громадських земель ворога громади,
якого бачили тухольці в боярині,- і тепер він не смів відмовитись від
того поручен-ня, хоч серце його рвалося і краялось на саму думку, що
буде мусив стрітися з Мирославою, з її батьком як з ворогами, що буде,
може, мусив боротися з боярськими лучниками або і з самим боярином,
проливати кров людську в очах тої, за котру він сам готов був свою
кров пролити. Правда, він твердо рішився зробити своє діло як можна
найспокійніше і не доводити його аж до проливання крові, але хто ж міг
йому заручити, що боярин, знаючи його слабу сторону, сам не буде
шукати зачіпки? Се легше могло бути, як що.

«Але ні,- думав собі Максим,- коли схоче моєї крові, я не буду
«боронитися, я надставлю йому свої груди добровільно, нехай б'є! Життя
«він не хоче мені дати, то нехай дає смерть! Прощай, моя Тухольщино!
«Прощай батьку мій, соколе сизий! Прощайте, браття і товариші мої! Не
«побачите вже Максима, а почувши про мою смерть, посумуєте і скажете:
«Згинув для добра громади!» Але ви не будете знати, що я сам бажав і
«шукав смерті!»

Так думав Максим, наближаючись до будинків боярських на горбку над

Опором. Дім боярина збудований був із грубих, у чотири гранки гладко
обтесаних і гиблем на споєннях вигладжених ялиць, будованих в угла,
так, як тепер ще будують наші сільські хати. Покритий був грубими
драницями, обмазаними зверха грубою верствою червоної, в воді не
розмокаючої глини.

Вікка, як і у всіх хатах, обернені були на полуднє; замість шибок
понапинані були на рами волові міхури, що пропускали слабе жовтаве
світло досередини.

Входові двері спереду і ззаду вели до просторих сіней, яких стіни
обвішані були всіляким оружжям, оленевими та жубровими рогами, шкурами
з диків, вовків і медведів. З сіней на оба боки вели двері до кімнат,
просторих, високих, з глиняними печами без коминів і з дерев'яними,
гарно вирізуваними полицями на всяку посуду. Одна світлиця бояринова,
а друга, по другім боці сіней,- його доньки. Ззаду були дві широкі
комори: в одній кухня, в другій - служебна. В світлиці боярина стіни
були обвішані шкурами мед-ведів, тільки над постіллю висів дорогий
заморський килим, здобутий боярином у якімсь поході. Там же висіли
його луки, мечі й інша підручна зброя. Світлиця ж Мирослави була, крім
м'яких шкур по стінах і помості, пристроєна в цвіти, а на стіні
навпроти вікон, над її ліжком, висіло дороге металеве дзеркало і обік
нього дерев'яний, сріблом окований чотириструнний теорбан, любий
повірник Мирославнних мрій і дівочих дум. Віддалік від дому, на
невеличкій долині, стояли стайні, стодоли й

інші господарські будинки; там також була невеличка хата для скотарів.
Але пусто і глухо було сьогодні в просторім боярськім домі. Боярина і
Мирослави нема дома, слуг боярин повідправляв, худобу велів перегнати
до череди сусіднього, корчинського, осадника; тільки лучники й
топірники лишилися, та й ті якісь невеселі, не гомонять, не жартують,
ані пісень не співають. Мабуть, важніше якесь жде їх діло, бо беруть
луки і стріли, топори й списи, а все те мовчки, сумовито, мов на
смерть готуються. Що се такого?

Та ось один, що стояв серед шляху, мов на сторожі, дав знак трубою,- і
в повній зброї всі дружинники стали в ряд перед боярським дот.юм,
піднявши списи, нап явши луки, мов до битви. По шляху надійшла
тульська ватага і. побачивши оружних людей перед бояр-ським домом,
почала й собі готовитися до бою

Тривожними очима позирнув Максим на оружних людей, чи нема між ними
боярина. Але, на щастя, боярина не було. Відітхнув Максим, немов гора
з грудей його звалилася, і сміліше почав порядкувати свою ватагу Се й
недовго часу забрало, і мовчки, з понатяганими луками, з блискучими
топорами і списами тухольці зближалися в ряді до боярських
дружинників. Не дальше як на п'ятдесят кроків одні від других
зупинилися.

- Боярине Тугаре Вовче! кликнув голосно Максим.

- Нема боярина Тугара Вовка! відповіли дружинники.

- Так ви, вірні його, слухайте, що я скажу вам від імені тухольської
- громади!

Післала нас громада, щоб прогнати вас волею чи неволею з тухольських
земель по засуду громадському. Питаємо вас: чи вступитесь по волі, чи
ні?

Дружинники мовчали.

- Питаємо другий раз! сказав Максим. Дружинники мовчали, не спускаючи
- луків.

- Питаємо третій раз! сказав, підносячи голос,

Максим.

Дружинники мовчали, але стояли недвижне в своїй ворожій поставі. Дивно
було

Максимові, що се має значити, але, не зупиняючись довше, він велів
своїм молодцям випустити стріли на дружинників. Стріли засвистіли, мов
змії, і, перелетівши понад головами дружинників, повбивалися в стіну.
В тій хвилі дружинники, мов на даний знак, кинули зброю на землю і з
простягненими руками ступили напроти тухольських молодців.

- Товариші, браття! сказали вони.Не прогнівайтесь на нас за нашу
- мовчанку.

Ми дали слово бояринові, що стрітимо вас ворожо, але ми не давали йому
слова проливати вашу кров, і проливати її за неправду. Ми були при
суді громадськім

і знаємо, що боярин скривдив громаду і що громадський суд
справедливий.

Робіть, що вам повелено, і, коли буде ласка батьків ваших, ми будемо
просити

їх, щоб прийняли нас до своєї громади. Не хочемо більше служити
бояринові!

Радість тухольців, а особливо Максима, коли почули ті слова, була
безмежна.

Зараз усі поскидали оружжя на купу перед боярським домом і серед
голосних веселих криків обіймали й цілували своїх нових і несподіваних
товаришів, з якими перед хвилею думали вступити в смертельний бій.
Максим найдужче рад був тому, що його побоювання не справдилося, що
йому не довелось перед очима Мирослави поборювати її батька і прого-
нювати на незвісні шляхи ту, з якою рад би був ніколи не розстатися.
Радість сумирного закінчення сеї немилої справи на хвилю заглушила в
нім усякі інші непевності. В товаристві веселих боярських дружинників
увійшли тухольці до боярського дому, все з зацікавленням оглядаючи,
хоч нічого не тикаючи. З сердечним трепетом наближався Максим до
світлиці Мирослави, надіючись тут стрітити її в сльозах або в гніві,
бажаючи щирим словом потішити, заспокоїти її. Але Мирослави не було в
світлиці, і се затурбувало Максима. «Де вона?» -подумав він і зараз
надумав спитати про се дружинників, що тим часом вешталися,
приготовуючи на радощах для своїх тухольських гостей братерську
гостину. Але відповідь дружинників на його питання зовсім не вдоволила
й не заспокоїла Максима.

Боярин учора рано виїхав з донькою, але куди, за чим, коли верне - не
знати.

Велів їм виступити вороже проти тухольців, але, чи то побачивши їх
понурі неохочі лиця, чи то, може, повзяв-ши яку іншу думку, урвав
бесіду й від'їхав. От

і все, що дізнався Максим від нових союзників. Очевидна річ, що такі
вісті мусили відразу закаламутити його чисту радість, ба навіть кинути
тінь якогось підозріння на дружинників. Що се таке? Чи не криється в
тім яка зрада? Чи не хоче боярин зловити їх у яку засідку? Але, не хо-
тячи всім уголос виявляти свого підозріння, Максим шепнув тільки
деяким із своїх товаришів, щоб малися на бачності, а сам почав пильно
і уважно переглядати весь дім від гори аж до долу, не минаючи ні одної
скритки, ні одного закамарка. Ніде не було нічого підозреного.

- Гарна будова! сказав Максим до дружинників, що заставляли столи.Але
- що ж, ми мусимо її розібрати. Звісна річ, ми не будемо її ні валити,
- ні палити, але зложимо все порядно на купу, щоб боярин, коли
- запотре-бує, міг собі все те забрати. І все добро його мусить бути
- йому схоронене в цілості.

Тим часом дружинники повиносили до сіней велиш дубові столи із
світлиці, прикрили їх білою скатертю і заставили всілякою стравою й
медом. Серед радісних окликів і співів почалася гостина. Тільки ж чим
довше сиділи молодці за столами, чим більше їли й пили, тим більше
щезала якось їх радість і веселість. І хоч мед пінився в точених
дерев'яних кубках, хоч м'ясо, печене на рожнах, димилось на дерев'яних
тарілках, хоча щирі, товариські слова гомоніли від одного кінця стола
до другого, то все-таки таємно тремтіли чогось усі серця, немов
дожидали якоїсь страшної вісті. Дивна недослідна, а всім чутна тривога
висіла в повітрі. Чи стіни боярського дому давили вільних громадян?..

Ось устав один із боярських дружинників і, піднімаючи вгору кубок,
повен пінистого меду, почав говорити:

- Браття! Радісний сей день для нас, і щоб ніяка лиха пригода…

Але не скінчив. Разом поблід і затремтів цілим тілом. Усі бенкетарі
напруго посхапувались і, вискакуючи хто куди міг, перевернули стіл з
усіма кубками і стравами.

- Що се? Що се? крикнули всі нараз і поперлися до дверей. Хоч і як
- дрібний на око і мало значучнй був знак глухий стук кінських копит,а
- прецінь якого безмірного переполоху наробив він у боярськім домі!
- Одну хвилю дійсне пекло було в сінях: сей біг туди, той сюди, сей
- шукав того, той сього, а всі мішалися і товпилися без ладу, топчучи
- по кубках і стравах, по білій скатерті і по дубовім переверненім
- столі. Максим перший вирвався надвір із тої замішанини і, раз тільки
- кинувши оком довкола, пізнав усю велич небезпеки.

- До зброї, браття, до зброї! Монголи! Монголи! Той крик був мов
- наглий удар грому. Всі стали мов мертві, безладна сумішка
- перемінилася на безладне остовпіння. Але й се тривало тільки хвилю.
- Стукіт кінських копит розлягався все ближче і ближче, а неминуча
- небезпека разом обудила всіх із мертвоти!

Адже ж усі були смілі, сильні, молоді! Адже ж кождий із них не раз у
своїх дитячих і молодечих снах бачив себе в битві, в небезпеці, в
кровавій боротьбі з ворогом, і бажав, і молився, щоб сон стався явою,
щоб довелось йому колись ставати грудьми в обороні свого краю. І ось
хвиля надійшла - і вони ж мали б її перелякатися? Тільки на хвилю
оглушила їх страшна вість, страшна назва

«монголи»,- в найближчій хвилі вони вже були тим, чим були звичайно:
«вже кождий держав у руках свою зброю, стояв у ряді поруч з іншими,
«готовий до кровавого бою.

- Головне діло наше, товариші, держатися сих стін. Поки ворог не випре
- нас від сього дому і не окружить на вільнім полі, поти не маємо чого
- боятися. Дім сей то буде наша твердиня!

І він розставляв лучників коло вікон, коло дверей по два і по три, як
до важності й доступності місця. Деякі мали бути внутрі дому, щоб
доносити з боярського складу лучникам стріл і рогатин, головна ж сила
мала стояти при входових дверях, щоб, у разі потреби, проломити ряди
напасників і відбити їх від дому.

А тим часом монголи на ріні над Опором зупинилися, позлазили з коней
і, розділившися на три відділи, рушили під горбок трьома стежками.
Очевидно, провадив їх хтось добре знайомий зі стежками й ходами, бо
цілий той маневр відбувся швидко, без вагання, без довшої запинки.
Маневр той показував ясно, що монголи хотіли зі всіх боків обійти й
окружити дім відразу.

Але хто се йде так завзято на чолі середнього, головного, відділу
монголів?

Глядять товариші і очам своїм віри не ймуть. Се не хто другий, як сам
властитель сього дому, гордий боярин Тугар Вовк.

- Наш боярин! Наш боярин! скрикнули деякі дружинники, яких Максим, не
- довіряючи їх щирості, поставив у ряди всуміш із тухольцями.

- Так, ваш боярин монгольський слуга, зрадник своєї батьківщиниі Невже
- ж ви й тепер іще схочете додержувати йому вірности?

- Ні, ні! скрикнули дружинники однодушно.Смерть зрадникові! Розіб'ємо
- вражу ватагу або самі погинемо в обороні свого краю.

Урадуваний тою заявою, сказав Максим:

- Простіть, браття! Одну хвилю я несправедливо судив вас, думаючи, що
- ви в змові зі своїм боярином. Але тепер бачу, що кривду робив я вам.
- Держімося разом, близько стін, так, аби не могли нас окружити, і
- стараймося завдавати їм якнайбільше страти. Монголії, як я чув,
- недобре вміють вести облогу, а ще в такій невеличкій силі. Чей, нам
- удасться відбити їх напад.

Бідний Максим! Він старався в інших вмовити надію, яка у нього самого
почала щезати від першої хвилі, коли тільки побачив монголів, і то тим
більше тепер, коли переважна їх сила вповні розвернулася перед очима
обля-жених. Але все- таки його слова мали велику вагу в його
товаришів, що не раз уже мали нагоду переконатися про його притомність
духу й оглядність в часі найбільшої небезпеки. Сліпо полягаючи на його
словах і розказах, кождий дбав лише про те, щоб пильнувати свого місця
до крайньої можності, знаючи добре, що й сусіднє місце буде так само
пильноване.

Та ось монголи широким колесом у три ряди обступили вже дім боярський
і кам'яні стріли на своїх луках держав? вже намірені на смілих
обляжених молодців. Тільки що начальник не дав іще знаку до бою.
Начальник, бачиться, хоче попереду пробувати ще намови, бо ось він
виступив з-поміж рядів наперед против головного відділу обляжених і
каже:

- Раби невірнії! Погані смерди! Невже ж зухвалість ваша така безмежна,
- як і ваша дурнота, що ви хотіли би піднімати оружжя на військо
- великого

Чінгісхана, нині безперечного пана всеї Русі? Піддайтеся йому без бою,
то він помилує вас. Але ті, що захотять опиратися його силі, будуть
нещадно роздавлені, як хробаки під колесами воза.

На таку мову голосно і сміло відповів Максим Беркут:

- Боярине! Дуже не впору назвав ти нас, синів вольної громади, рабами!
- Ти поглянь на себе! Може, до тебе така назва борше пристане, ніж до
- нас. Адже до вчора ще був ти раб княжий, а нині ти вже раб великого
- Чінгісхана і, певно, полизав молоко, розлите по хребті коня якогось
- його бегадира. Коли воно тобі смакувало, то ще з того не виходить,
- щоб і ми були ласі на нього. Великої сили великого Чінгісхана ми не
- лякаємось. Вона може нас зробити трупами, але не зробить нас рабами.
- А тебе, боярине, вся сила великого Чінгісхана не зробить уже ані
- вольним, ані чесним чоловіком!

Остра і різка була бесіда Максимова. Іншим часом він уважав би на те,
що перед ним батько Мирослави, але тепер він бачив тільки ворога - ні,
зрадника, чоловіка, що потоптав сам свою честь, котрому, проте, ніяка
честь не належиться. Голосно радувались товариші, почувши таку
Максимову мову. А боярин аж пінився зо злості.

- : Хлопе поганий! - кричав він.- Жди лишень, я тобі покажу, що
- : завчасно ти похвалявся своєю вільністю! Нині ще кайдани забряжчать
- : на твоїх руках і ногах! Нині ще ти будеш валятися в поросі перед
- : начальником монгольської сили!

- Швидше згинути! відповів Максим.

- Отже, не згинеш! крикнув боярин.Гей, діти,озвався він до монголів
- їхньою мовою,далі на нихі Тільки сього обминайте, сього мусимо мати
- живого в руках!

І він дав знак до бою. Залунав по горах і лісах роговий вереск і
урвався.

Стишилось довкола боярського дому, але се була страшна тиша. Мов
гадюки, свистіли монгольські стріли, градом сиплючись на боярську
оселю.

Правда, напасники були занадто далеко віддалені, щоб їх стріли могли
трафляти оборонців або, трафивши, небезпечно ранити їх. Для того
Максим крикнув до своїх товаришів, щоб тепер іще не стріляли і щоб
узагалі щадили стріл і зброї, а вживали їх аж тоді, коли можна добре
влучити ворога і одним ударом нанести йому значну страту. А щоб не
відразу припустити напасників до стін дому, він зі своїми вибраними
товаришами уставився на подвір'ю, о яких двадцять кроків перед входом,
ва міцним дощаним остінком - куснем недобудованого паркана.

Паркан був якраз у хлопа зависокий, і стріли монгольські не досягали
молодців.

Зате їх цільні, хоч і рідкі, стріли смертельно разили монголів і
стримували їх від наближення. Страшно розлютився Тугар Возк, побачивши
се.

- Приступом до них! крикнув він, і збита громада монголів під його
- проводом кинулася бігцем із голосним криком до остінка. За остінком
- було тихо, немов усе там вимерло. Ось-ось уже монголи добігають,
- ось-ось своїм напором обалять остінок; коли втім понад остінком
- вирвався, мов із землі виріс, ряд голів

і могутніх рамен - і свиснула громада сталених стріл, і ревнули з болю
поражені монголи страшними голосами. Половина їх упала мов підкошена,
а друга половина перла назад, не дбаючи на крики і прокляття боярина.

- Гурра, молодці! Гурра, Максим! Гурра, Тухольщи-на! закричали
- оборонці, і дух вступив у них. Але боярин, не тямлячись зо злості,
- зібрав уже другу громаду до нападу. Він повчав монголів, як треба
- нападати і не розсипатися за першим ударом противника, але бігти по
- трупах дальше. Тим часом і Максим поучав своїх молодців, що діяти, і
- з піднесеним оружжям ждали вони нападу монголів.

- Далі на них! крикнув боярин, і поперед усього цілими хмарами пустили
- монголи ряд стріл на противників, а потім знов пустилася громада
- приступом на остінок. Знов перед наближенням стрітили їх молодці
- цільними стрілами, і знов частина напасників із страшним криком
- упала на землю. Але решта вже не метнулася назад лише з оглушаючим
- криком летіла далі й досягла остінка.

Страшна була хвиля. Тонкий дощаний остінок ділив від себе смертельних
ворогів, що, хоч як близько себе були, не могли досягнути одні одних.

Хвилю мовчали одні й другі, тільки швидкий, гарячий віддих чути було
по обох боках остінка. Раптом, мов на даний знак, загримали
монгольські топори о ості- нок, але в тій самій хвилі тухольські
молодці сильними підоймами підважили вгору остінок, поперли його
плечима і обалили на монголів. А разом з тою хвилею, коли впав
остінок, обаляючи своїм тягарем передні ряди монголів, скочили наперед
молодці, узброєні в топори на довгих топорищах, лупаючи ними черепи
монгольські. Забризкала кров, залунали крики і стогнання ворогів,-

і знов розскочилася юрма напасників, лишаючи на місці бою трупів і
ранених. І знов радісний крик оборонців повітав побіду товаришів, і
знов відповіли на той крик монголи градом стріл, а боярин - лютими
прокляттями. Але молодцям прийшлось тепер покидати своє висунене
становище - із жалем прощали вони те місце, з якого так щасливо
відразили перші напади монголів. Без ніякої страти, без ран, в повній
зброї і найкращім порядку, лицем до ворога, молодці відступили під
стіни боярського дому.

Коли на полуденнім боці двора молодці так щасливо відбивали напад
монголів,

ішла завзята і не так щаслива боротьба на північнім подвір'ю. І тут
монгольські стріли просвистіли без шкоди для обляжених. Тільки ж тут
монголи відразу пішли на приступ, і обляженим при-йшлось дуже гаряче.
Вони кинулись купою проти монголів, але стрічені були стрілами і
мусили вертатися, стративши трьох ранених, яких монголи зараз порубали
на кусні.

Першим ділом Максима було тепер - обійти всі становища і оглянути
добре своє положення. Живим ланцюгом обступили монголи хату і
ненастанно сипали на неї градом стріл. Обляжені також стріляли, хоч і
не так густо. Максим відразу побачив, що напасники намагають до того,
щоб вперти їх досередини хати, відки б вони не так густо могли
стріляти, а потім легка мусила б бути над ними побіда. Значить,
головна річ для оборонців була - вдержатись перед стінами дому. Але
тут вони виставлені були на густі монгольські стріли. Щоб хоч троха
захиститися від них, Максим велів повідривати двері, познімати
верхняки із столів і поуставляти їх перед кож-дим становищем як великі
щити. Із-за тих щитів безпечно і вигідно стріляли молодці на монголів,
кепкуючи собі з їх стріл.

А Максим ходив від становища до становища, обдумував нові способи
оборони

і заохочував товаришів своїм словом і прикладом.

- Держімся, товариші! говорив він.Швидко в

Тухлі почують крики або хто-будь побачить, що тут діється, і нам
прибуде поміч!

Півгодини вже тривала облога. Монголи стріляли і кляли страшно
«руських псів», що не то що не піддавалися їм, але ще сміли так уперто
і щасливо боронитися. Тугар Вовк скликав знатніших їх ватажків на
нараду, щоб обдумати який одностайний рішучий удар.

- Приступом іти! говорив один.

- Ні, приступом трудно, а стріляти, поки всіх не постріляємо,говорив
- другий.

- Постійте,сказав Тугар Вовк,на все буде час. Тепер тільки в тім річ,
- щоб позганяти їх із менших становищ. Згромадьте найбільші наші сили
- ніби до приступу, щоб відвести їх увагу, а тим часом малі відряди
- нехай рушать з обох боків до причілкових, нестережених стін. Стіни
- ті, правда, без вікон, але всетаки, коли наші люди стануть під ними,
- то будуть їм могли багато шкодити.

Ватажки пристали на тоту раду, бо вони, несвідущі в подібних маневрах,
не вміли б і такої придумати. Заворушилася монгольська сила,
забряжчала зброя, заблискотіли до сонця мечі та топори, і сміло
стискали в руках своє оружжя тухольські молодці, готуючись до тяжкого
бою. Але поки монголи радились і ладились до уданого приступу, Максим
також не дрімав. Щаслива думка прийшла до голови. В дощаній криші
боярського дому були на всі чотири боки пророблені невеличкі вікна, і
от в тих-то вікнах Максим поставив у кождім по двох слабших з своїх
людей, аби пильнували відтам усяких рухів ворога, а також старалися зі
своїх безпечних становищ шкодити йому чи то стрілами, чи камінням.
Поки один стояв при вікні, другий завше готов був достачати йому, чого
треба, а один мав доносити від них вісті товаришам надолину.

Заграли труби, і завили дикими голосами монголи, кидаючись на
противників.

Та тільки ж вони не мали на думці дійти аж зустріту з ними, але,
прибігши до пів-віддалення, разом зупинились і випустили стріли на об-
ляжених. Коли ж і обляжеш, що готовилися на останню, рішучу боротьбу,
повітали їх градом стріл

і причинили їм багато ран і страт, то вся монгольська лінія разом
подалася назад. Голосними насміхами повітали молодці той відступ.

- А що, боярине,крикнув Максим,сила великого Чінгісхана, бачиться,
- заяче серце має: розженеться і відступить! Хіба ж не стидно тобі,
- старому рицареві, ватажкувати над такими бездухами, що тільки в юрбі
- смілі, мов барани, а поєдинчо нікотрий і за півмужа не стоїть?

Боярин нічого не відповідав на той насміх; він добре бачив, що Максим
завчасно сміявсь. І сам Максим швидко побачив се.

Радісний крик монголів залунав ось-ось за причілковими стінами дому,
направо

і наліво відразу. Під час уданого монгольського приступу вони рушили
проти тих стін. Се були стіни без вікон і дверей, тож товариші не так
дуже пильнували

їх. Правда, поставлені на подрі молодці побачили надходячих із тих
боків монголів, і кілька цільних стріл упало з дахових вікон на них,
але не спинило їх, тим більше, що, стоячи при самій стіні, вони
дощаним окапом заслонені були від усякої небезпеки згори.

Максим поблід, чуючи тут же біля себе зловіщі крики і дізнавшися від
вартового з подрі, що вони значать.

«Пропали ми,- подумав він.- Про рятунок і мови нема. Тепер приходиться
«вже боротись не на життя, а на смерть».

Та й Тугар Вовк, побачивши вдачу свойого задуму, голосно порадувавсь
їй.

- А що, хлопи! крикнув він.Побачимо, чи надовго ще стане вашої
- гордості.

Глядіть, мої вояки вже під вашими стінами. Огню під стіни! Живо ми
викуримо

їх із того гнізда, а на чистім полі вони проти нас, мов миш проти
кота.

Бачить Максим, що непереливки, скликає своїх товаришів докупи, бо ніщо
вже тепер боронитись на поєдин-чих становищах, коли під причілковими
стінами гюнго-ли огонь кладуть.

- Браття,говорив він,мабуть, прийдеться нам погибати, бо на рятунок
- слаба надія, а монголи, се знайте наперед, не пощадять нікого, хто
- дістанеться в їх руки, так, як не пощадили наших ранених товаришів.
- А коли гинути, то гиньмо як мужі з оружжям у руках. Як гадаєте: чи
- будемо стояти тут і боронитися до остатнього духу, заслонені хоч
- вчасти стінами, чи волимо всі разом ударити на монголів, може б, нам
- таки удалося проломити їх ряди?

- Так, так, ударимо на монголів! закричали всі товариші.Ми ж не лиси,
- що їх стрілець викурює з ями.

- Добре, коли така ваша воля,сказав Максим Ставайте ж у три ряди, луки
- й стріли кидайте геть, а то-пори й ножі до рук і за мною!

Мов один величезний камінь, випущений із великої метавки навпроти
мурів твердині, так ударили наші молодці на монгольські ряди. Правда,
заким іще добігли до монголів, стрічені були градом стріл,- тільки ж
ті стріли нічого не зробили їм, бо перший ряд ніс перед собою замість
щита верхняк із стола, вбитий на дві списи, і в той верхняк
повпивалися монгольські стріли. Аж наближуючись до монголів, перший
ряд кинув свій дерев'яний щит - і цілий відряд кинувся на ворога з
безтямною завзятістю. Відразу змішалися монголи і почали подаватися в
боки, але Тугар Вовк був уже тут зі своїм відділом і окружив молодців
цілою громадою монголів, мов стрільці цілою ватагою псів окружають
розжертого дика. Розпочалась страшна різанина. Цілими десятками валили
хоробрі молодці монголів, але Тугар Вовк слав щораз нові роти
навпротив них. Кров бризкала далеко із скаженої сутолоки людей,
трупів, ран та кровавого оружжя. Стогнання ранених, зойки конаючих,
скажені крики убійців - усе те мішалося в якусь пекольну гармонію, що
різала вухо і серце, лунаючи під отим усміх-нутим ясним сонцем, на тлі
ситої зелені смерекових лісів та під лад ненастанного шуму холодних
потоків.

- Направо, товариші! Разом і дружно напрім на них! кричав Максим,
- відбиваючися від трьох монголів, що старалися вибити йому оружжя з
- руки. Зі страшною натугою наперли товариші направо, де лінія
- монголів була найслабіша і місце для оборони найдогідніше. По
- короткім опорі монголи подалися.

- Далі, далі женіть їх, наперед себе! кричав Максим, кидаючися зі
- своїм кровавим топором на уступаючих монголів. Товариші поперли за
- ним, і відворіт монголів швидко перемінився на пополох і безладну
- втіка-нину. А товариші гнали слідом за ними, валячи одного за другим
- іззаду на землю. Перед ними було чисте поле, а недалечке темний,
- запахущий ліс. Коли б їм удалося добігти до нього, то були б
- спасені, ніяка монгольська сила не здужала б їм тут нічого зробити.

- Далі, товариші, далі, до лісу! -кричав Максим, і без віддиху,
- мовчки, кроваві й страшні, мов справді дикі звірі, гнали товариші
- наперед себе втікаючих монголів у напрямі до лісу. Тугар Вовк одним
- позирком переглянув положення обох сторін і зареготався:

- Щаслива дорога! крикнув він услід за молодцями.На тій дорозі ми ще
- здиблемося!

І живо він відділив часть монголів і післав їх горою на тухольськнй
шлях, щоб зайшли молодців іспереду, від лісу. Він знав добре, що його
монголи впору поспіють. А сам з рештою монголів пустився навздогін за
тухоль-цями.

Три тумани куряви стояли на полю над Опором; три громадки людей гнали
за собою тим полем. Перша бігла громадка переляканих, розбитих
монголів; за ними, здоганяючи їх, наші молодці під проводом Максима, а
за ними головна сила монголів під проводом Тугара Вовка. Третій відділ
монгольський, висланий Тугаром горою навперейми, швидко десь заховався
і щез, не завважений роз'яреними в своїй погоні молодцями.

Нараз утікаючі монголи спинилися, стали. Перед ними показалася
несподівана завада: глибокий, у скалі викутий вивіз - початок
тухольського шляху. Вивіз був у тім місці майже на два сажні глибокий;
стіни його стрімкі й гладкі, так що злізти в долину зовсім не можна, а
скакати дуже небезпечно, особливо першому рядові втікачів, які могли
надіятися, що тут же за ними і па них скочить другий ряд. У
смертельній тривозі, яка й найбоязливішому не раз у остатній хвилі
додає відваги, зупинилися монголи і обернулися лицем до своїх
противників. В тій хвилі блиснула їм несподівана надія: за слідом
противників побачили настигаючих своїх одновірців - і руки їх мимоволі
вхопили за оружжя. Але сей наглий вибух відваги не був в силі спасти
їх. Мов розгу-кана буря, впали на них тухольські молодці, ломлячи и
друхочучи всі завади,- і попхнули їх до пропасті.

З зойком повалились ті, що стояли ззаду, на дно вивозу, коли тим часом
передні конали від мечів і топорів ту-хольських. Тепер молодці самі
опинилися над стрімкою стіною вивозу і затремтіли. Тут іззаду настигає
Тугар Вовк з монголами, а спереду оця страшна пропасть! Що діяти?
Хвилі розваги досить було для Максима. Вид лежачих на дні вивозу
потовчених монголів навів його на добру думку.

- Задній ряд нехай обернеться лицем до монголів і стримує на хвилю їх
- нагін, а передній кидай монгольські трупи в вивіз і скачи на них!
- кричав він.

- Гурра! закричали радісно молодці, сповняючи його розказ. Застугоніли
- теплі ще монгольські трупи, падучи додолу, заясніла для наших
- молодців надія рятунку. А втім, надлетіла монгольська погоня, Тугар
- Вовк попереду.

- Ні вже,кричав він,сим разом не уйдете моєї руки! І своїм важким
- топором повалив першого стрічного противника, що вчора ще був його
- найвірнішим лучником. Зойкнув смертельно ранений і впав під ноги
- боярина. Товариш його замахнувсь топором на Тугара, щоб помститись
- смерті товариша, але в тій хвилі його з двох боків піднято на
- монгольські списи. Цілий перший ряд молодців упав по короткім опорі.
- Се ж були самі найслабші поранені в попередній битві, що в погоні
- бігли з самого заду. Але все-таки монголів на хвилю вони спинили, а
- їх щасливіші товариші були вже безпечні на дні вивозу.

- Стійте! кричав до своїх Максим.В ряди і під стіну вивозу! Коли
- схотять гнатися за нами, то тут їм справимо кроваву купіль.

- Перший ряд скачи за ними,командував у нерозважнім запалі Тугар Вовк.
- І скочив перший ряд монголів, але не встав уже живий, ба многі й до
- землі не долетіли живі, стрічені в повітрі топорами молодців.

- Гурра! закричали ті, радуючись.Ану, другий ряд, скачи також!

Але другий ряд стояв над вивозом і не квапився скакати. Тугар Вовк
побачив свою помилку і швидко вислав сильний відділ нижче, щоб
іздолини замкнути вихід вивозу.

- Тепер не уйдуть нам пташки,радувався він.От уже мої ловці надходять!
- Ану, діти, далі на них!

Скажений крик монголів залунав у вивозі, тут же під ногами Тугара
Вовка. Се був відділ, висланий горою •навперейми; вниз вивозом він
ударив тепер на ту- хольців.

- Вниз вивозом утікаймо! скрикнули молодці, але один позирк переконав
- їх, що вся надія на рятунок пропала. При вході внизу чорнілася вже
- друга купа монголів, що йшла навпроти них, щоб їх зовсім замкнути в
- тій кам'яній клітці.

- Аж тепер смерть наша! сказав Максим, обтираючи о кожух забитого, при
- його ногах лежачого монгола свій кровавий топір.Товариші, сміло до
- остатнього бою!

Та й сміло ж виступили вони! Добуваючи остатніх сил, ударили на
монголів і, невважаючи на некорисну, згористу місцевість, що сприяла
монголам, ще раз змішали їх, ще раз завдали їм велику страту. Але
монголи силою свого розгону поперли їх у долину і розбили їх ряди. В
геройській обороні падали молодці один за другим, тільки Максим, хоч
бився, як лев, прецінь не мав іще рани на своїм тілі. Монголи уникали
його, а коли тислися на нього, то тільки в надії витрутити йому оружжя
з руки і взяти його живого. Такий був виразний наказ

Ту-гара Вовка.

Ось наступив і другий відділ монгольський з долини; молодців стиснено
в тій безвихідній кам'яній кліті, приперто їх до стіни, і лиш тілько
вільного місця було перед ними, кілько могли його зробити своїми
мечами та топорами. Але руки їх зачали ослабати, а монголи пруться і
пруться на них, мов хвилі повені. Вже деякі, стративши всяку надію і
бачачи неможливість дальшої боротьби, наосліп кинулися в найгустіші
ряди монголів і в одній хвилі погибали, розсікані топорами. Інші,
шепчучи молитви, тулилися ще до стіни, мов вона могла дати їм яку-
небудь поміч; треті хоть і ніби боронилися, але безтямно, машинально
махали топорами, і смертельні удари монголів заставали їх уже трупами,
нечутливими й бездушними. Тільки невеличка горстка найсильніших -
п'ять їх було,- окруживши Максима, держалися ще просто, мов шпиль
скали серед розгуканої заливи. Три приступи монголів відбила вже та
горстка, стоячи на купі трупів, мов на башті; вже мечі й топори в
руках героїв затулилися, одіж їх, руки й лиця скрізь заплили кров'ю,
але все ще різко й виразно відзивався голос Максима, що загрівав
товаришів до оборони. Тугар Вовк на-півгнівно, напів з подивом глядів
на молодця згори.

- їй-богу, славний молодець! сказав він сам до себе.Не дивуюсь, що він
- очарував мою доньку. І мене самого він міг би очарувати своєю
- рицарською вдачею!

А потім, обертаючися до своїх монголів, що стояли над берегом яру, він
крикнув:

- Далі, скачіть на них! Нехай скінчиться та різанина. Лиш сього
- (показав на

Максима) не тикайте!

І разом, мов важка скала, скочили монголи згори на не побіджену ще
купку героїв і повалили їх на землю. Ще раз залунали скажені крики, ще
борикалися напід-сили монголи з тухольцями, але недовго. На кождого з
героїв навалилася ціла юрба монголів - і всі полягли головами. Тільки
Максим сам-один стояв іще, мов дуб серед поля. Він розсік голову тому
монголові, що скочив був на нього, і саме замахнувся на другого, коли
втім якась сильна рука залізним стиском ухопила його ззаду за горло і
кинула ним до землі. Упав, підступно повалений,

Максим, і над ним, почервоніле від гніву й натуги, нахилилося лице
Тугара

Вовка.

- А що, смерде! насмішливо кричав боярин.Бачиш тепер, що я вмію
- додержати слова? Ану, діти, закуйте його в залізні пута!

- Хоч і в путах, я все буду вольний чоловік. У мене пута на руках, а в
- тебе на душі! сказав Максим.

Боярин зареготався і відійшов від нього давати порядок монгольському
війську, якого число сильно змаліло в тій кровавій різанині. З
головною частиною оставших іще монголів Тугар Вовк пішов до своєї
хати; решті велів обсадити нещасний, тепер трупами завалений вивіз.
Виділивши всіх здорових до стереження вивозу, сам він з невеличкою
рештою і взятим до неволі Максимом мав вернутися до табору.

- Прокляті хлопи! буркотів боярин, переглядаючи свої страти.Скілько
- народу понівечили! Ну, але чорт бери монголів їх не шкода! Коб
- тільки мені по тих трупах дійти до власті й сили,обернувся б і я
- лицем проти них. Але сей поганець, сей Максим,то мені борець! А хто
- знає, може, й він міг би послужити до моєї цілі? Треба використати
- його, коли його маю в руках. Він мусить служити нам за провідника в
- горах, бо чорт їх там знає, який се той їх шлях і чи нема де на нім
- яких манівців. Тепер, коли він у моїх руках, треба приєднати,
- вкоськати його троха, хто знає, на що ще може він пригодитися.

А тим часом монголи готовили вже коней до від'їзду. Максиїл,- скований
за руки і за ноги в тяжкі ланцюги, кровавий, простоволосий, із
пошарпаною на шматки одежею,- сидів на камені над річкою, німий, з
затиснени-ми зубами і з розпукою в серці. Перед ним на полі і в вивозі
купами лежали не застиглі ще, пошматовані і кров'ю оббризкані трупи
його товаришів і ворогів. Які щасливі були ті трупи! Вони лежали так
тихо, так сумирно на своїй кровавій постелі, без гніву, без муки, без
ворогування. Вони сміялись тепер зі всяких пут, із цілої сили великого
Чінгісхана, а його кусень заліза зробив бездушним знарядом у руках
дикої самоволі, жертвою крова-вої пімсти! Які щасливі були трупи!
Вони, хоч покалічені, носили на собі образ і подобу людську,- а його
оці пута в одній хвилі зробили скотиною, невольником!

- Сонце праведне! кликнув у своїй душевній муці Максим.Невже ж така
- твоя воля, щоб я гинув у кайданах? Невже ж ти так часто своїм ясним
- усміхом вітало дні моєї радості на те лише, щоб сьогодні повітати
- моє бездонне горе? Сонце, невже ж ти перестало бути добрим богом
- Тухольщини, а сталося опікуном тих лютих дикунів? . А сонце
- сміялося! Ясним, гарячим промінням воно блискотіло в калюжах крові,
- цілувало посинілі уста і глибокі рани трупів, крізь які витікав
- мозок, вистирчу-вали теплі ще людські тельбухи. І таким самим ясним,
- гарячим промінням воно обливало зелений ліс, і чудові запахущі
- цвіти, і високі полонини, що купалися в чистім лазуровім ефірі.
- Сонце сміялося і своїм божеським, без-учасним усміхом ще дужче
- ранило роздерту Максимову Душу.

EOT;

    /*
    *** START: FULL LICENSE ***

    Creative Commons Legal Code

    Attribution-ShareAlike 3.0 Unported


    CREATIVE COMMONS CORPORATION IS NOT A LAW FIRM AND DOES NOT PROVIDE
    LEGAL SERVICES. DISTRIBUTION OF THIS LICENSE DOES NOT CREATE AN
    ATTORNEY-CLIENT RELATIONSHIP. CREATIVE COMMONS PROVIDES THIS
    INFORMATION ON AN "AS-IS" BASIS. CREATIVE COMMONS MAKES NO WARRANTIES
    REGARDING THE INFORMATION PROVIDED, AND DISCLAIMS LIABILITY FOR
    DAMAGES RESULTING FROM ITS USE. License

    THE WORK (AS DEFINED BELOW) IS PROVIDED UNDER THE TERMS OF THIS
    CREATIVE COMMONS PUBLIC LICENSE ("CCPL" OR "LICENSE"). THE WORK IS
    PROTECTED BY COPYRIGHT AND/OR OTHER APPLICABLE LAW. ANY USE OF THE
    WORK OTHER THAN AS AUTHORIZED UNDER THIS LICENSE OR COPYRIGHT LAW IS
    PROHIBITED.

    BY EXERCISING ANY RIGHTS TO THE WORK PROVIDED HERE, YOU ACCEPT AND
    AGREE TO BE BOUND BY THE TERMS OF THIS LICENSE. TO THE EXTENT THIS
    LICENSE MAY BE CONSIDERED TO BE A CONTRACT, THE LICENSOR GRANTS YOU
    THE RIGHTS CONTAINED HERE IN CONSIDERATION OF YOUR ACCEPTANCE OF SUCH
    TERMS AND CONDITIONS.

    1. Definitions

    "Adaptation" means a work based upon the Work, or upon the Work and
    other pre-existing works, such as a translation, adaptation,
    derivative work, arrangement of music or other alterations of a
    literary or artistic work, or phonogram or performance and includes
    cinematographic adaptations or any other form in which the Work may be
    recast, transformed, or adapted including in any form recognizably
    derived from the original, except that a work that constitutes a
    Collection will not be considered an Adaptation for the purpose of
    this License. For the avoidance of doubt, where the Work is a musical
    work, performance or phonogram, the synchronization of the Work in
    timed-relation with a moving image ("synching") will be considered an
    Adaptation for the purpose of this License. "Collection" means a
    collection of literary or artistic works, such as encyclopedias and
    anthologies, or performances, phonograms or broadcasts, or other works
    or subject matter other than works listed in Section 1(f) below,
    which, by reason of the selection and arrangement of their contents,
    constitute intellectual creations, in which the Work is included in
    its entirety in unmodified form along with one or more other
    contributions, each constituting separate and independent works in
    themselves, which together are assembled into a collective whole. A
    work that constitutes a Collection will not be considered an
    Adaptation (as defined below) for the purposes of this License.
    "Creative Commons Compatible License" means a license that is listed
    at http://creativecommons.org/compatiblelicenses that has been
    approved by Creative Commons as being essentially equivalent to this
    License, including, at a minimum, because that license: (i) contains
    terms that have the same purpose, meaning and effect as the License
    Elements of this License; and, (ii) explicitly permits the relicensing
    of adaptations of works made available under that license under this
    License or a Creative Commons jurisdiction license with the same
    License Elements as this License. "Distribute" means to make available
    to the public the original and copies of the Work or Adaptation, as
    appropriate, through sale or other transfer of ownership. "License
    Elements" means the following high-level license attributes as
    selected by Licensor and indicated in the title of this License:
    Attribution, ShareAlike. "Licensor" means the individual, individuals,
    entity or entities that offer(s) the Work under the terms of this
    License. "Original Author" means, in the case of a literary or
    artistic work, the individual, individuals, entity or entities who
    created the Work or if no individual or entity can be identified, the
    publisher; and in addition (i) in the case of a performance the
    actors, singers, musicians, dancers, and other persons who act, sing,
    deliver, declaim, play in, interpret or otherwise perform literary or
    artistic works or expressions of folklore; (ii) in the case of a
    phonogram the producer being the person or legal entity who first
    fixes the sounds of a performance or other sounds; and, (iii) in the
    case of broadcasts, the organization that transmits the broadcast.
    "Work" means the literary and/or artistic work offered under the terms
    of this License including without limitation any production in the
    literary, scientific and artistic domain, whatever may be the mode or
    form of its expression including digital form, such as a book,
    pamphlet and other writing; a lecture, address, sermon or other work
    of the same nature; a dramatic or dramatico-musical work; a
    choreographic work or entertainment in dumb show; a musical
    composition with or without words; a cinematographic work to which are
    assimilated works expressed by a process analogous to cinematography;
    a work of drawing, painting, architecture, sculpture, engraving or
    lithography; a photographic work to which are assimilated works
    expressed by a process analogous to photography; a work of applied
    art; an illustration, map, plan, sketch or three-dimensional work
    relative to geography, topography, architecture or science; a
    performance; a broadcast; a phonogram; a compilation of data to the
    extent it is protected as a copyrightable work; or a work performed by
    a variety or circus performer to the extent it is not otherwise
    considered a literary or artistic work. "You" means an individual or
    entity exercising rights under this License who has not previously
    violated the terms of this License with respect to the Work, or who
    has received express permission from the Licensor to exercise rights
    under this License despite a previous violation. "Publicly Perform"
    means to perform public recitations of the Work and to communicate to
    the public those public recitations, by any means or process,
    including by wire or wireless means or public digital performances; to
    make available to the public Works in such a way that members of the
    public may access these Works from a place and at a place individually
    chosen by them; to perform the Work to the public by any means or
    process and the communication to the public of the performances of the
    Work, including by public digital performance; to broadcast and
    rebroadcast the Work by any means including signs, sounds or images.
    "Reproduce" means to make copies of the Work by any means including
    without limitation by sound or visual recordings and the right of
    fixation and reproducing fixations of the Work, including storage of a
    protected performance or phonogram in digital form or other electronic
    medium. 2. Fair Dealing Rights. Nothing in this License is intended to
    reduce, limit, or restrict any uses free from copyright or rights
    arising from limitations or exceptions that are provided for in
    connection with the copyright protection under copyright law or other
    applicable laws.

    3. License Grant. Subject to the terms and conditions of this License,
    Licensor hereby grants You a worldwide, royalty-free, non-exclusive,
    perpetual (for the duration of the applicable copyright) license to
    exercise the rights in the Work as stated below:

    to Reproduce the Work, to incorporate the Work into one or more
    Collections, and to Reproduce the Work as incorporated in the
    Collections; to create and Reproduce Adaptations provided that any
    such Adaptation, including any translation in any medium, takes
    reasonable steps to clearly label, demarcate or otherwise identify
    that changes were made to the original Work. For example, a
    translation could be marked "The original work was translated from
    English to Spanish," or a modification could indicate "The original
    work has been modified."; to Distribute and Publicly Perform the Work
    including as incorporated in Collections; and, to Distribute and
    Publicly Perform Adaptations. For the avoidance of doubt:

    Non-waivable Compulsory License Schemes. In those jurisdictions in
    which the right to collect royalties through any statutory or
    compulsory licensing scheme cannot be waived, the Licensor reserves
    the exclusive right to collect such royalties for any exercise by You
    of the rights granted under this License; Waivable Compulsory License
    Schemes. In those jurisdictions in which the right to collect
    royalties through any statutory or compulsory licensing scheme can be
    waived, the Licensor waives the exclusive right to collect such
    royalties for any exercise by You of the rights granted under this
    License; and, Voluntary License Schemes. The Licensor waives the right
    to collect royalties, whether individually or, in the event that the
    Licensor is a member of a collecting society that administers
    voluntary licensing schemes, via that society, from any exercise by
    You of the rights granted under this License. The above rights may be
    exercised in all media and formats whether now known or hereafter
    devised. The above rights include the right to make such modifications
    as are technically necessary to exercise the rights in other media and
    formats. Subject to Section 8(f), all rights not expressly granted by
    Licensor are hereby reserved.

    4. Restrictions. The license granted in Section 3 above is expressly
    made subject to and limited by the following restrictions:

    You may Distribute or Publicly Perform the Work only under the terms
    of this License. You must include a copy of, or the Uniform Resource
    Identifier (URI) for, this License with every copy of the Work You
    Distribute or Publicly Perform. You may not offer or impose any terms
    on the Work that restrict the terms of this License or the ability of
    the recipient of the Work to exercise the rights granted to that
    recipient under the terms of the License. You may not sublicense the
    Work. You must keep intact all notices that refer to this License and
    to the disclaimer of warranties with every copy of the Work You
    Distribute or Publicly Perform. When You Distribute or Publicly
    Perform the Work, You may not impose any effective technological
    measures on the Work that restrict the ability of a recipient of the
    Work from You to exercise the rights granted to that recipient under
    the terms of the License. This Section 4(a) applies to the Work as
    incorporated in a Collection, but this does not require the Collection
    apart from the Work itself to be made subject to the terms of this
    License. If You create a Collection, upon notice from any Licensor You
    must, to the extent practicable, remove from the Collection any credit
    as required by Section 4(c), as requested. If You create an
    Adaptation, upon notice from any Licensor You must, to the extent
    practicable, remove from the Adaptation any credit as required by
    Section 4(c), as requested. You may Distribute or Publicly Perform an
    Adaptation only under the terms of: (i) this License; (ii) a later
    version of this License with the same License Elements as this
    License; (iii) a Creative Commons jurisdiction license (either this or
    a later license version) that contains the same License Elements as
    this License (e.g., Attribution-ShareAlike 3.0 US)); (iv) a Creative
    Commons Compatible License. If you license the Adaptation under one of
    the licenses mentioned in (iv), you must comply with the terms of that
    license. If you license the Adaptation under the terms of any of the
    licenses mentioned in (i), (ii) or (iii) (the "Applicable License"),
    you must comply with the terms of the Applicable License generally and
    the following provisions: (I) You must include a copy of, or the URI
    for, the Applicable License with every copy of each Adaptation You
    Distribute or Publicly Perform; (II) You may not offer or impose any
    terms on the Adaptation that restrict the terms of the Applicable
    License or the ability of the recipient of the Adaptation to exercise
    the rights granted to that recipient under the terms of the Applicable
    License; (III) You must keep intact all notices that refer to the
    Applicable License and to the disclaimer of warranties with every copy
    of the Work as included in the Adaptation You Distribute or Publicly
    Perform; (IV) when You Distribute or Publicly Perform the Adaptation,
    You may not impose any effective technological measures on the
    Adaptation that restrict the ability of a recipient of the Adaptation
    from You to exercise the rights granted to that recipient under the
    terms of the Applicable License. This Section 4(b) applies to the
    Adaptation as incorporated in a Collection, but this does not require
    the Collection apart from the Adaptation itself to be made subject to
    the terms of the Applicable License. If You Distribute, or Publicly
    Perform the Work or any Adaptations or Collections, You must, unless a
    request has been made pursuant to Section 4(a), keep intact all
    copyright notices for the Work and provide, reasonable to the medium
    or means You are utilizing: (i) the name of the Original Author (or
    pseudonym, if applicable) if supplied, and/or if the Original Author
    and/or Licensor designate another party or parties (e.g., a sponsor
    institute, publishing entity, journal) for attribution ("Attribution
    Parties") in Licensor's copyright notice, terms of service or by other
    reasonable means, the name of such party or parties; (ii) the title of
    the Work if supplied; (iii) to the extent reasonably practicable, the
    URI, if any, that Licensor specifies to be associated with the Work,
    unless such URI does not refer to the copyright notice or licensing
    information for the Work; and (iv) , consistent with Ssection 3(b), in
    the case of an Adaptation, a credit identifying the use of the Work in
    the Adaptation (e.g., "French translation of the Work by Original
    Author," or "Screenplay based on original Work by Original Author").
    The credit required by this Section 4(c) may be implemented in any
    reasonable manner; provided, however, that in the case of a Adaptation
    or Collection, at a minimum such credit will appear, if a credit for
    all contributing authors of the Adaptation or Collection appears, then
    as part of these credits and in a manner at least as prominent as the
    credits for the other contributing authors. For the avoidance of
    doubt, You may only use the credit required by this Section for the
    purpose of attribution in the manner set out above and, by exercising
    Your rights under this License, You may not implicitly or explicitly
    assert or imply any connection with, sponsorship or endorsement by the
    Original Author, Licensor and/or Attribution Parties, as appropriate,
    of You or Your use of the Work, without the separate, express prior
    written permission of the Original Author, Licensor and/or Attribution
    Parties. Except as otherwise agreed in writing by the Licensor or as
    may be otherwise permitted by applicable law, if You Reproduce,
    Distribute or Publicly Perform the Work either by itself or as part of
    any Adaptations or Collections, You must not distort, mutilate, modify
    or take other derogatory action in relation to the Work which would be
    prejudicial to the Original Author's honor or reputation. Licensor
    agrees that in those jurisdictions (e.g. Japan), in which any exercise
    of the right granted in Section 3(b) of this License (the right to
    make Adaptations) would be deemed to be a distortion, mutilation,
    modification or other derogatory action prejudicial to the Original
    Author's honor and reputation, the Licensor will waive or not assert,
    as appropriate, this Section, to the fullest extent permitted by the
    applicable national law, to enable You to reasonably exercise Your
    right under Section 3(b) of this License (right to make Adaptations)
    but not otherwise. 5. Representations, Warranties and Disclaimer

    UNLESS OTHERWISE MUTUALLY AGREED TO BY THE PARTIES IN WRITING,
    LICENSOR OFFERS THE WORK AS-IS AND MAKES NO REPRESENTATIONS OR
    WARRANTIES OF ANY KIND CONCERNING THE WORK, EXPRESS, IMPLIED,
    STATUTORY OR OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES OF
    TITLE, MERCHANTIBILITY, FITNESS FOR A PARTICULAR PURPOSE,
    NONINFRINGEMENT, OR THE ABSENCE OF LATENT OR OTHER DEFECTS, ACCURACY,
    OR THE PRESENCE OF ABSENCE OF ERRORS, WHETHER OR NOT DISCOVERABLE.
    SOME JURISDICTIONS DO NOT ALLOW THE EXCLUSION OF IMPLIED WARRANTIES,
    SO SUCH EXCLUSION MAY NOT APPLY TO YOU.

    6. Limitation on Liability. EXCEPT TO THE EXTENT REQUIRED BY
    APPLICABLE LAW, IN NO EVENT WILL LICENSOR BE LIABLE TO YOU ON ANY
    LEGAL THEORY FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL, PUNITIVE OR
    EXEMPLARY DAMAGES ARISING OUT OF THIS LICENSE OR THE USE OF THE WORK,
    EVEN IF LICENSOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

    7. Termination

    This License and the rights granted hereunder will terminate
    automatically upon any breach by You of the terms of this License.
    Individuals or entities who have received Adaptations or Collections
    from You under this License, however, will not have their licenses
    terminated provided such individuals or entities remain in full
    compliance with those licenses. Sections 1, 2, 5, 6, 7, and 8 will
    survive any termination of this License. Subject to the above terms
    and conditions, the license granted here is perpetual (for the
    duration of the applicable copyright in the Work). Notwithstanding the
    above, Licensor reserves the right to release the Work under different
    license terms or to stop distributing the Work at any time; provided,
    however that any such election will not serve to withdraw this License
    (or any other license that has been, or is required to be, granted
    under the terms of this License), and this License will continue in
    full force and effect unless terminated as stated above. 8.
    Miscellaneous

    Each time You Distribute or Publicly Perform the Work or a Collection,
    the Licensor offers to the recipient a license to the Work on the same
    terms and conditions as the license granted to You under this License.
    Each time You Distribute or Publicly Perform an Adaptation, Licensor
    offers to the recipient a license to the original Work on the same
    terms and conditions as the license granted to You under this License.
    If any provision of this License is invalid or unenforceable under
    applicable law, it shall not affect the validity or enforceability of
    the remainder of the terms of this License, and without further action
    by the parties to this agreement, such provision shall be reformed to
    the minimum extent necessary to make such provision valid and
    enforceable. No term or provision of this License shall be deemed
    waived and no breach consented to unless such waiver or consent shall
    be in writing and signed by the party to be charged with such waiver
    or consent. This License constitutes the entire agreement between the
    parties with respect to the Work licensed here. There are no
    understandings, agreements or representations with respect to the Work
    not specified here. Licensor shall not be bound by any additional
    provisions that may appear in any communication from You. This License
    may not be modified without the mutual written agreement of the
    Licensor and You. The rights granted under, and the subject matter
    referenced, in this License were drafted utilizing the terminology of
    the Berne Convention for the Protection of Literary and Artistic Works
    (as amended on September 28, 1979), the Rome Convention of 1961, the
    WIPO Copyright Treaty of 1996, the WIPO Performances and Phonograms
    Treaty of 1996 and the Universal Copyright Convention (as revised on
    July 24, 1971). These rights and subject matter take effect in the
    relevant jurisdiction in which the License terms are sought to be
    enforced according to the corresponding provisions of the
    implementation of those treaty provisions in the applicable national
    law. If the standard suite of rights granted under applicable
    copyright law includes additional rights not granted under this
    License, such additional rights are deemed to be included in the
    License; this License is not intended to restrict the license of any
    rights under applicable law. Creative Commons Notice

    Creative Commons is not a party to this License, and makes no warranty
    whatsoever in connection with the Work. Creative Commons will not be
    liable to You or any party on any legal theory for any damages
    whatsoever, including without limitation any general, special,
    incidental or consequential damages arising in connection to this
    license. Notwithstanding the foregoing two (2) sentences, if Creative
    Commons has expressly identified itself as the Licensor hereunder, it
    shall have all rights and obligations of Licensor.

    Except for the limited purpose of indicating to the public that the
    Work is licensed under the CCPL, Creative Commons does not authorize
    the use by either party of the trademark "Creative Commons" or any
    related trademark or logo of Creative Commons without the prior
    written consent of Creative Commons. Any permitted use will be in
    compliance with Creative Commons' then-current trademark usage
    guidelines, as may be published on its website or otherwise made
    available upon request from time to time. For the avoidance of doubt,
    this trademark restriction does not form part of the License.

    Creative Commons may be contacted at http://creativecommons.org/.

    */
}
